package jaxx.runtime.swing;

import java.awt.Color;
import java.awt.event.ActionListener;
import javax.swing.Timer;

/**
 *
 * @author chemit
 * @since 1.6.0
 */
public class StatusMessagePanelHandler {

    protected Color statusForeground = null;
    protected String statusReferenceContent = null;
    protected javax.swing.Timer timer = null;

    protected void fadeStatus(StatusMessagePanel ui) {
        for (int i = 0; i < 8; i++) {
            // synchronized (this) {
            if (!statusReferenceContent.equals(ui.getStatusLabel().getText())) {
                return;
            }
            Color currentForeground = ui.getStatusLabel().getForeground();
            Color newColor = new Color(currentForeground.getRed(),
                    currentForeground.getGreen(), currentForeground.getBlue(),
                    currentForeground.getAlpha() - 25);
            ui.getStatusLabel().setForeground(newColor);
            ui.getStatusLabel().repaint();
            // }
            // TC-2000311 je comprends pas a quoi ca sert, a part frizzer les ui ?
            // si on utilise un Timer, pourquoi utiliser ça ?
            /*try {
            Thread.sleep(200);
            } catch (InterruptedException eee) {
            eee.printStackTrace();
            }*/
        }
    }

    protected void startStatusFader(StatusMessagePanel ui) {
        statusReferenceContent = ui.getStatusLabel().getText();

        int millisecondsPerMinute = 5000;
        timer = new Timer(millisecondsPerMinute, (ActionListener) ui);
        timer.setRepeats(false);
        timer.setInitialDelay((int) ((long) millisecondsPerMinute - System.currentTimeMillis() % (long) millisecondsPerMinute) + 500);
        timer.start();
    }

    protected void stopStatusFader(StatusMessagePanel ui) {
        if (timer != null) {
            timer.stop();
            ui.getStatusLabel().setForeground(statusForeground);
        }
    }
}
