/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jaxx.runtime.Decorator;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JXPathDecorator<O>
extends Decorator<O> {
    private static final Log log = LogFactory.getLog(JXPathDecorator.class);
    private static final long serialVersionUID = 1L;
    protected Context<O> context;
    protected int nbToken;
    protected String initialExpression;

    public static <O> JXPathDecorator<O> newDecorator(Class<O> internalClass, String expression) throws IllegalArgumentException, NullPointerException {
        return new JXPathDecorator<O>(internalClass, expression, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <O> void sort(JXPathDecorator<O> decorator, List<O> datas, int pos) {
        Comparator<O> c = null;
        boolean cachedComparator = false;
        try {
            c = decorator.getComparator(pos);
            cachedComparator = c instanceof JXPathComparator;
            if (cachedComparator) {
                ((JXPathComparator)c).init(decorator, datas);
            }
            Collections.sort(datas, c);
        }
        finally {
            if (cachedComparator) {
                ((JXPathComparator)c).clear();
            }
        }
    }

    @Override
    public String toString(Object bean) {
        if (bean == null) {
            return null;
        }
        JXPathContext jxcontext = JXPathContext.newContext((Object)bean);
        Object[] args = new Object[this.nbToken];
        for (int i = 0; i < this.nbToken; ++i) {
            try {
                args[i] = this.getTokenValue(jxcontext, this.context.tokens[i]);
                continue;
            }
            catch (Exception e) {
                log.error((Object)("can not obtain token " + this.context.tokens[i] + "on object " + bean + " for reason " + e.getMessage()), (Throwable)e);
            }
        }
        return String.format(this.context.expression, args);
    }

    protected Comparable<Comparable<?>> getTokenValue(JXPathContext jxcontext, String token) {
        return (Comparable)jxcontext.getValue(token);
    }

    public String getProperty(int pos) {
        return this.getTokens()[pos];
    }

    public String getExpression() {
        return this.context.expression;
    }

    public String[] getTokens() {
        return this.context.tokens;
    }

    public int getNbToken() {
        return this.nbToken;
    }

    public String getInitialExpression() {
        return this.initialExpression;
    }

    public String toString() {
        return super.toString() + "<" + this.context + ">";
    }

    public void setContext(Context<O> context) {
        this.context = context;
        this.nbToken = context.tokens.length;
        if (log.isDebugEnabled()) {
            log.debug(context);
        }
    }

    public JXPathDecorator(Class<O> internalClass, String expression, boolean creatContext) throws IllegalArgumentException, NullPointerException {
        super(internalClass);
        this.initialExpression = expression;
        if (creatContext) {
            this.setContext(JXPathDecorator.createInitialContext(expression));
            if (log.isDebugEnabled()) {
                log.debug((Object)(expression + " --> " + this.context));
            }
        }
    }

    protected Comparator<O> getComparator(int pos) {
        JXPathDecorator.ensureTokenIndex(this, pos);
        return this.context.getComparator(pos);
    }

    public static <O> Context<O> createInitialContext(String expression) {
        int start;
        ArrayList<String> lTokens = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        int size = expression.length();
        int end = -1;
        while ((start = expression.indexOf("${", end + 1)) > -1) {
            if (start > end + 1) {
                buffer.append(expression.substring(end + 1, start));
            }
            if ((end = expression.indexOf("}", start + 1)) == -1) {
                throw new IllegalArgumentException("could not find the rigth brace starting at car " + start + " : " + expression.substring(start + 2));
            }
            String jxpath = expression.substring(start + 2, end);
            if (jxpath.indexOf("${") > -1) {
                throw new IllegalArgumentException("could not find a ${ inside a jxpath expression at car " + (start + 2) + " : " + jxpath);
            }
            lTokens.add(jxpath);
            buffer.append("%").append(lTokens.size());
        }
        if (size > end + 1) {
            buffer.append(expression.substring(end + 1));
        }
        return new Context(buffer.toString(), lTokens.toArray(new String[lTokens.size()]));
    }

    protected static void ensureTokenIndex(JXPathDecorator<?> decorator, int pos) {
        if (pos < -1 || pos > decorator.getNbToken()) {
            throw new ArrayIndexOutOfBoundsException("token index " + pos + " is out of bound, can be inside [" + 0 + "," + decorator.nbToken + "]");
        }
    }

    public static class Context<O>
    implements Serializable {
        protected String expression;
        protected String[] tokens;
        protected transient Comparator<O> comparator;
        private static final long serialVersionUID = 1L;

        public Context(String expression, String[] tokens) {
            this.expression = expression;
            this.tokens = tokens;
        }

        public String getFirstProperty() {
            return this.tokens[0];
        }

        public Comparator<O> getComparator(int pos) {
            if (this.comparator == null) {
                this.comparator = new JXPathComparator(this.tokens[pos]);
            }
            return this.comparator;
        }

        public void setComparator(Comparator<O> comparator) {
            this.comparator = comparator;
        }

        public String toString() {
            return "<expression:" + this.expression + ", tokens:" + Arrays.toString(this.tokens) + ">";
        }
    }

    public static class JXPathComparator<O>
    implements Comparator<O> {
        protected Map<O, Comparable<Comparable<?>>> valueCache;
        private final String expression;

        public JXPathComparator(String expression) {
            this.expression = expression;
            this.valueCache = new HashMap();
        }

        @Override
        public int compare(O o1, O o2) {
            Comparable<Comparable<?>> c1 = this.valueCache.get(o1);
            Comparable<Comparable<?>> c2 = this.valueCache.get(o2);
            return c1.compareTo(c2);
        }

        public void clear() {
            this.valueCache.clear();
        }

        public void init(JXPathDecorator<O> decorator, List<O> datas) {
            this.clear();
            for (O data : datas) {
                JXPathContext jxcontext = JXPathContext.newContext(data);
                Comparable<Comparable<?>> key = decorator.getTokenValue(jxcontext, this.expression);
                this.valueCache.put(data, key);
            }
        }
    }
}

