package jaxx.runtime.validator;

/**
 * The object to box a validation message.
 *
 * @param <E> type of message (use for override {@link #compareTo(E)} method.
 * 
 * @author chemit
 * @since 1.3
 */
public class BeanValidatorMessage<E extends BeanValidatorMessage> implements Comparable<E> {

    /**
     * the validator that produce the message
     */
    protected BeanValidator validator;
    /**
     * the field thatproduce the message
     */
    protected BeanValidatorField field;
    /**
     * the label of the message (to be displayed somewhere)
     */
    protected String message;
    /**
     * the scope of the message
     */
    protected BeanValidatorScope scope;

    public BeanValidatorMessage(BeanValidator validator, BeanValidatorField field, String message, BeanValidatorScope scope) {
        this.field = field;
        this.validator = validator;
        this.message = message;
        this.scope = scope;
    }

    public BeanValidator getValidator() {
        return validator;
    }

    public BeanValidatorField getField() {
        return field;
    }

    public BeanValidatorScope getScope() {
        return scope;
    }

    public String getMessage() {
        return message;
    }

    @Override
    public int compareTo(E o) {
        // sort on scope
        int result = getScope().compareTo(o.getScope());
        if (result == 0) {
            // sort on field name
            result = field.getName().compareTo(o.field.getName());
            if (result == 0) {
                // sort on message
                result = message.compareTo(o.message);
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return scope + " - " + field.getI18nError(message);
    }
}
