package jaxx.runtime;

/**
 * A simple contract to define a String decorator on any java objet.
 *
 * @param <O> the type of decorated object
 * @author chemit
 */
public abstract class Decorator<O> implements java.io.Serializable {

    protected final Class<O> internalClass;
    private static final long serialVersionUID = -1L;

    /**
     * @param internalClass the class of objects to be decorated.
     * @throws NullPointerException if internalClass parameter is null
     */
    public Decorator(Class<O> internalClass) throws NullPointerException {
        if (internalClass == null) {
            throw new NullPointerException("internalClass can not be null.");
        }
        this.internalClass = internalClass;
    }

    /**
     * @param bean the bean to decorate
     * @return the string value of the given bean
     */
    public abstract String toString(Object bean);


    public final Class<O> getInternalClass() {
        return internalClass;
    }

}
