package jaxx.demo.feature.databinding;

/*
 * #%L
 * JAXX :: Demo
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class BeanDataBindingDemo extends BaseBeanDataBinding {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EDITING3 = "editing3";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDIT3_ENABLED = "edit3.enabled";
    public static final String BINDING_EDIT3_TEXT = "edit3.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JBUTTON1_VISIBLE = "$JButton1.visible";
    private static final String BINDING_$JBUTTON2_VISIBLE = "$JButton2.visible";
    private static final String BINDING_$JBUTTON3_VISIBLE = "$JButton3.visible";
    private static final String BINDING_$JBUTTON4_VISIBLE = "$JButton4.visible";
    private static final String BINDING_$JBUTTON5_VISIBLE = "$JButton5.visible";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";
    private static final String BINDING_$JTEXT_FIELD0_ENABLED = "$JTextField0.enabled";
    private static final String BINDING_$JTEXT_FIELD1_ENABLED = "$JTextField1.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TURCeVtpSQFEqCIpapUYT41ZADgYELKTBpqgRDoRefGWfsGS7u+57C8vF+Cf4J+jdi4k3T8aDZw9ejP+CMR68Gue9Lf1Bt9tNdg+7m5lvvvlm3pt5/wsSzIZr+8R1FdsxuFajSunh1taT6j7d4auU7diaxU0bvCcWh3gFBtWGnXGYqpRFeL4enl8xa5ZpUKMler4MA4wf6ZTtUco5XG6P2GEsv9Fwz7uWYx+zNkT5sb798zv+Rn39Lg7gWqjuLJaS7RXVrKSvDHFN5TCCmQ5IXifGLsqwNWMX9Z4WthWdMPaY1OhLeAWpMiQtYiMZh+vhS5YcMt61OIzmCoTRAiXGKuGkoBkqprvLYVrKVmnNVF5Qwh2bKioCqh5AORGwijjLkqxJDv1U1ThaZzmcE6oVUYlSME0do5qwVG6TVHWKycbbesQORQbpE8h0kzdXKpMq1TFiRPC6dahnFaDhVuxTYvhgpbUdm86VCg7npoHgTBvYMwvYaCd6WhgutjuHcqVN6vKiRnUV2cba2Boef6mS70IXaTONZNlO56yPs1WJZL7qn3UmKOu9BvGtTuecjzMhjn62NZ0Nl9pOF2dLac5W8/LHKpCwHTTjdah0juMzdHmDOH5iEAWh9P4by3z/9PNj8Xj6zmPuUV9oy/LAqbBs06I210TqYW/0HK7p+XVizVcgzaiOm0dulkkfYRt1N4rDfN59F+HKGmF7SJFI/fj8Zez5t1MQL8KAbhK1SAT+EaT5no1dMHXVtZaWpaKhw36xNoQ2DkmdHJnYaTizIEYvW5+9RRebMOnThIaSavrr38zGh+XjRsRQ2ERXeLMZiW1IaoauGVQuovqO8V08gxajjmo2d4nfdomJ74BVn/g5+b7vV2kfx5sqvAuuIz4PpGjxtyQ5Mj05hHkFR33B058lHPdm1eF00Z9xIoSq1IHGtPoS6iKsN40UJl5r/gyToRjWAzT0ZsBSqCHWqRpAcyVyKdEZpiI3IxxDkIYbkTWEY9gOYLgZuYroDLcj9yEcQ5CGO5E1hGMIOot8+CoCGP4DZ4n1pdgKAAA=";
    private static final Log log = LogFactory.getLog(BeanDataBindingDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextField edit3;
    protected Boolean editing3;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BeanDataBindingDemo $BaseBeanDataBinding0 = this;
    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JButton $JButton3;
    private JButton $JButton4;
    private JButton $JButton5;
    private JLabel $JLabel0;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JTextField $JTextField0;
    private JTextField $JTextField1;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected String[] getSources() {
        return addDefaultSources( "BaseBeanDataBinding.jaxx" );
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanDataBindingDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanDataBindingDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public BeanDataBindingDemo() {
        $initialize();
    }

    public BeanDataBindingDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public BeanDataBindingDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BeanDataBindingDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanDataBindingDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public BeanDataBindingDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setEditing(true);
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setEditing(false);
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setEditing2(true);
    }

    public void doActionPerformed__on__$JButton3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setEditing2(false);
    }

    public void doActionPerformed__on__$JButton4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setEditing3(true);
    }

    public void doActionPerformed__on__$JButton5(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setEditing3(false);
    }

    public void doKeyReleased__on__edit3(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setContentMessage(edit3.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextField getEdit3() {
        return edit3;
    }

    public Boolean getEditing3() {
        return editing3;
    }

    public Boolean isEditing3() {
        return editing3 !=null && editing3;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setEditing3(Boolean editing3) {
        Boolean oldValue = this.editing3;
        this.editing3 = editing3;
        firePropertyChange(PROPERTY_EDITING3, oldValue, editing3);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JButton get$JButton3() {
        return $JButton3;
    }

    protected JButton get$JButton4() {
        return $JButton4;
    }

    protected JButton get$JButton5() {
        return $JButton5;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JTextField get$JTextField0() {
        return $JTextField0;
    }

    protected JTextField get$JTextField1() {
        return $JTextField1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createEdit3() {
        $objectMap.put("edit3", edit3 = new JTextField());
        
        edit3.setName("edit3");
        edit3.setColumns(15);
        edit3.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__edit3"));
    }

    protected void createEditing3() {
        $objectMap.put("editing3", editing3 = true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $BaseBeanDataBinding0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JTextField0, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JTextField1, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(edit3, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add($JButton0);
        $JPanel0.add($JButton1);
        // inline complete setup of $JPanel1
        $JPanel1.add($JButton2);
        $JPanel1.add($JButton3);
        // inline complete setup of $JPanel2
        $JPanel2.add($JButton4);
        $JPanel2.add($JButton5);
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$BaseBeanDataBinding0", $BaseBeanDataBinding0);
        createEditing3();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("edit"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("close"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JTextField0
        $objectMap.put("$JTextField0", $JTextField0 = new JTextField());
        
        $JTextField0.setName("$JTextField0");
        $JTextField0.setColumns(15);
        SwingUtil.setText($JTextField0, "to edit");
        
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(t("edit2"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.setText(t("close2"));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $JTextField1
        $objectMap.put("$JTextField1", $JTextField1 = new JTextField());
        
        $JTextField1.setName("$JTextField1");
        $JTextField1.setColumns(15);
        SwingUtil.setText($JTextField1, "to edit 2");
        
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.setText(t("edit3"));
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $JButton5
        $objectMap.put("$JButton5", $JButton5 = new JButton());
        
        $JButton5.setName("$JButton5");
        $JButton5.setText(t("close3"));
        $JButton5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton5"));
        createEdit3();
        // inline creation of $BaseBeanDataBinding0
        setName("$BaseBeanDataBinding0");
        setLayout(new BorderLayout());
        
        // registers 11 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 11 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"contentMessage") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(t(getContentMessage()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"editing") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(!isEditing());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_VISIBLE, true ,"editing") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setVisible(isEditing());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTEXT_FIELD0_ENABLED, true ,"editing") {
        
            @Override
            public void processDataBinding() {
                $JTextField0.setEnabled(isEditing());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON2_VISIBLE, true ,"editing2") {
        
            @Override
            public void processDataBinding() {
                $JButton2.setVisible(!isEditing2());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON3_VISIBLE, true ,"editing2") {
        
            @Override
            public void processDataBinding() {
                $JButton3.setVisible(isEditing2());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTEXT_FIELD1_ENABLED, true ,"editing2") {
        
            @Override
            public void processDataBinding() {
                $JTextField1.setEnabled(isEditing2());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON4_VISIBLE, true ,"editing3") {
        
            @Override
            public void processDataBinding() {
                $JButton4.setVisible(!isEditing3());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON5_VISIBLE, true ,"editing3") {
        
            @Override
            public void processDataBinding() {
                $JButton5.setVisible(isEditing3());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDIT3_ENABLED, true ,"editing3") {
        
            @Override
            public void processDataBinding() {
                edit3.setEnabled(isEditing3());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDIT3_TEXT, true ,"contentMessage") {
        
            @Override
            public void processDataBinding() {
                SwingUtil.setText(edit3, getContentMessage());
            }
        });
    }

}