/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id: DemoSourcesHandler.java 2448 2012-07-30 08:04:01Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.23/jaxx-demo/src/main/java/jaxx/demo/DemoSourcesHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo;

import jaxx.runtime.SwingUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * Created: 21 déc. 2009
 *
 * @author tchemit <chemit@codelutin.com>
 * @version $Revision: 2448 $
 *          <p/>
 *          Mise a jour: $Date: 2012-07-30 10:04:01 +0200 (Mon, 30 Jul 2012) $ par :
 *          $Author: tchemit $
 */
public class DemoSourcesHandler {

    /** Logger */
    private static final Log log = LogFactory.getLog(DemoSourcesHandler.class);

    protected static Map<String, String> sourcesCache;

    public static Map<String, String> getSourcesCache() {
        if (sourcesCache == null) {
            sourcesCache = new TreeMap<String, String>();
        }
        return sourcesCache;
    }

    public String getSourceContent(DemoSources ui, String name) {
        if (name == null) {
            return "";
        }
        String result = getSourcesCache().get(name);
        if (result == null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug(name + " from " + ui.getIncomingClass());
                }
                int lastDotIndex = name.lastIndexOf(".");
                String path = "/"+ name.substring(0, lastDotIndex).replaceAll("\\.", "/");
                path += name.substring(lastDotIndex);
                result = IOUtils.toString(ui.getIncomingClass().getResourceAsStream(path));
                if (log.isDebugEnabled()) {
                    log.debug("source [" + name + "], loaded content =\n" + result);
                }
            } catch (Exception e) {
                log.error("could not load file " + name, e);
                result = "could not load file " + name;
            }
            getSourcesCache().put(name, result);
        }
        return result;
    }

    public String getSourceEditingStyle(DemoSources ui, String source) {

        if (source == null) {
            return "";
        }
        ui.getEditor().setFractionalFontMetricsEnabled(true);
        String s = null;
        if (source.matches(".*\\.jaxx") || source.matches(".*\\.xml")) {
            s = RSyntaxTextArea.SYNTAX_STYLE_XML;
        } else if (source.matches(".*\\.java")) {
            s = RSyntaxTextArea.SYNTAX_STYLE_JAVA;
        } else if (source.matches(".*\\.css")) {
            s = RSyntaxTextArea.SYNTAX_STYLE_CSS;
        }
        if (log.isDebugEnabled()) {
            log.debug("source [" + source + "] style = " + s);
        }
        return s;
    }

    public void init(DemoSources ui) {
        List<String> sources = ui.getSources();
        if (sources == null) {
            return;
        }

        List<String> toFill = new ArrayList<String>();
        String prefix = ui.getIncomingClass() == null ? "" :
                        ui.getIncomingClass().getPackage().getName() + ".";
        for (String source : sources) {
            String path;
            if (source.startsWith("/")) {
                path = source.substring(1);
            } else {
                path = prefix + source;
            }
            if (log.isDebugEnabled()) {
                log.debug("adding resource " + path);
            }
            toFill.add(path);
        }
        SwingUtil.fillComboBox(ui.getSourceTabs(), toFill, null);
        if (!toFill.isEmpty()) {
            ui.getSourceTabs().setSelectedIndex(0);
        }
        toFill.clear();
        ui.getEditor().discardAllEdits();
    }

}
