/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id: DemoTreeHelper.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.1/jaxx-demo/src/main/java/jaxx/demo/tree/DemoTreeHelper.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.demo.tree;

import jaxx.runtime.swing.nav.tree.NavTreeHelper;

import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

/**
 * @author tchemit <tchemit@codelutin.com>
 * @since 2.1
 */
public class DemoTreeHelper extends NavTreeHelper<DemoNode> {

    public DemoTreeHelper(DemoDataProvider provider) {
        setDataProvider(provider);
    }

    @Override
    public DemoDataProvider getDataProvider() {
        return (DemoDataProvider) super.getDataProvider();
    }

    public TreeModel createModel() {

        // Create root static node
        DemoNode root = new DemoNode("jaxxdemo.tree");

        // Create model
        DefaultTreeModel model = createModel(root);

        // load all nodes of model
        loadAllNodes(root, getDataProvider());

        return model;
    }
}