package jaxx.demo.component.jaxx.widgets.gis;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.gis.absolute.CoordinatesEditor;

public class CoordinatesEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz09TQRDeFlssICgVxIgRhauvGn8lYgQBiZICCiYSenHbXV8Xt7vr7j77uBj/BP8EvXsx8ebJePDswYvxXzDGg1fj7PYXj9ZotIf3+ma++Xbm25l59RVljEand3AcBzoSltVosHJja2u9vEMrdomaimbKSo0av1QapUtokLTtxqLpUtGFF5rhhUVZU1JQsSd6togGjN3l1FQptRadTEZUjClstt2zsYp0i7WdVC/WF9+/pZ+TZy/TCMUKshuCUqb+FNWp5EARpRmxaBROeoILHIsQ0tBMhJDvIWdb5NiYNVyjj9FT1F9EWYU1kFl05u9L9hw+PlYWDc4s0Zq8gwXl5yy66pMlYAkqLYrA2+qMhNSaIGQGipCaMIEtNTcJA25HoZQnzVqUqUlCuUVz/0626hg6jP0z93CZU0hwIqGmqYM2gfc5ZK4dkK1I8ZCFIKVTLW4CV3yZDjLSRuZMVdY3qHFdMJYAL1Zp5dGCjB1wtI0fosIdtxBZK4WzHUv684QZxfHuNtXyfpWKtYjzHrAs9bVadFnqMBARfIhubXDZSB5Z2i1Ssoispibi1n0dTXqGG567ESYau0ZJClLE5YYgp/ZHFLFlNiJe1+kkYqSJkCLsgmh0InFDMElBZ5I6rZ4qoYyOwAxXWuoevg1wNcZuYt/YOULv/Tme//T2y5vl1qz1wdljPaF7VgXMgNJSUW2ZO3qkMWiRZbywitVsCdqBctgzfo9M9khss+mG5OC8Iy48cOHBLWyqQJHp//zu/fiDj30ovYwGuMRkGTv8bZSzVdCtKjmJ1dy8z2iofhCeh11ucIfQNBK6Cg1fI9jiqTITcOPh9RhEmOwhQjuTcu7Dj/zm6/mWEClI7Phv4R0xMtsoywRngvq109woPdfMoDI0IrKzOXrtkpR7D6jm1J71z/PdlTrzBfe4GEfudcmn7P5d8b78fzNMAcMvh8ZBwUgGAAA=";
    private static final Log log = LogFactory.getLog(CoordinatesEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel config;
    protected JCheckBox displayZeroWhenNull;
    protected CoordinatesEditor editor;
    protected JCheckBox enableButton;
    protected final CoordinatesEditorDemoHandler handler = createHandler();
    protected CoordinatesEditorDemoModel model;
    protected JPanel result;
    protected JLabel resultLatitude;
    protected JLabel resultLongitude;
    protected JLabel resultQuadrant;
    protected JCheckBox showReset;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CoordinatesEditorDemo $DemoPanel0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CoordinatesEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinatesEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public CoordinatesEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CoordinatesEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinatesEditorDemo() {
        $initialize();
    }

    public CoordinatesEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public CoordinatesEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public CoordinatesEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfig() {
        return config;
    }

    public JCheckBox getDisplayZeroWhenNull() {
        return displayZeroWhenNull;
    }

    public CoordinatesEditor getEditor() {
        return editor;
    }

    public JCheckBox getEnableButton() {
        return enableButton;
    }

    public CoordinatesEditorDemoHandler getHandler() {
        return handler;
    }

    public CoordinatesEditorDemoModel getModel() {
        return model;
    }

    public JPanel getResult() {
        return result;
    }

    public JLabel getResultLatitude() {
        return resultLatitude;
    }

    public JLabel getResultLongitude() {
        return resultLongitude;
    }

    public JLabel getResultQuadrant() {
        return resultQuadrant;
    }

    public JCheckBox getShowReset() {
        return showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfig() {
        if (!allComponentsCreated) {
            return;
        }
        config.add(showReset);
        config.add(enableButton);
        config.add(displayZeroWhenNull);
    }

    protected void addChildrenToResult() {
        if (!allComponentsCreated) {
            return;
        }
        result.add(resultQuadrant);
        result.add(resultLatitude);
        result.add(resultLongitude);
    }

    protected void createConfig() {
        $objectMap.put("config", config = new JPanel());
        
        config.setName("config");
        config.setLayout(new GridLayout(0,1));
    }

    protected void createDisplayZeroWhenNull() {
        $objectMap.put("displayZeroWhenNull", displayZeroWhenNull = new JCheckBox());
        
        displayZeroWhenNull.setName("displayZeroWhenNull");
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new CoordinatesEditor());
        
        editor.setName("editor");
    }

    protected void createEnableButton() {
        $objectMap.put("enableButton", enableButton = new JCheckBox());
        
        enableButton.setName("enableButton");
    }

    protected CoordinatesEditorDemoHandler createHandler() {
        return new CoordinatesEditorDemoHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CoordinatesEditorDemoModel.class));
    }

    protected void createResult() {
        $objectMap.put("result", result = new JPanel());
        
        result.setName("result");
        result.setLayout(new GridLayout(0,1));
    }

    protected void createResultLatitude() {
        $objectMap.put("resultLatitude", resultLatitude = new JLabel());
        
        resultLatitude.setName("resultLatitude");
    }

    protected void createResultLongitude() {
        $objectMap.put("resultLongitude", resultLongitude = new JLabel());
        
        resultLongitude.setName("resultLongitude");
    }

    protected void createResultQuadrant() {
        $objectMap.put("resultQuadrant", resultQuadrant = new JLabel());
        
        resultQuadrant.setName("resultQuadrant");
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = new JCheckBox());
        
        showReset.setName("showReset");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(config, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(result, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToConfig();
        addChildrenToResult();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfig();
        createShowReset();
        createEnableButton();
        createDisplayZeroWhenNull();
        createEditor();
        createResult();
        createResultQuadrant();
        createResultLatitude();
        createResultLongitude();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
        handler.afterInit(this);
    }

}
