package jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.HBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class JToggleButtonDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTO28TQRAeO7ETxwnEtvISAZlgEBLSGWpHIS9ZwTIPYYoIN6x9K/ui8+2yOxcfFIifwE+AngaJjgpRUFPQIP4CQhS0iN3142w4EktccXeame+bb3a/ef0NElLAxSMSBJbwPXQ61KrsHB7ebRzRJu5T2RQORyag98TiEK9D2h7GJcKlelXDi314cY91OPOoN4IuVWFO4hOXyjaliHB+HNGUslgbpksB98WAdSgqivXlj+/xF/bzV3GAgCt1STVK/jRUOMl0FeKOjZBVnY5J0SVeS8kQjtdSehd0bM8lUt4hHfoYnsFMFZKcCEWGsDH5yIbD4AOOkC7s0w67RzzqXke4ZsTaKmI1BxSW7CoFVuUBa7VcuusjMk9jODcsSYRk4WCXBQq+MjZrD6dTui41LJ9StAhrep4gilyXzYfV2GX6NzMeTmBbUBqRmC1UqqRhpsmOtTDRfq2Ac2NS1YVb4YWHNxKrQ0L4KoywWv/bI/dVqueO1T/coQlN9tdy7vO7r2/Lo5ZYiiwdcbS6Ki4YpwId3fpszw8+Om7xNuGlOqQkddU6GLuvRwir9dNKnOqX0XBLw60DItuKIjHz5f2H5UefpiBehjmXEbtMdP0tSOlzlW3m2gG/uW0UzXdn1XtRa0PItZlwnjIPibvjOi2vY+yX3XQ81/FonqDya8NHuhWoU1mPOJWhtEbq489c7c324GRiSunaP8vD00k8hGSvm1mX/iZErkeaS+rbLHR81A7E9HeB9+18wbw3okbPHOsLaY4MrksvB77+XDET6L+rExNOIw1O4lg8lUOHb5zAkPtvhqXJGBDObNoESb7heLZat61othXF9htXTGxw4wUAAA==";
    private static final Log log = LogFactory.getLog(JToggleButtonDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToggleButton one;
    protected JToggleButton three;
    protected JToggleButton two;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JToggleButtonDemo $DemoPanel0 = this;
    private HBox $HBox0;
    private JLabel $JLabel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JToggleButtonDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JToggleButtonDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public JToggleButtonDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public JToggleButtonDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JToggleButtonDemo() {
        $initialize();
    }

    public JToggleButtonDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public JToggleButtonDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public JToggleButtonDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToggleButton getOne() {
        return one;
    }

    public JToggleButton getThree() {
        return three;
    }

    public JToggleButton getTwo() {
        return two;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected HBox get$HBox0() {
        return $HBox0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createOne() {
        $objectMap.put("one", one = new JToggleButton());
        
        one.setName("one");
        one.setText(t("1"));
    }

    protected void createThree() {
        $objectMap.put("three", three = new JToggleButton());
        
        three.setName("three");
        three.setText(t("3"));
    }

    protected void createTwo() {
        $objectMap.put("two", two = new JToggleButton());
        
        two.setName("two");
        two.setText(t("2"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($HBox0);
        // inline complete setup of $HBox0
        $HBox0.add(one);
        $HBox0.add(two);
        $HBox0.add(three);
        $HBox0.add($JLabel0);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new HBox());
        
        $HBox0.setName("$HBox0");
        $HBox0.setHorizontalAlignment(0);
        $HBox0.setVerticalAlignment(0);
        createOne();
        createTwo();
        createThree();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (one != null) {
                    $bindingSources.put("one.getModel()", one.getModel());
                    one.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    one.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JToggleButtonDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (two != null) {
                    $bindingSources.put("two.getModel()", two.getModel());
                    two.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    two.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JToggleButtonDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (three != null) {
                    $bindingSources.put("three.getModel()", three.getModel());
                    three.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    three.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JToggleButtonDemo.this, BINDING_$JLABEL0_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (one != null && two != null && three != null) {
                    $JLabel0.setText(t("Total: " + ((one.isSelected() ? 1 : 0) + (two.isSelected() ? 2 : 0) + (three.isSelected() ? 3 : 0))));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (one != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("one.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    one.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JToggleButtonDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (two != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("two.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    two.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JToggleButtonDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (three != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("three.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    three.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JToggleButtonDemo.this, BINDING_$JLABEL0_TEXT));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}