package jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class JTextAreaDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_UPPER_TEXT_AREA_TEXT = "upperTextArea.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRAdmzix8wH5IF+QSIFYigBxJrSJIFEiCywHEE6BcMPe7Sq5sL5b9vbIpUH8BH4C9DRIdFSIgpqCBvEXEKKgRcyufec4uTgWuFgns/PevJmd57c/IBdIuLRHosiSoafcBrMq648e3bf3mKM2WeBIVyhfQvOTyUK2DkM0iQcKFutVDS+14KUNvyF8j3mH0CtVGAzUAWfBLmNKwXwnwgmCUi25XolEKGPWRFQa6+tfP7Ov6Ms3WYBIoLo8trJwGqrdSV8Vsi5VMI6VnpMSJ94OypCut4N6R3Rsg5MguEca7Bm8gIEq9AsikUzB5d5bNhwGHwkFQ8VN1vAfEI/xGwqWjFiKEcuJKaxgHxVYlW0WqXXJiM4XwjD0KxgobhObM8TOdDTaBJk7nVlIAPlipUpsU21ctxTF/Caqk4aT3JFipeZIn3OtDwHTHYD2VScqr1pKFUx2AOIOdN74MUHL+v+xLgJMwvkjCaEQTB4mntbHBYEvf7FjILhTVnun2o+eqUNOhhjGCdaPr+FDvGou4MyRBdSE5vbP1MTXD9/fl+OtK2DtydTUQ6bBbRDSR+3K1aXPNVcuVC4vbRGxUkcWxtFxxlFzKcJqrWsUh/XGNNzScOsOCXaRIjfw7eOnqSdfzkC2DIPcJ7RMdP5dKKhdiVPwOY3E7TWjaHg/j+eo1oYPwvVzlH2p4OwqJYos2K5H8QVvRTiGuZQxJFrswuffE7V3a/EoMiht9sT09jhyj6Hf9bjrMWPBlrtSLTckAhZSv+2iNF9l9PeoaNlk0ZxLab326V1FJ6w2qy8QhX63Q8WwVw26ZprQf13vmXOMuoHg5IDRLQ+96rmOTr35r4Q6vNyFYaonhiv6uJrOMPvfGk5nUDBoE+fpjvRDj3bRMt8DU55RV8W/bCcoOp0n6amLkr8JS2UXDwcAAA==";
    private static final Log log = LogFactory.getLog(JTextAreaDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextArea textArea;
    protected JTextArea upperTextArea;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JTextAreaDemo $DemoPanel0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextAreaDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JTextAreaDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public JTextAreaDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public JTextAreaDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JTextAreaDemo() {
        $initialize();
    }

    public JTextAreaDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public JTextAreaDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public JTextAreaDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextArea getTextArea() {
        return textArea;
    }

    public JTextArea getUpperTextArea() {
        return upperTextArea;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createTextArea() {
        $objectMap.put("textArea", textArea = new JTextArea());
        
        textArea.setName("textArea");
        textArea.setColumns(15);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        SwingUtil.setText(textArea, "Try typing some text here.");
    }

    protected void createUpperTextArea() {
        $objectMap.put("upperTextArea", upperTextArea = new JTextArea());
        
        upperTextArea.setName("upperTextArea");
        upperTextArea.setColumns(15);
        upperTextArea.setLineWrap(true);
        upperTextArea.setWrapStyleWord(true);
        upperTextArea.setEditable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(textArea);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(upperTextArea);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        $JLabel0.setLabelFor(textArea);
        $JLabel1.setLabelFor(upperTextArea);
        upperTextArea.setBackground(null);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("Normal text:"));
        $JLabel0.setDisplayedMnemonic(78);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createTextArea();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("Upper case text:"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createUpperTextArea();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UPPER_TEXT_AREA_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (textArea != null) {
                    $bindingSources.put("textArea.getDocument()", textArea.getDocument());
                    textArea.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    textArea.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JTextAreaDemo.this, BINDING_UPPER_TEXT_AREA_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (textArea != null && textArea.getText() != null) {
                    SwingUtil.setText(upperTextArea, textArea.getText().toUpperCase());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (textArea != null) {
                    Document $target = (Document) $bindingSources.remove("textArea.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    }
                    textArea.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JTextAreaDemo.this, BINDING_UPPER_TEXT_AREA_TEXT));
                }
            }
        
            public void $pr$u0(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}