package jaxx.demo.component.jaxx.widgets.datetime;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.datetime.DateTimeEditor;

public class DateTimeEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUQU8TQRR+LbbQFgTagKiYgHLRw9Y7RIHWRklRIxyIvTjtDu3idGedmZXlYvwJ/gS9ezHx5sl48OzBi/EvGOPBq/HNtN3tlhVJ6GF39r3v+96bN9Pv7Q/ISAHLByQILOG7yulSa2tjb+9B84C2VJXKlnA8xQX0fqk0pBtQsMO4VHCtUdf0cp9ervCux13qDrFX65CX6ohR2aFUKbgSZ7SkLO+E6dXA88VANWwqSfX1r5/pV/bLN2mAwMPuSriVpf+xop2cq0PasRUUsdJzUmbEbWMbwnHb2O+UjlUYkfI+6dJn8ALG65D1iEAxBVdPv2WjYfiBp6CwUqVd/pC4lN1UsGaatTFitQYSlokdOnabKmnZRFGzkyoudnFxx3ZQXYt4npHNKsh0uU2Zgo2zyG1rjUhzYmVr0GVRjyKw5CFOxupFNSgXYgst7u47bZNRsBA7gR5rlzSZGeJ0SJphpElZxTDrejlayAQ1uBgVGuIomI/Bd2mgag5ldpwyu89Fl6ihOjpxIQ6aHAbp2KV4vqjnpkelt7HpK8VdBXOx8pUObT3d5MEIUfVnHBF1ZnmkPHVPzGepOSUFZS7aluvjh3uqc41PPCuo9JnSX7PxA5zuZTQ5PqLrISQfQcIBRdniIHt0ksZUDJUgU+oB9AZO0jkfhw0LCbgcu35oLVZkLdF/P9WAjPAxjPe1cdyNHmGq50MLIz6kBU32z3zp64fv72sD8xnD2nOJ0CHvRFPwBPeoUI4uPd1zHl85rLxNvNUG5CRlaLzGWBcTGtvpp7E5rDer6ZamW3eJ7KBEZvzbx0/zT76MQboGecaJXSMafw9yqoNj63BmB97tddPR5OEEPmd0b3g7GDnieAPh/BreJrLUdFwbb/atAIewmDCEsJNm7vPv0s679cEgUtjYxX/Co2FkHkPWcZnjUuPDfYtN9N2CJ6lv88hKk8w1pd95r29ha+a5fnynOrypH5XA16+qaVmvaiY3c2aFG6jwF4iBvKRZBwAA";
    private static final Log log = LogFactory.getLog(DateTimeEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table configPanel;
    protected JCheckBox dateEditableButton;
    protected DateTimeEditor editor;
    protected JCheckBox enableButton;
    protected JTextField formatConfig;
    protected JLabel formatConfigLabel;
    protected final DateTimeEditorDemoHandler handler = createHandler();
    protected JTextField labelConfig;
    protected JLabel labelConfigLabel;
    protected DateTimeEditorDemoModel model;
    protected JPanel result;
    protected JTextField resultDate;
    protected JLabel resultDateLabel;
    protected JTextField resultDayDate;
    protected JLabel resultDayDateLabel;
    protected JTextField resultTimeDate;
    protected JLabel resultTimeDateLabel;
    protected JCheckBox timeEditableButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private DateTimeEditorDemo $DemoPanel0 = this;
    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DateTimeEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateTimeEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DateTimeEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DateTimeEditorDemo() {
        $initialize();
    }

    public DateTimeEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public DateTimeEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Table getConfigPanel() {
        return configPanel;
    }

    public JCheckBox getDateEditableButton() {
        return dateEditableButton;
    }

    public DateTimeEditor getEditor() {
        return editor;
    }

    public JCheckBox getEnableButton() {
        return enableButton;
    }

    public JTextField getFormatConfig() {
        return formatConfig;
    }

    public JLabel getFormatConfigLabel() {
        return formatConfigLabel;
    }

    public DateTimeEditorDemoHandler getHandler() {
        return handler;
    }

    public JTextField getLabelConfig() {
        return labelConfig;
    }

    public JLabel getLabelConfigLabel() {
        return labelConfigLabel;
    }

    public DateTimeEditorDemoModel getModel() {
        return model;
    }

    public JPanel getResult() {
        return result;
    }

    public JTextField getResultDate() {
        return resultDate;
    }

    public JLabel getResultDateLabel() {
        return resultDateLabel;
    }

    public JTextField getResultDayDate() {
        return resultDayDate;
    }

    public JLabel getResultDayDateLabel() {
        return resultDayDateLabel;
    }

    public JTextField getResultTimeDate() {
        return resultTimeDate;
    }

    public JLabel getResultTimeDateLabel() {
        return resultTimeDateLabel;
    }

    public JCheckBox getTimeEditableButton() {
        return timeEditableButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configPanel.add(labelConfigLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(labelConfig, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(formatConfigLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(formatConfig, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(dateEditableButton, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(timeEditableButton, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(enableButton, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToResult() {
        if (!allComponentsCreated) {
            return;
        }
        result.add(resultDateLabel);
        result.add(resultDate);
        result.add(resultDayDateLabel);
        result.add(resultDayDate);
        result.add(resultTimeDateLabel);
        result.add(resultTimeDate);
    }

    protected void createConfigPanel() {
        $objectMap.put("configPanel", configPanel = new Table());
        
        configPanel.setName("configPanel");
    }

    protected void createDateEditableButton() {
        $objectMap.put("dateEditableButton", dateEditableButton = new JCheckBox());
        
        dateEditableButton.setName("dateEditableButton");
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new DateTimeEditor(this));
        
        editor.setName("editor");
    }

    protected void createEnableButton() {
        $objectMap.put("enableButton", enableButton = new JCheckBox());
        
        enableButton.setName("enableButton");
    }

    protected void createFormatConfig() {
        $objectMap.put("formatConfig", formatConfig = new JTextField());
        
        formatConfig.setName("formatConfig");
        formatConfig.setColumns(15);
    }

    protected void createFormatConfigLabel() {
        $objectMap.put("formatConfigLabel", formatConfigLabel = new JLabel());
        
        formatConfigLabel.setName("formatConfigLabel");
    }

    protected DateTimeEditorDemoHandler createHandler() {
        return new DateTimeEditorDemoHandler();
    }

    protected void createLabelConfig() {
        $objectMap.put("labelConfig", labelConfig = new JTextField());
        
        labelConfig.setName("labelConfig");
        labelConfig.setColumns(15);
    }

    protected void createLabelConfigLabel() {
        $objectMap.put("labelConfigLabel", labelConfigLabel = new JLabel());
        
        labelConfigLabel.setName("labelConfigLabel");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(DateTimeEditorDemoModel.class));
    }

    protected void createResult() {
        $objectMap.put("result", result = new JPanel());
        
        result.setName("result");
        result.setLayout(new GridLayout(0,2));
    }

    protected void createResultDate() {
        $objectMap.put("resultDate", resultDate = new JTextField());
        
        resultDate.setName("resultDate");
        resultDate.setColumns(15);
    }

    protected void createResultDateLabel() {
        $objectMap.put("resultDateLabel", resultDateLabel = new JLabel());
        
        resultDateLabel.setName("resultDateLabel");
    }

    protected void createResultDayDate() {
        $objectMap.put("resultDayDate", resultDayDate = new JTextField());
        
        resultDayDate.setName("resultDayDate");
        resultDayDate.setColumns(15);
    }

    protected void createResultDayDateLabel() {
        $objectMap.put("resultDayDateLabel", resultDayDateLabel = new JLabel());
        
        resultDayDateLabel.setName("resultDayDateLabel");
    }

    protected void createResultTimeDate() {
        $objectMap.put("resultTimeDate", resultTimeDate = new JTextField());
        
        resultTimeDate.setName("resultTimeDate");
        resultTimeDate.setColumns(15);
    }

    protected void createResultTimeDateLabel() {
        $objectMap.put("resultTimeDateLabel", resultTimeDateLabel = new JLabel());
        
        resultTimeDateLabel.setName("resultTimeDateLabel");
    }

    protected void createTimeEditableButton() {
        $objectMap.put("timeEditableButton", timeEditableButton = new JCheckBox());
        
        timeEditableButton.setName("timeEditableButton");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($JPanel0, BorderLayout.NORTH);
        add(result, BorderLayout.CENTER);
        // inline complete setup of $JPanel0
        $JPanel0.add(configPanel, BorderLayout.NORTH);
        $JPanel0.add(editor, BorderLayout.CENTER);
        addChildrenToConfigPanel();
        addChildrenToResult();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createConfigPanel();
        createLabelConfigLabel();
        createLabelConfig();
        createFormatConfigLabel();
        createFormatConfig();
        createDateEditableButton();
        createTimeEditableButton();
        createEnableButton();
        createEditor();
        createResult();
        createResultDateLabel();
        createResultDate();
        createResultDayDateLabel();
        createResultDayDate();
        createResultTimeDateLabel();
        createResultTimeDate();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
        handler.afterInit(this);
    }

}