package jaxx.demo.feature.nav.content;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.demo.entities.People;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.swing.renderer.DecoratorProviderListCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ActorsContentUI extends AbstractContentUI<List<People>> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATA = "data";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_LIST_HEADER_DATA = "listHeader.data";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON2_ENABLED = "$JButton2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VTU8TQRgeKlDKN1T5CKggeNMtoDEmEOTDEGiqEkBD7MXZ3QGWTGfW2VnYejD+BH+C3r2YePNkPHj24MX4F4zx4NX4zm67S2VpN9Yepu378czzvvO8M2++ozZHoMlD7HmacJm0SkTLL+/uPtAPiSHvEscQli25QMGnJYVSRdRlhnZHoqliQaXnKum5VV6yOSPsRPZ8AXU6skyJc0CIlOhibYbhOLnt0D3v2a6oooak4lBf/fyRemm+eJ1CyLOBXReUMtEoK6qktYBSlinRIOx0hHMUs32gISy2D3x7lG2VYse5j0vkKXqO0gXUbmMBYBJdSV6yj+Hne7ZE2ell3ZECG3KVMwkZDzdmJLrukzZJiWt7BEtXEI3hI80IQrRlQ3U6TLBtH69dolYTSyxRr+KqudKiWsFyZOTvmM5vYkYobDGoYjzNOYbytMCqgjJhbM90ftsQnFLlg4ThmoTIpcL7IgYUNpRooCZYkVD+wTAsLTmnOhYSna+J3AHzChanGc+q/wNqGQl9men8iislZ8AuWwMTmFXY2OloH+ryGc65GGenqmmdYJOI6tFU9RTsR0wLDkTTCWbaCiyFML5CWKCxmjQQuBYJPFJgSxG1CRfMEo0UT8/EFriCaRj5axoUoO/9PZT98v7bu7XqCGRh7wuxoScmGKRpC25DeZbaui/Qv9JP7h6254so4xBKjGC8x2OIbVfcQA72G4jkt46dA4BoS3/98HHoyedzKLUG7eTYXMMqfgNl5IGALnBqevadJZ9R93EHrP2Km0TtFJc5nAzqXVDantAtZkLLFz1ownhME0ImeubTr+z226VqI1qA2OiZ4VEz2h6jdotRixH/NqgMeuz0d9kOcU0eDXTciLeo7367ouhr/joTW6nORUUxNzxXfd30aatft3yUbAKUfoNTt8QC9T2yyHGTeKMHXFjP4KbBNBh5mM5NTi2j3CTw8JGSm/G/YbsNQukWYVB93V4OJcDK7IFSJdYpjOjgQiCKCSzhRdBdSRbjgUcbAivzXB1qzSOMJyguTZiqzKwDcykBTKsknn+37/wrhjLv1UGYTISA69Qx1TSHxgiVt7cOi6sJMDqt2dtsU5A9y6vDJgmS/w43ySYD9/LxFnFIvQNOAtShXsadsk0aEPoDUaehtH4KAAA=";
    private static final Log log = LogFactory.getLog(ActorsContentUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<People> data;
    protected JList list;
    protected BeanListHeader<People> listHeader;
    protected JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ActorsContentUI $AbstractContentUI0 = this;
    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private void $afterCompleteSetup() {
        getHandler().initUI(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ActorsContentUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ActorsContentUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ActorsContentUI() {
        $initialize();
    }

    public ActorsContentUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public ActorsContentUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ActorsContentUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ActorsContentUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ActorsContentUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectChild(this, (People) list.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public List<People> getData() {
        return data;
    }

    public JList getList() {
        return list;
    }

    public BeanListHeader<People> getListHeader() {
        return listHeader;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setData(List<People> data) {
        List<People> oldValue = this.data;
        this.data = data;
        firePropertyChange(PROPERTY_DATA, oldValue, data);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add($JPanel1, BorderLayout.CENTER);
        toolbar.add(listHeader, BorderLayout.EAST);
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createList() {
        $objectMap.put("list", list = new JList());
        
        list.setName("list");
    }

    protected void createListHeader() {
        $objectMap.put("listHeader", listHeader = new BeanListHeader<People>());
        
        listHeader.setName("listHeader");
        listHeader.setI18nPrefix("jaxxdemo.common.");
        listHeader.setShowReset(true);
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
        toolbar.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $AbstractContentUI0
        add($JPanel0);
        // inline complete setup of $JPanel0
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(list);
        addChildrenToToolbar();
        // inline complete setup of $JPanel1
        $JPanel1.add($JButton0);
        $JPanel1.add($JButton1);
        $JPanel1.add($JButton2);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        $JScrollPane0.setBorder(new TitledBorder(t("jaxxdemo.navigation.actors.title")));
        $JScrollPane0.setColumnHeaderView(toolbar);
        $JScrollPane0.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane0.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        list.setCellRenderer(getContextValue(DecoratorProviderListCellRenderer.class));
        listHeader.setList(list);
        listHeader.setBeanType(People.class);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$AbstractContentUI0", $AbstractContentUI0);
        createData();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createList();
        createToolbar();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("jaxxdemo.action.show"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("jaxxdemo.action.add"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(t("jaxxdemo.action.remove"));
        createListHeader();
        // inline creation of $AbstractContentUI0
        setName("$AbstractContentUI0");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (list != null) {
                    $bindingSources.put("list.getSelectionModel()", list.getSelectionModel());
                    list.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    list.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.nav.content.ActorsContentUI.this, BINDING_$JBUTTON0_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (list != null) {
                    $JButton0.setEnabled(list.getSelectedIndex()!=-1);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (list != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("list.getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    }
                    list.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.nav.content.ActorsContentUI.this, BINDING_$JBUTTON0_ENABLED));
                }
            }
        
            public void $pr$u0(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON2_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (list != null) {
                    $bindingSources.put("list.getSelectionModel()", list.getSelectionModel());
                    list.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    list.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.nav.content.ActorsContentUI.this, BINDING_$JBUTTON2_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (list != null) {
                    $JButton2.setEnabled(list.getSelectedIndex()!=-1);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (list != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("list.getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    }
                    list.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.nav.content.ActorsContentUI.this, BINDING_$JBUTTON2_ENABLED));
                }
            }
        
            public void $pr$u1(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LIST_HEADER_DATA, true ,"data") {
        
            @Override
            public void processDataBinding() {
                listHeader.setData(getData());
            }
        });
    }

}