package jaxx.demo.component.jaxx.editor;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.editor.number.NumberEditor2;
import static org.nuiton.i18n.I18n.t;

public class NumberEditor2Demo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DOUBLE_EDITOR_AUTO_POPUP = "doubleEditor.autoPopup";
    public static final String BINDING_DOUBLE_EDITOR_ENABLED = "doubleEditor.enabled";
    public static final String BINDING_DOUBLE_EDITOR_NUMBER_PATTERN = "doubleEditor.numberPattern";
    public static final String BINDING_DOUBLE_EDITOR_NUMBER_VALUE = "doubleEditor.numberValue";
    public static final String BINDING_DOUBLE_EDITOR_SHOW_POPUP_BUTTON = "doubleEditor.showPopupButton";
    public static final String BINDING_DOUBLE_EDITOR_SHOW_RESET = "doubleEditor.showReset";
    public static final String BINDING_FLOAT_EDITOR_AUTO_POPUP = "floatEditor.autoPopup";
    public static final String BINDING_FLOAT_EDITOR_ENABLED = "floatEditor.enabled";
    public static final String BINDING_FLOAT_EDITOR_NUMBER_PATTERN = "floatEditor.numberPattern";
    public static final String BINDING_FLOAT_EDITOR_NUMBER_VALUE = "floatEditor.numberValue";
    public static final String BINDING_FLOAT_EDITOR_SHOW_POPUP_BUTTON = "floatEditor.showPopupButton";
    public static final String BINDING_FLOAT_EDITOR_SHOW_RESET = "floatEditor.showReset";
    public static final String BINDING_INTEGER_EDITOR_AUTO_POPUP = "integerEditor.autoPopup";
    public static final String BINDING_INTEGER_EDITOR_ENABLED = "integerEditor.enabled";
    public static final String BINDING_INTEGER_EDITOR_NUMBER_PATTERN = "integerEditor.numberPattern";
    public static final String BINDING_INTEGER_EDITOR_NUMBER_VALUE = "integerEditor.numberValue";
    public static final String BINDING_INTEGER_EDITOR_SHOW_POPUP_BUTTON = "integerEditor.showPopupButton";
    public static final String BINDING_INTEGER_EDITOR_SHOW_RESET = "integerEditor.showReset";
    public static final String BINDING_RESULT_DOUBLE_TEXT = "resultDouble.text";
    public static final String BINDING_RESULT_FLOAT_TEXT = "resultFloat.text";
    public static final String BINDING_RESULT_INTEGER_TEXT = "resultInteger.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Xz28bRRQemzi/nDQkaawU2sY1KSRStW6hQoJUEJLUIpFbosaqqubC2Duxt6x3l91Z7GhVxJ/AnwB3LkjcOCEOnDlwQfwLCHEALgjxZma9vzzrtZVGitvMe++bb755897zN7+jgmOjG89wv6/YrkG1LlGOPnjy5KPmM9KiB8Rp2ZpFTRuJn1we5U9RUQ3WHYpeO62z8KofXt03u5ZpECMSvVNH8w4914nTIYRSdC0e0XKc6klg3ulbrj1ADUjJUL/684/8l+oXX+cR6lvAbh2OUs6KCk8yVUd5TaVoBXb6DFd1bLSBhq0ZbeC7yNb2dew4D3GXfIo+RzN1NG1hG8Aoqox/ZI7B4/sWRcXNA9I1j7FB9NsU3eFkVVhRWgMIha8RVQMQ5aHbbRL7Pv/jTRZpWRxrmqJC11SJTtHbE2M8YIEh0MxmAzd1AnTWY9o5PVBC4TbmORcEXDciiPumcaa1XRtTzTT4uZjXMvtYCiKWnI7ZOzYt19pzKTUNitaYvH1/j6P9Dml9smf2mftKPOoRcQgVUWy5lHDBLjUjwBKXVc2gpE1sIYOgC3ce27+Om4J3GHY5FnaMKSU28C7F4hqkT2sa0dVRsfcNJqEqobZ8ppuYRokxw7W400rEyafBLOV0r/QNV1TTBVPGjqtRr/QtY27pe85uHg3SPS56kCxhniz6wonUougt024rhgt/GCKle5raJtQZpLZIxHiGM6hqgFjkuggTW7obNy+IM6TaizZxXJ0GVO8k+ArzoWAdSPlOMr7GSEjMC8J8wElE7TZ6NfYWoUIqYYUMS1juFBVsF5bh8Z4OF9VHYBLldD1RThkgt/5XWv3l+9++q0Vr6JrUNdICoLZZtmkRm2ps6yVRQF2q6dUH2No5RXMO0aF/8P5wVULsxDcDOdhvmYUrLFz5EDsdgCjM/PrDj6WPf34J5WtoHtRTa5j5H6I52gHROqau9q33dzmjhd4sfL4Mv1MUTTUJhnc64/Hy+JyiuaBEQOXyEvVC0RxBhahb28w5KDnMOVF/ks7DVU2EpOL34SKuSi4iUKM599Nfqyff7g4uIwfiXEl1Dy+k8BRNa4auGYS3NL9bSVtY0XKIq5phV5L1KQRaLcZeld8uavzzaEj4HEXTTdNWISPQPc8gvXJDo1AP9vjaFt2qsFPwJiXerP+AW9HuUdlmErENGvzs7H+PUWa/sTK45aEGOf4lQH5Q2yXsHyjdFN2U00rcooxU8vIvwmIjnQVPv9T9I8k52f6FM6w7mQSCxyIlkHhK4xDQWZ+tscpe8mT99XnAaFvOSNLLZdxkPX8yfpe94bYbsntDzm6oncu4DTf9yZiteZL2HFLbklMbbvwybpL5IItcbjivZcjSkegFYUtmnxeELBtxsqAL0HyIcIXvRp7s3MlGsmjEh8yy9HEoMPmwgZOHFEXIY6yzOvKK6HbM4zAayV1n/VZ9Hs5XwkrRvEBpnFsAsuT5sUqLtQJpKY4PaBNJccMbvqYsIa5LXuEIGdZDGWphXFKEYgQzIcGix+NGCBCdJyc6fsWT5FLW+Tdkb32EAFdCAQ4igUkFFqKoCQkueSJyhAaxoXmMlxZMBncnmAz4QdImguhYPgYBvzQeeKN3G3SXyq1y2nOS04l/DRif0G4WIZ5sUTqxtB6pDfccn8peFhVx51Eu8QyTk4l9wRknVXR8bsI4gS7dUzHF5aZmqPBl8b0h7Bz7nB/3fMz6jxxjIxODLf87AuH1CyPcGgvh7xEIty+M8C4g/A+/jnXCDhQAAA==";
    private static final Log log = LogFactory.getLog(NumberEditor2Demo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox autoPopupButton;
    protected NumberEditor2 doubleEditor;
    protected JLabel doubleNumberConfig;
    protected JCheckBox doubleNumberEnabled;
    protected JTextField doubleNumberPattern;
    protected NumberEditor2 floatEditor;
    protected JLabel floatNumberConfig;
    protected JCheckBox floatNumberEnabled;
    protected JTextField floatNumberPattern;
    protected final NumberEditor2DemoHandler handler = new NumberEditor2DemoHandler();
    protected NumberEditor2 integerEditor;
    protected JLabel integerNumberConfig;
    protected JCheckBox integerNumberEnabled;
    protected JTextField integerNumberPattern;
    protected NumberEditor2DemoModel model;
    protected Table numberEditorConfigurationPanel;
    protected JLabel resultDouble;
    protected JLabel resultFloat;
    protected JLabel resultInteger;
    protected JPanel resultPanel;
    protected JCheckBox showPopupButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private NumberEditor2Demo $DemoPanel0 = this;
    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditor2Demo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NumberEditor2Demo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public NumberEditor2Demo() {
        $initialize();
    }

    public NumberEditor2Demo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public NumberEditor2Demo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public NumberEditor2Demo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NumberEditor2Demo(boolean param0) {
        super(param0);
        $initialize();
    }

    public NumberEditor2Demo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getAutoPopupButton() {
        return autoPopupButton;
    }

    public NumberEditor2 getDoubleEditor() {
        return doubleEditor;
    }

    public JLabel getDoubleNumberConfig() {
        return doubleNumberConfig;
    }

    public JCheckBox getDoubleNumberEnabled() {
        return doubleNumberEnabled;
    }

    public JTextField getDoubleNumberPattern() {
        return doubleNumberPattern;
    }

    public NumberEditor2 getFloatEditor() {
        return floatEditor;
    }

    public JLabel getFloatNumberConfig() {
        return floatNumberConfig;
    }

    public JCheckBox getFloatNumberEnabled() {
        return floatNumberEnabled;
    }

    public JTextField getFloatNumberPattern() {
        return floatNumberPattern;
    }

    public NumberEditor2DemoHandler getHandler() {
        return handler;
    }

    public NumberEditor2 getIntegerEditor() {
        return integerEditor;
    }

    public JLabel getIntegerNumberConfig() {
        return integerNumberConfig;
    }

    public JCheckBox getIntegerNumberEnabled() {
        return integerNumberEnabled;
    }

    public JTextField getIntegerNumberPattern() {
        return integerNumberPattern;
    }

    public NumberEditor2DemoModel getModel() {
        return model;
    }

    public Table getNumberEditorConfigurationPanel() {
        return numberEditorConfigurationPanel;
    }

    public JLabel getResultDouble() {
        return resultDouble;
    }

    public JLabel getResultFloat() {
        return resultFloat;
    }

    public JLabel getResultInteger() {
        return resultInteger;
    }

    public JPanel getResultPanel() {
        return resultPanel;
    }

    public JCheckBox getShowPopupButton() {
        return showPopupButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToNumberEditorConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        numberEditorConfigurationPanel.add(showPopupButton, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(showResetButton, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(autoPopupButton, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(integerNumberConfig, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(integerNumberPattern, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(integerNumberEnabled, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(floatNumberConfig, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(floatNumberPattern, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(floatNumberEnabled, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(doubleNumberConfig, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(doubleNumberPattern, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        numberEditorConfigurationPanel.add(doubleNumberEnabled, new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 13, 1, new Insets(1, 1, 1, 1), 0, 0));
    }

    protected void addChildrenToResultPanel() {
        if (!allComponentsCreated) {
            return;
        }
        resultPanel.add(resultInteger);
        resultPanel.add(resultFloat);
        resultPanel.add(resultDouble);
    }

    protected void createAutoPopupButton() {
        $objectMap.put("autoPopupButton", autoPopupButton = new JCheckBox());
        
        autoPopupButton.setName("autoPopupButton");
        autoPopupButton.setText(t("jaxxdemo.numbereditor.autoPopup"));
        autoPopupButton.setSelected(false);
    }

    protected void createDoubleEditor() {
        $objectMap.put("doubleEditor", doubleEditor = new NumberEditor2(this));
        
        doubleEditor.setName("doubleEditor");
        doubleEditor.setProperty("doubleNumber");
    }

    protected void createDoubleNumberConfig() {
        $objectMap.put("doubleNumberConfig", doubleNumberConfig = new JLabel());
        
        doubleNumberConfig.setName("doubleNumberConfig");
        doubleNumberConfig.setText(t("jaxxdemo.numbereditor.doubleNumberConfig"));
    }

    protected void createDoubleNumberEnabled() {
        $objectMap.put("doubleNumberEnabled", doubleNumberEnabled = new JCheckBox());
        
        doubleNumberEnabled.setName("doubleNumberEnabled");
        doubleNumberEnabled.setSelected(true);
    }

    protected void createDoubleNumberPattern() {
        $objectMap.put("doubleNumberPattern", doubleNumberPattern = new JTextField());
        
        doubleNumberPattern.setName("doubleNumberPattern");
        doubleNumberPattern.setColumns(15);
    }

    protected void createFloatEditor() {
        $objectMap.put("floatEditor", floatEditor = new NumberEditor2(this));
        
        floatEditor.setName("floatEditor");
        floatEditor.setProperty("floatNumber");
    }

    protected void createFloatNumberConfig() {
        $objectMap.put("floatNumberConfig", floatNumberConfig = new JLabel());
        
        floatNumberConfig.setName("floatNumberConfig");
        floatNumberConfig.setText(t("jaxxdemo.numbereditor.floatNumberConfig"));
    }

    protected void createFloatNumberEnabled() {
        $objectMap.put("floatNumberEnabled", floatNumberEnabled = new JCheckBox());
        
        floatNumberEnabled.setName("floatNumberEnabled");
        floatNumberEnabled.setSelected(true);
    }

    protected void createFloatNumberPattern() {
        $objectMap.put("floatNumberPattern", floatNumberPattern = new JTextField());
        
        floatNumberPattern.setName("floatNumberPattern");
        floatNumberPattern.setColumns(15);
    }

    protected void createIntegerEditor() {
        $objectMap.put("integerEditor", integerEditor = new NumberEditor2(this));
        
        integerEditor.setName("integerEditor");
        integerEditor.setProperty("integerNumber");
    }

    protected void createIntegerNumberConfig() {
        $objectMap.put("integerNumberConfig", integerNumberConfig = new JLabel());
        
        integerNumberConfig.setName("integerNumberConfig");
        integerNumberConfig.setText(t("jaxxdemo.numbereditor.integerNumberConfig"));
    }

    protected void createIntegerNumberEnabled() {
        $objectMap.put("integerNumberEnabled", integerNumberEnabled = new JCheckBox());
        
        integerNumberEnabled.setName("integerNumberEnabled");
        integerNumberEnabled.setSelected(true);
    }

    protected void createIntegerNumberPattern() {
        $objectMap.put("integerNumberPattern", integerNumberPattern = new JTextField());
        
        integerNumberPattern.setName("integerNumberPattern");
        integerNumberPattern.setColumns(15);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(NumberEditor2DemoModel.class));
    }

    protected void createNumberEditorConfigurationPanel() {
        $objectMap.put("numberEditorConfigurationPanel", numberEditorConfigurationPanel = new Table());
        
        numberEditorConfigurationPanel.setName("numberEditorConfigurationPanel");
    }

    protected void createResultDouble() {
        $objectMap.put("resultDouble", resultDouble = new JLabel());
        
        resultDouble.setName("resultDouble");
    }

    protected void createResultFloat() {
        $objectMap.put("resultFloat", resultFloat = new JLabel());
        
        resultFloat.setName("resultFloat");
    }

    protected void createResultInteger() {
        $objectMap.put("resultInteger", resultInteger = new JLabel());
        
        resultInteger.setName("resultInteger");
    }

    protected void createResultPanel() {
        $objectMap.put("resultPanel", resultPanel = new JPanel());
        
        resultPanel.setName("resultPanel");
        resultPanel.setLayout(new GridLayout(0,1));
    }

    protected void createShowPopupButton() {
        $objectMap.put("showPopupButton", showPopupButton = new JCheckBox());
        
        showPopupButton.setName("showPopupButton");
        showPopupButton.setText(t("jaxxdemo.numbereditor.showPopupButton"));
        showPopupButton.setSelected(true);
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
        showResetButton.setText(t("jaxxdemo.numbereditor.showReset"));
        showResetButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(numberEditorConfigurationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToNumberEditorConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(integerEditor);
        $JPanel0.add(floatEditor);
        $JPanel0.add(doubleEditor);
        addChildrenToResultPanel();
        
        // apply 21 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 17 property setters
        SwingUtil.setText(integerNumberPattern, "-?\\d{0,3}");
        
        SwingUtil.setText(floatNumberPattern, "\\d{0,1}.\\d{0,2}");
        
        SwingUtil.setText(doubleNumberPattern, "-?\\d{0,4}.\\d{0,6}");
        
        numberEditorConfigurationPanel.setBorder(new TitledBorder(t("jaxxdemo.numbereditor.configuration")));
        integerNumberConfig.setLabelFor(integerNumberPattern);
        floatNumberConfig.setLabelFor(floatNumberPattern);
        doubleNumberConfig.setLabelFor(doubleNumberPattern);
        integerEditor.setBean(model);
        integerEditor.setNumberType(Integer.class);
        floatEditor.setBean(model);
        floatEditor.setNumberType(Float.class);
        doubleEditor.setBean(model);
        doubleEditor.setNumberType(Double.class);
        resultPanel.setBorder(new TitledBorder(t("jaxxdemo.numbereditor.model")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createNumberEditorConfigurationPanel();
        createShowPopupButton();
        createShowResetButton();
        createAutoPopupButton();
        createIntegerNumberConfig();
        createIntegerNumberPattern();
        createIntegerNumberEnabled();
        createFloatNumberConfig();
        createFloatNumberPattern();
        createFloatNumberEnabled();
        createDoubleNumberConfig();
        createDoubleNumberPattern();
        createDoubleNumberEnabled();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout());
        createIntegerEditor();
        createFloatEditor();
        createDoubleEditor();
        createResultPanel();
        createResultInteger();
        createResultFloat();
        createResultDouble();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 21 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 21 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INTEGER_EDITOR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (integerNumberEnabled != null) {
                    $bindingSources.put("integerNumberEnabled.getModel()", integerNumberEnabled.getModel());
                    integerNumberEnabled.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    integerNumberEnabled.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_INTEGER_EDITOR_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (integerNumberEnabled != null) {
                    integerEditor.setEnabled(integerNumberEnabled.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (integerNumberEnabled != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("integerNumberEnabled.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    integerNumberEnabled.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_INTEGER_EDITOR_ENABLED));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INTEGER_EDITOR_AUTO_POPUP, true) {
        
            @Override
            public void applyDataBinding() {
                if (autoPopupButton != null) {
                    $bindingSources.put("autoPopupButton.getModel()", autoPopupButton.getModel());
                    autoPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    autoPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_INTEGER_EDITOR_AUTO_POPUP));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (autoPopupButton != null) {
                    integerEditor.setAutoPopup(autoPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (autoPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("autoPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    autoPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_INTEGER_EDITOR_AUTO_POPUP));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INTEGER_EDITOR_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("integerNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    integerEditor.setNumberValue(model.getIntegerNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("integerNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INTEGER_EDITOR_NUMBER_PATTERN, true) {
        
            @Override
            public void applyDataBinding() {
                if (integerNumberPattern != null) {
                    $bindingSources.put("integerNumberPattern.getDocument()", integerNumberPattern.getDocument());
                    integerNumberPattern.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u2"));
                    integerNumberPattern.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_INTEGER_EDITOR_NUMBER_PATTERN));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (integerNumberPattern != null) {
                    integerEditor.setNumberPattern(integerNumberPattern.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (integerNumberPattern != null) {
                    Document $target = (Document) $bindingSources.remove("integerNumberPattern.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u2"));
                    }
                    integerNumberPattern.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_INTEGER_EDITOR_NUMBER_PATTERN));
                }
            }
        
            public void $pr$u2(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INTEGER_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_INTEGER_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    integerEditor.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_INTEGER_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INTEGER_EDITOR_SHOW_POPUP_BUTTON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupButton != null) {
                    $bindingSources.put("showPopupButton.getModel()", showPopupButton.getModel());
                    showPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    showPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_INTEGER_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupButton != null) {
                    integerEditor.setShowPopupButton(showPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    showPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_INTEGER_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FLOAT_EDITOR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (floatNumberEnabled != null) {
                    $bindingSources.put("floatNumberEnabled.getModel()", floatNumberEnabled.getModel());
                    floatNumberEnabled.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    floatNumberEnabled.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_FLOAT_EDITOR_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (floatNumberEnabled != null) {
                    floatEditor.setEnabled(floatNumberEnabled.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (floatNumberEnabled != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("floatNumberEnabled.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    }
                    floatNumberEnabled.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_FLOAT_EDITOR_ENABLED));
                }
            }
        
            public void $pr$u5(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FLOAT_EDITOR_AUTO_POPUP, true) {
        
            @Override
            public void applyDataBinding() {
                if (autoPopupButton != null) {
                    $bindingSources.put("autoPopupButton.getModel()", autoPopupButton.getModel());
                    autoPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u6"));
                    autoPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_FLOAT_EDITOR_AUTO_POPUP));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (autoPopupButton != null) {
                    floatEditor.setAutoPopup(autoPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (autoPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("autoPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u6"));
                    }
                    autoPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_FLOAT_EDITOR_AUTO_POPUP));
                }
            }
        
            public void $pr$u6(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FLOAT_EDITOR_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("floatNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    floatEditor.setNumberValue(model.getFloatNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("floatNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FLOAT_EDITOR_NUMBER_PATTERN, true) {
        
            @Override
            public void applyDataBinding() {
                if (floatNumberPattern != null) {
                    $bindingSources.put("floatNumberPattern.getDocument()", floatNumberPattern.getDocument());
                    floatNumberPattern.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u7"));
                    floatNumberPattern.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_FLOAT_EDITOR_NUMBER_PATTERN));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (floatNumberPattern != null) {
                    floatEditor.setNumberPattern(floatNumberPattern.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (floatNumberPattern != null) {
                    Document $target = (Document) $bindingSources.remove("floatNumberPattern.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u7"));
                    }
                    floatNumberPattern.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_FLOAT_EDITOR_NUMBER_PATTERN));
                }
            }
        
            public void $pr$u7(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FLOAT_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u8"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_FLOAT_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    floatEditor.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u8"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_FLOAT_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u8(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FLOAT_EDITOR_SHOW_POPUP_BUTTON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupButton != null) {
                    $bindingSources.put("showPopupButton.getModel()", showPopupButton.getModel());
                    showPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u9"));
                    showPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_FLOAT_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupButton != null) {
                    floatEditor.setShowPopupButton(showPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u9"));
                    }
                    showPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_FLOAT_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            public void $pr$u9(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_EDITOR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (doubleNumberEnabled != null) {
                    $bindingSources.put("doubleNumberEnabled.getModel()", doubleNumberEnabled.getModel());
                    doubleNumberEnabled.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u10"));
                    doubleNumberEnabled.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_DOUBLE_EDITOR_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (doubleNumberEnabled != null) {
                    doubleEditor.setEnabled(doubleNumberEnabled.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (doubleNumberEnabled != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("doubleNumberEnabled.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u10"));
                    }
                    doubleNumberEnabled.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_DOUBLE_EDITOR_ENABLED));
                }
            }
        
            public void $pr$u10(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_EDITOR_AUTO_POPUP, true) {
        
            @Override
            public void applyDataBinding() {
                if (autoPopupButton != null) {
                    $bindingSources.put("autoPopupButton.getModel()", autoPopupButton.getModel());
                    autoPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u11"));
                    autoPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_DOUBLE_EDITOR_AUTO_POPUP));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (autoPopupButton != null) {
                    doubleEditor.setAutoPopup(autoPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (autoPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("autoPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u11"));
                    }
                    autoPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_DOUBLE_EDITOR_AUTO_POPUP));
                }
            }
        
            public void $pr$u11(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_EDITOR_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("doubleNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    doubleEditor.setNumberValue(model.getDoubleNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("doubleNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_EDITOR_NUMBER_PATTERN, true) {
        
            @Override
            public void applyDataBinding() {
                if (doubleNumberPattern != null) {
                    $bindingSources.put("doubleNumberPattern.getDocument()", doubleNumberPattern.getDocument());
                    doubleNumberPattern.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u12"));
                    doubleNumberPattern.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_DOUBLE_EDITOR_NUMBER_PATTERN));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (doubleNumberPattern != null) {
                    doubleEditor.setNumberPattern(doubleNumberPattern.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (doubleNumberPattern != null) {
                    Document $target = (Document) $bindingSources.remove("doubleNumberPattern.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u12"));
                    }
                    doubleNumberPattern.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_DOUBLE_EDITOR_NUMBER_PATTERN));
                }
            }
        
            public void $pr$u12(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_EDITOR_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u13"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_DOUBLE_EDITOR_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    doubleEditor.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u13"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_DOUBLE_EDITOR_SHOW_RESET));
                }
            }
        
            public void $pr$u13(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_EDITOR_SHOW_POPUP_BUTTON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupButton != null) {
                    $bindingSources.put("showPopupButton.getModel()", showPopupButton.getModel());
                    showPopupButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u14"));
                    showPopupButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_DOUBLE_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupButton != null) {
                    doubleEditor.setShowPopupButton(showPopupButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showPopupButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u14"));
                    }
                    showPopupButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.NumberEditor2Demo.this, BINDING_DOUBLE_EDITOR_SHOW_POPUP_BUTTON));
                }
            }
        
            public void $pr$u14(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_INTEGER_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("integerNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultInteger.setText(t(t("jaxxdemo.numbereditor.model.integer", model.getIntegerNumber())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("integerNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_FLOAT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("floatNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultFloat.setText(t(t("jaxxdemo.numbereditor.model.float", model.getFloatNumber())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("floatNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_DOUBLE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("doubleNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultDouble.setText(t(t("jaxxdemo.numbereditor.model.double", model.getDoubleNumber())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("doubleNumber", this);
                }
            }
        });
    }

}