package jaxx.demo.component.jaxx.editor;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.demo.DemoPanel;
import jaxx.demo.entities.People;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class BeanFilterableComboBoxDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMBO_BOX_FILTERABLE = "comboBox.filterable";
    public static final String BINDING_COMBO_BOX_INVALID_COMBO_EDITOR_TEXT_COLOR = "comboBox.invalidComboEditorTextColor";
    public static final String BINDING_COMBO_BOX_SHOW_DECORATOR = "comboBox.showDecorator";
    public static final String BINDING_COMBO_BOX_SHOW_RESET = "comboBox.showReset";
    public static final String BINDING_SELECTED_RESULT_TEXT = "selectedResult.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz28bRRR+MXV+OGmTNrQqamhNyMGRyrpFQqAG0WKnEYkMreIcKnzprHcST1nvLLNv6w1WEX8CfwLcuSBx44Q4cObABfEvIMSBK+LNeL322utmRXLYWG/e+/Z73773zXd/QjFQ8MYzFkWWCj0UXW4dfPjkySP7GW/jLg/aSvgoFQz+5gpQaMGyk8QDhDdbDV1ejcurddn1pce9seqdBpQCPHV50OEcEV5PV7SDoNpMjnciP1RD1IRUFuo3f/9V+Nr56tsCQOQTuxK1Uj6ratTJhQYUhINwhd70nFVd5p0QDSW8E+J7UcfqLguCT1iXfw5fwkID5n2mCAxhM3/LBsPURz7C8tYu78rHzOPuHYR7hqxDEas9hLBMjDuCQKwaZ96ecJErZhOU7NqyJiMN4fsGdB5hYetIHxLc9VTvQY86scyZzlxKCq60pXcsTkLFUEjPcKGg7jeKiw5MUKevJFVrxwmPWogoPYSrqZp6h7c/I3Y6fzUpWw06snfIA46DKh1+NZ2yrlN2eVsSIalmpm21pSuV+ILve8+ZKxyjxkOj0xGPZsMvtmPZEN7JEChW2ialZ8id1mFZ8SB0MVHocvr4UsBd2hzuHJq0SWEbzB6U3fRpWG+k+NAaWKM1GM3pXAuKKqQwfeHW9OYc0tFgZ65P7IwGNKf/Xlv/7cc/ftgbLsoKvftqZurYntMA+0r6XKHQr14dbEmIwq1+zPydFiwNWjUmsJFBrBkfEzl632Vdbuly6yMWdAiiuPD7Tz9fe/rrK1DYg5IrmbPHdP4+LGGHVO5I14n8+w8Mo5XeIj3XNDeEeVsqh4jBQd/jvfKRQJc7NROrYGVTMzFLpT/qaGzNHNgyivdtbAc2t7dfRCTgRoaASRf20i//rDe/fzAUcY6aem1m+kjI4qcwLzxXeNz4TWwlmf6y7Ac8dOTIMrJMBDI32I8NoWKet6dUK9AiDEcT4QKqkOt/tDgIVh7BRuEo1K+4YyTQv96GDHc4D5+38vBJfCWLzqTrnIfN3bxsEgvLYpRlcudhVcs35C9zzCyauUz2LN5FhBsis76u0REe9fO8xhJBM+6+sl2+XzYGwnpoGRTr8OFu+V7ZC133BcLFlLx0Qfcz9E4BUlFpJBvCrf7kCE+li7vveY8VPxZ0lawl+pPiXUpG8sPh0CHc7E9MYBosS/rknjpL3nEDrP9vAxxcYwPnmyYzfsvl4BMP5bv9DvMclyvrhGMzdRFWht2NH+0j71ZmMJi4SPOI4rJTSWLDpfcdhqxsC8+hS/eDKfQ5/SydiajD5vI/zUZYy8FpUX+Bo1OfvwRn49xMbhHCf52LT+PLCwAA";
    private static final Log log = LogFactory.getLog(BeanFilterableComboBoxDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox colorizeInvalidComboEditorTextButton;
    protected BeanFilterableComboBox<People> comboBox;
    protected JPanel configurationPanel;
    protected JCheckBox filterableButton;
    protected final BeanFilterableComboBoxDemoHandler handler = new BeanFilterableComboBoxDemoHandler();
    protected JPanel resultPanel;
    protected JLabel selectedResult;
    protected JCheckBox showDecoratorButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BeanFilterableComboBoxDemo $DemoPanel0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanFilterableComboBoxDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public BeanFilterableComboBoxDemo() {
        $initialize();
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BeanFilterableComboBoxDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getColorizeInvalidComboEditorTextButton() {
        return colorizeInvalidComboEditorTextButton;
    }

    public BeanFilterableComboBox<People> getComboBox() {
        return comboBox;
    }

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public JCheckBox getFilterableButton() {
        return filterableButton;
    }

    public BeanFilterableComboBoxDemoHandler getHandler() {
        return handler;
    }

    public JPanel getResultPanel() {
        return resultPanel;
    }

    public JLabel getSelectedResult() {
        return selectedResult;
    }

    public JCheckBox getShowDecoratorButton() {
        return showDecoratorButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(filterableButton);
        configurationPanel.add(showResetButton);
        configurationPanel.add(showDecoratorButton);
        configurationPanel.add(colorizeInvalidComboEditorTextButton);
    }

    protected void addChildrenToResultPanel() {
        if (!allComponentsCreated) {
            return;
        }
        resultPanel.add(selectedResult, BorderLayout.CENTER);
    }

    protected void createColorizeInvalidComboEditorTextButton() {
        $objectMap.put("colorizeInvalidComboEditorTextButton", colorizeInvalidComboEditorTextButton = new JCheckBox());
        
        colorizeInvalidComboEditorTextButton.setName("colorizeInvalidComboEditorTextButton");
        colorizeInvalidComboEditorTextButton.setText(t("jaxxdemo.beanfilterablecomboboxdemo.colorizeInvalidComboEditorText"));
        colorizeInvalidComboEditorTextButton.setSelected(true);
    }

    protected void createComboBox() {
        $objectMap.put("comboBox", comboBox = new BeanFilterableComboBox<People>());
        
        comboBox.setName("comboBox");
        comboBox.setI18nPrefix("jaxxdemo.common.");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new GridLayout(0,1));
    }

    protected void createFilterableButton() {
        $objectMap.put("filterableButton", filterableButton = new JCheckBox());
        
        filterableButton.setName("filterableButton");
        filterableButton.setText(t("jaxxdemo.beanfilterablecomboboxdemo.filterable"));
        filterableButton.setSelected(true);
    }

    protected void createResultPanel() {
        $objectMap.put("resultPanel", resultPanel = new JPanel());
        
        resultPanel.setName("resultPanel");
        resultPanel.setLayout(new BorderLayout());
    }

    protected void createSelectedResult() {
        $objectMap.put("selectedResult", selectedResult = new JLabel());
        
        selectedResult.setName("selectedResult");
    }

    protected void createShowDecoratorButton() {
        $objectMap.put("showDecoratorButton", showDecoratorButton = new JCheckBox());
        
        showDecoratorButton.setName("showDecoratorButton");
        showDecoratorButton.setText(t("jaxxdemo.beanfilterablecomboboxdemo.showDecorator"));
        showDecoratorButton.setSelected(true);
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
        showResetButton.setText(t("jaxxdemo.beanfilterablecomboboxdemo.showReset"));
        showResetButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(configurationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(comboBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToConfigurationPanel();
        addChildrenToResultPanel();
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        comboBox.setBeanType(People.class);
        configurationPanel.setBorder(new TitledBorder(t("jaxxdemo.beanfilterablecomboboxdemo.configuration")));
        resultPanel.setBorder(new TitledBorder(t("jaxxdemo.beanfilterablecomboboxdemo.result")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigurationPanel();
        createFilterableButton();
        createShowResetButton();
        createShowDecoratorButton();
        createColorizeInvalidComboEditorTextButton();
        createComboBox();
        createResultPanel();
        createSelectedResult();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_BOX_INVALID_COMBO_EDITOR_TEXT_COLOR, true) {
        
            @Override
            public void applyDataBinding() {
                if (colorizeInvalidComboEditorTextButton != null) {
                    $bindingSources.put("colorizeInvalidComboEditorTextButton.getModel()", colorizeInvalidComboEditorTextButton.getModel());
                    colorizeInvalidComboEditorTextButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    colorizeInvalidComboEditorTextButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_INVALID_COMBO_EDITOR_TEXT_COLOR));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (colorizeInvalidComboEditorTextButton != null) {
                    comboBox.setInvalidComboEditorTextColor(colorizeInvalidComboEditorTextButton.isSelected() ? java.awt.Color.RED : null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (colorizeInvalidComboEditorTextButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("colorizeInvalidComboEditorTextButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    colorizeInvalidComboEditorTextButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_INVALID_COMBO_EDITOR_TEXT_COLOR));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_BOX_SHOW_DECORATOR, true) {
        
            @Override
            public void applyDataBinding() {
                if (showDecoratorButton != null) {
                    $bindingSources.put("showDecoratorButton.getModel()", showDecoratorButton.getModel());
                    showDecoratorButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    showDecoratorButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_DECORATOR));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showDecoratorButton != null) {
                    comboBox.setShowDecorator(showDecoratorButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showDecoratorButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showDecoratorButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    showDecoratorButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_DECORATOR));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_BOX_FILTERABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (filterableButton != null) {
                    $bindingSources.put("filterableButton.getModel()", filterableButton.getModel());
                    filterableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    filterableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_FILTERABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (filterableButton != null) {
                    comboBox.setFilterable(filterableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (filterableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("filterableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    filterableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_FILTERABLE));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_BOX_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    comboBox.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanFilterableComboBoxDemo.this, BINDING_COMBO_BOX_SHOW_RESET));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_RESULT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (comboBox != null) {
                    comboBox.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (comboBox != null) {
                    selectedResult.setText(t(handler.getSelectedResult(comboBox.getSelectedItem())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (comboBox != null) {
                    comboBox.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
    }

}