package jaxx.runtime.swing.config.model;

/*
 * #%L
 * JAXX :: Config
 * $Id: CallBackMap.java 2586 2013-03-03 15:33:39Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.7/jaxx-config/src/main/java/jaxx/runtime/swing/config/model/CallBackMap.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.LinkedHashMap;
import java.util.List;

/**
 * A convient map of callback entry for a list of option.
 * <p/>
 * This model is used to store callbacks to use before a saving action.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.5.11
 */
public class CallBackMap extends LinkedHashMap<CallBackEntry, List<OptionModel>> {
    private static final long serialVersionUID = 1L;

    public boolean containsCallBack(String callBackName) {
        for (CallBackEntry entry : keySet()) {
            if (callBackName.equals(entry.getName())) {
                return true;
            }
        }
        return false;
    }

    public CallBackEntry getCallBack(String callBackName) {
        for (CallBackEntry entry : keySet()) {
            if (callBackName.equals(entry.getName())) {
                return entry;
            }
        }
        return null;
    }
}
