package org.nuiton.jaxx.application.swing.util;

/*
 * #%L
 * JAXX :: Application Swing
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;
import java.awt.Component;

/**
 * @author Tony Chemit - chemit@codelutin.com
 * @since 2.8
 */
public class ActionListCellRenderer extends DefaultListCellRenderer {

    private static final long serialVersionUID = 1L;

    protected final EmptyBorder border = new EmptyBorder(4, 8, 4, 8);

    @Override
    public Component getListCellRendererComponent(JList list,
                                                  Object value,
                                                  int index,
                                                  boolean isSelected,
                                                  boolean cellHasFocus) {

        Component result = super.getListCellRendererComponent(
                list, value, index, isSelected, cellHasFocus);
        Action action = ((JButton) value).getAction();
        setIcon((Icon) action.getValue(Action.LARGE_ICON_KEY));
        setText((String) action.getValue(Action.NAME));
        setToolTipText((String) action.getValue(Action.SHORT_DESCRIPTION));
        setEnabled(action.isEnabled());
        setBorder(border);
        return result;
    }
}
