package org.nuiton.jaxx.application.swing.table;

/*
 * #%L
 * JAXX :: Application Swing
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import jaxx.runtime.validator.swing.SwingListValidatorDataLocator;
import org.apache.commons.lang3.tuple.Pair;

import javax.swing.table.TableModel;
import java.io.Serializable;

/**
 * To locate data in a {@link AbstractApplicationTableModel}.
 *
 * Created on 8/14/14.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 2.10
 */
public class ApplicationTableModelValidatorDataLocator<R extends Serializable, T extends AbstractApplicationTableModel<R>> implements SwingListValidatorDataLocator<R> {

    public static <R extends Serializable, T extends AbstractApplicationTableModel<R>> ApplicationTableModelValidatorDataLocator<R, T> newLocator(Class<R> rowType) {
        return new ApplicationTableModelValidatorDataLocator<R, T>(rowType);
    }

    private final Class<R> rowType;

    public ApplicationTableModelValidatorDataLocator(Class<R> rowType) {
        this.rowType = rowType;
    }

    @Override
    public boolean acceptType(Class<?> beanType) {
        return rowType.isAssignableFrom(beanType);
    }

    @Override
    public Pair<Integer, Integer> locateDataCell(TableModel tableModel,
                                                 R bean,
                                                 String fieldName) {
        T model = (T) tableModel;

        Pair<Integer, Integer> cell = model.getCell(bean, fieldName);
        return cell;
    }

    @Override
    public int locateBeanRowIndex(TableModel tableModel, R bean) {
        T model = (T) tableModel;
        return model.getRowIndex(bean);
    }

    @Override
    public R locateBean(TableModel tableModel, int rowIndex) {
        T model = (T) tableModel;
        return model.getEntry(rowIndex);
    }
}
