package org.nuiton.jaxx.application.bean;

/*
 * #%L
 * JAXX :: Application API
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/**
 * Created on 8/12/14.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 2.10
 */
public class JavaBeanObjectPropagateChangeListener implements PropertyChangeListener {

    public static void listenAndPropagate(JavaBeanObject producer,
                                          JavaBeanObject consumer,
                                          String propertyNameToListen,
                                          String propertyNameToForward) {
        JavaBeanObjectPropagateChangeListener listener =
                new JavaBeanObjectPropagateChangeListener(propertyNameToForward,
                                                          consumer);
        producer.addPropertyChangeListener(propertyNameToListen, listener);
    }

    public static void listenAndPropagateAll(JavaBeanObject producer,
                                             JavaBeanObject consumer) {
        JavaBeanObjectPropagateChangeListener listener =
                new JavaBeanObjectPropagateChangeListener(null, consumer);
        producer.addPropertyChangeListener(listener);
    }

    private final String propertyName;

    private final JavaBeanObject editor;

    public JavaBeanObjectPropagateChangeListener(String propertyName,
                                                 JavaBeanObject editor) {
        this.propertyName = propertyName;
        this.editor = editor;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = propertyName == null ? evt.getPropertyName() : propertyName;
        editor.firePropertyChanged(name,
                                   evt.getOldValue(),
                                   evt.getNewValue());
    }

}
