/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorException;
import org.nuiton.eugene.java.AbstractJavaBeanTransformer;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.java.JavaTemplatesGeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;

public class SimpleJavaBeanTransformer
extends AbstractJavaBeanTransformer {
    private static final Log log = LogFactory.getLog(SimpleJavaBeanTransformer.class);

    public void transformFromClass(ObjectModelClass input) {
        if (!JavaTemplatesGeneratorUtil.hasBeanStereotype((ObjectModelClassifier)input)) {
            return;
        }
        if (this.canGenerate(input)) {
            ObjectModelClass objectModelClass = this.generateBean(input);
        }
    }

    protected boolean canGenerate(ObjectModelClass input) {
        boolean canGenerate;
        boolean bl = canGenerate = !this.isInClassPath((ObjectModelClassifier)input);
        if (canGenerate && !input.getOperations().isEmpty()) {
            throw new GeneratorException("Can't generate a simple bean as class " + input.getQualifiedName() + " contains so operations." + "\nUse instead the JavaBeanTransformer.");
        }
        return canGenerate;
    }

    protected ObjectModelClass generateBean(ObjectModelClass input) {
        boolean hasAMultipleProperty;
        String noPCSTagValue;
        String i18nPrefix;
        boolean superClassIsBean = false;
        Collection superclasses = input.getSuperclasses();
        if (CollectionUtils.isNotEmpty((Collection)superclasses)) {
            for (ObjectModelClass superclass : superclasses) {
                if (!JavaTemplatesGeneratorUtil.hasBeanStereotype((ObjectModelClassifier)superclass)) continue;
                superClassIsBean = true;
                break;
            }
        }
        String superClass = null;
        if (!superClassIsBean && (superClass = JavaTemplatesGeneratorUtil.getBeanSuperClassTagValue((ObjectModel)this.model, (ObjectModelClassifier)input)) != null) {
            superClassIsBean = true;
        }
        ObjectModelClass output = this.createClass(input.getName(), input.getPackageName());
        if (superClass != null) {
            this.setSuperClass(output, superClass);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("will generate " + output.getQualifiedName()));
        }
        if (!StringUtils.isEmpty((CharSequence)(i18nPrefix = JavaGeneratorUtil.getI18nPrefixTagValue((ObjectModelElement)input, (ObjectModel)((ObjectModel)this.model))))) {
            this.generateI18nBlock((ObjectModelClassifier)input, (ObjectModelClassifier)output, i18nPrefix);
        }
        boolean usePCS = StringUtils.isEmpty((CharSequence)(noPCSTagValue = JavaTemplatesGeneratorUtil.getNoPCSTagValue((ObjectModel)this.model, (ObjectModelClassifier)input))) || !"true".equals(noPCSTagValue.trim());
        String noGenerateBooleanGetMethods = JavaGeneratorUtil.getDoNotGenerateBooleanGetMethods((ObjectModel)((ObjectModel)this.model), (ObjectModelClassifier)input);
        boolean generateBooleanGetMethods = StringUtils.isEmpty((CharSequence)noGenerateBooleanGetMethods) || !"true".equals(noGenerateBooleanGetMethods.trim());
        String prefix = this.getConstantPrefix((ObjectModelClassifier)input, "PROPERTY_");
        this.setConstantPrefix(prefix);
        this.addSuperClass(input, output);
        boolean serializableFound = this.addInterfaces(input, output);
        if (superClassIsBean) {
            serializableFound = true;
        }
        this.addSerializable(input, output, serializableFound);
        Set constantNames = this.addConstantsFromDependency((ObjectModelClassifier)input, (ObjectModelClassifier)output);
        List<ObjectModelAttribute> properties = this.getProperties(input);
        for (ObjectModelAttribute attr : properties) {
            this.createPropertyConstant(output, attr, prefix, constantNames);
        }
        for (ObjectModelAttribute attr : properties) {
            this.createProperty(output, attr, usePCS, generateBooleanGetMethods);
        }
        if (!superClassIsBean && usePCS) {
            this.createPropertyChangeSupport(output);
        }
        if ((hasAMultipleProperty = this.containsMutiple(properties)) && !superClassIsBean) {
            this.createGetChildMethod(output);
        }
        return output;
    }

    protected void addSuperClass(ObjectModelClass input, ObjectModelClass output) {
        Iterator j = input.getSuperclasses().iterator();
        if (j.hasNext()) {
            ObjectModelClass p = (ObjectModelClass)j.next();
            String qualifiedName = p.getQualifiedName();
            this.setSuperClass(output, qualifiedName);
        }
    }
}

