/*
 * Decompiled with CFR 0.152.
 */
package rpc.security.ntlm;

import gnu.crypto.hash.MD4;
import gnu.crypto.hash.MD5;
import gnu.crypto.prng.ARCFour;
import gnu.crypto.prng.IRandom;
import gnu.crypto.prng.LimitReachedException;
import java.io.UnsupportedEncodingException;
import java.security.DigestException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import rpc.security.ntlm.Responses;

class NTLMKeyFactory {
    Random random = new Random();
    private static final byte[] clientSigningMagicConstant = new byte[]{115, 101, 115, 115, 105, 111, 110, 32, 107, 101, 121, 32, 116, 111, 32, 99, 108, 105, 101, 110, 116, 45, 116, 111, 45, 115, 101, 114, 118, 101, 114, 32, 115, 105, 103, 110, 105, 110, 103, 32, 107, 101, 121, 32, 109, 97, 103, 105, 99, 32, 99, 111, 110, 115, 116, 97, 110, 116, 0};
    private static final byte[] serverSigningMagicConstant = new byte[]{115, 101, 115, 115, 105, 111, 110, 32, 107, 101, 121, 32, 116, 111, 32, 115, 101, 114, 118, 101, 114, 45, 116, 111, 45, 99, 108, 105, 101, 110, 116, 32, 115, 105, 103, 110, 105, 110, 103, 32, 107, 101, 121, 32, 109, 97, 103, 105, 99, 32, 99, 111, 110, 115, 116, 97, 110, 116, 0};
    private static final byte[] clientSealingMagicConstant = new byte[]{115, 101, 115, 115, 105, 111, 110, 32, 107, 101, 121, 32, 116, 111, 32, 99, 108, 105, 101, 110, 116, 45, 116, 111, 45, 115, 101, 114, 118, 101, 114, 32, 115, 101, 97, 108, 105, 110, 103, 32, 107, 101, 121, 32, 109, 97, 103, 105, 99, 32, 99, 111, 110, 115, 116, 97, 110, 116, 0};
    private static final byte[] serverSealingMagicConstant = new byte[]{115, 101, 115, 115, 105, 111, 110, 32, 107, 101, 121, 32, 116, 111, 32, 115, 101, 114, 118, 101, 114, 45, 116, 111, 45, 99, 108, 105, 101, 110, 116, 32, 115, 101, 97, 108, 105, 110, 103, 32, 107, 101, 121, 32, 109, 97, 103, 105, 99, 32, 99, 111, 110, 115, 116, 97, 110, 116, 0};

    NTLMKeyFactory() {
    }

    byte[] getNTLMUserSessionKey(String password) throws UnsupportedEncodingException, DigestException {
        byte[] key = new byte[16];
        byte[] ntlmHash = Responses.ntlmHash(password);
        MD4 md4 = new MD4();
        md4.update(ntlmHash, 0, ntlmHash.length);
        key = md4.digest();
        return key;
    }

    byte[] getNTLM2SessionResponseUserSessionKey(String password, byte[] servernonce) throws NoSuchAlgorithmException, UnsupportedEncodingException, DigestException {
        return Responses.hmacMD5(servernonce, this.getNTLMUserSessionKey(password));
    }

    byte[] getSecondarySessionKey() {
        byte[] key = new byte[16];
        this.random.nextBytes(key);
        return key;
    }

    IRandom getARCFOUR(byte[] key) {
        HashMap<String, byte[]> attrib = new HashMap<String, byte[]>();
        ARCFour keystream = new ARCFour();
        attrib.put("gnu.crypto.prng.arcfour.key-material", key);
        keystream.init(attrib);
        return keystream;
    }

    byte[] applyARCFOUR(IRandom keystream, byte[] data) throws IllegalStateException, LimitReachedException {
        byte[] retData = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            retData[i] = (byte)(data[i] ^ keystream.nextByte());
        }
        return retData;
    }

    byte[] decryptSecondarySessionKey(byte[] encryptedData, byte[] key) throws IllegalStateException, LimitReachedException {
        return this.applyARCFOUR(this.getARCFOUR(key), encryptedData);
    }

    byte[] encryptSecondarySessionKey(byte[] plainData, byte[] key) throws IllegalStateException, LimitReachedException {
        return this.applyARCFOUR(this.getARCFOUR(key), plainData);
    }

    byte[] generateClientSigningKeyUsingNegotiatedSecondarySessionKey(byte[] secondarySessionKey) {
        byte[] dataforhash = new byte[secondarySessionKey.length + clientSigningMagicConstant.length];
        System.arraycopy(secondarySessionKey, 0, dataforhash, 0, secondarySessionKey.length);
        System.arraycopy(clientSigningMagicConstant, 0, dataforhash, secondarySessionKey.length, clientSigningMagicConstant.length);
        MD5 md5 = new MD5();
        md5.update(dataforhash, 0, dataforhash.length);
        return md5.digest();
    }

    byte[] generateClientSealingKeyUsingNegotiatedSecondarySessionKey(byte[] secondarySessionKey) {
        byte[] dataforhash = new byte[secondarySessionKey.length + clientSealingMagicConstant.length];
        System.arraycopy(secondarySessionKey, 0, dataforhash, 0, secondarySessionKey.length);
        System.arraycopy(clientSealingMagicConstant, 0, dataforhash, secondarySessionKey.length, clientSealingMagicConstant.length);
        MD5 md5 = new MD5();
        md5.update(dataforhash, 0, dataforhash.length);
        return md5.digest();
    }

    byte[] generateServerSigningKeyUsingNegotiatedSecondarySessionKey(byte[] secondarySessionKey) {
        byte[] dataforhash = new byte[secondarySessionKey.length + serverSigningMagicConstant.length];
        System.arraycopy(secondarySessionKey, 0, dataforhash, 0, secondarySessionKey.length);
        System.arraycopy(serverSigningMagicConstant, 0, dataforhash, secondarySessionKey.length, serverSigningMagicConstant.length);
        MD5 md5 = new MD5();
        md5.update(dataforhash, 0, dataforhash.length);
        return md5.digest();
    }

    byte[] generateServerSealingKeyUsingNegotiatedSecondarySessionKey(byte[] secondarySessionKey) {
        byte[] dataforhash = new byte[secondarySessionKey.length + serverSealingMagicConstant.length];
        System.arraycopy(secondarySessionKey, 0, dataforhash, 0, secondarySessionKey.length);
        System.arraycopy(serverSealingMagicConstant, 0, dataforhash, secondarySessionKey.length, serverSealingMagicConstant.length);
        MD5 md5 = new MD5();
        md5.update(dataforhash, 0, dataforhash.length);
        return md5.digest();
    }

    byte[] signingPt1(int sequenceNumber, byte[] signingKey, byte[] data, int lengthOfBuffer) throws NoSuchAlgorithmException, IllegalStateException, LimitReachedException {
        byte[] seqNumPlusData = new byte[4 + lengthOfBuffer];
        seqNumPlusData[0] = (byte)(sequenceNumber & 0xFF);
        seqNumPlusData[1] = (byte)(sequenceNumber >> 8 & 0xFF);
        seqNumPlusData[2] = (byte)(sequenceNumber >> 16 & 0xFF);
        seqNumPlusData[3] = (byte)(sequenceNumber >> 24 & 0xFF);
        System.arraycopy(data, 0, seqNumPlusData, 4, lengthOfBuffer);
        byte[] retval = new byte[16];
        retval[0] = 1;
        byte[] sign = Responses.hmacMD5(seqNumPlusData, signingKey);
        for (int i = 0; i < 8; ++i) {
            retval[i + 4] = sign[i];
        }
        retval[12] = (byte)(sequenceNumber & 0xFF);
        retval[13] = (byte)(sequenceNumber >> 8 & 0xFF);
        retval[14] = (byte)(sequenceNumber >> 16 & 0xFF);
        retval[15] = (byte)(sequenceNumber >> 24 & 0xFF);
        return retval;
    }

    void signingPt2(byte[] verifier, IRandom rc4) throws IllegalStateException, LimitReachedException {
        for (int i = 0; i < 8; ++i) {
            verifier[i + 4] = (byte)(verifier[i + 4] ^ rc4.nextByte());
        }
    }

    boolean compareSignature(byte[] src, byte[] target) {
        return Arrays.equals(src, target);
    }
}

