/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github.extras.okhttp3;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketPermission;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.Principal;
import java.security.cert.Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Pipe;
import okio.Sink;
import okio.Timeout;

@Deprecated
@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="Deprecated external code")
public final class ObsoleteUrlFactory
implements URLStreamHandlerFactory,
Cloneable {
    static final String SELECTED_PROTOCOL = "ObsoleteUrlFactory-Selected-Protocol";
    static final String RESPONSE_SOURCE = "ObsoleteUrlFactory-Response-Source";
    static final Set<String> METHODS = new LinkedHashSet<String>(Arrays.asList("OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "PATCH"));
    static final TimeZone UTC = TimeZone.getTimeZone("GMT");
    static final int HTTP_CONTINUE = 100;
    static final ThreadLocal<DateFormat> STANDARD_DATE_FORMAT = ThreadLocal.withInitial(() -> {
        SimpleDateFormat rfc1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        rfc1123.setLenient(false);
        rfc1123.setTimeZone(UTC);
        return rfc1123;
    });
    static final Comparator<String> FIELD_NAME_COMPARATOR = (a, b) -> {
        if (Objects.equals(a, b)) {
            return 0;
        }
        if (Objects.isNull(a)) {
            return -1;
        }
        if (Objects.isNull(b)) {
            return 1;
        }
        return String.CASE_INSENSITIVE_ORDER.compare(a, b);
    };
    private OkHttpClient client;

    public ObsoleteUrlFactory(OkHttpClient client) {
        this.client = client;
    }

    public OkHttpClient client() {
        return this.client;
    }

    public ObsoleteUrlFactory setClient(OkHttpClient client) {
        this.client = client;
        return this;
    }

    public ObsoleteUrlFactory clone() {
        return new ObsoleteUrlFactory(this.client);
    }

    public HttpURLConnection open(URL url) {
        return this.open(url, this.client.proxy());
    }

    HttpURLConnection open(URL url, @Nullable Proxy proxy) {
        String protocol = url.getProtocol();
        OkHttpClient copy = this.client.newBuilder().proxy(proxy).build();
        if (protocol.equals("http")) {
            return new OkHttpURLConnection(url, copy);
        }
        if (protocol.equals("https")) {
            return new OkHttpsURLConnection(url, copy);
        }
        throw new IllegalArgumentException("Unexpected protocol: " + protocol);
    }

    @Override
    public URLStreamHandler createURLStreamHandler(final String protocol) {
        if (!protocol.equals("http") && !protocol.equals("https")) {
            return null;
        }
        return new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL url) {
                return ObsoleteUrlFactory.this.open(url);
            }

            @Override
            protected URLConnection openConnection(URL url, Proxy proxy) {
                return ObsoleteUrlFactory.this.open(url, proxy);
            }

            @Override
            protected int getDefaultPort() {
                if (protocol.equals("http")) {
                    return 80;
                }
                if (protocol.equals("https")) {
                    return 443;
                }
                throw new AssertionError();
            }
        };
    }

    static String format(Date value) {
        return STANDARD_DATE_FORMAT.get().format(value);
    }

    static boolean permitsRequestBody(String method) {
        return !method.equals("GET") && !method.equals("HEAD");
    }

    static boolean hasBody(Response response) {
        if (response.request().method().equals("HEAD")) {
            return false;
        }
        int responseCode = response.code();
        if ((responseCode < 100 || responseCode >= 200) && responseCode != 204 && responseCode != 304) {
            return true;
        }
        return ObsoleteUrlFactory.contentLength(response.headers()) != -1L || "chunked".equalsIgnoreCase(response.header("Transfer-Encoding"));
    }

    static long contentLength(Headers headers) {
        String s = headers.get("Content-Length");
        if (s == null) {
            return -1L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    static String responseSourceHeader(Response response) {
        Response networkResponse = response.networkResponse();
        if (networkResponse == null) {
            return response.cacheResponse() == null ? "NONE" : "CACHE " + response.code();
        }
        return response.cacheResponse() == null ? "NETWORK " + response.code() : "CONDITIONAL_CACHE " + networkResponse.code();
    }

    static String statusLineToString(Response response) {
        return (response.protocol() == Protocol.HTTP_1_0 ? "HTTP/1.0" : "HTTP/1.1") + ' ' + response.code() + ' ' + response.message();
    }

    static String toHumanReadableAscii(String s) {
        int c;
        int length = s.length();
        for (int i = 0; i < length; i += Character.charCount(c)) {
            c = s.codePointAt(i);
            if (c > 31 && c < 127) continue;
            try (Buffer buffer = new Buffer();){
                buffer.writeUtf8(s, 0, i);
                buffer.writeUtf8CodePoint(63);
                for (int j = i + Character.charCount(c); j < length; j += Character.charCount(c)) {
                    c = s.codePointAt(j);
                    buffer.writeUtf8CodePoint(c > 31 && c < 127 ? c : 63);
                }
                String string = buffer.readUtf8();
                return string;
            }
        }
        return s;
    }

    static Map<String, List<String>> toMultimap(Headers headers, @Nullable String valueForNullKey) {
        TreeMap result = new TreeMap(FIELD_NAME_COMPARATOR);
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            String fieldName = headers.name(i);
            String value = headers.value(i);
            ArrayList<String> allValues = new ArrayList<String>();
            List otherValues = (List)result.get(fieldName);
            if (otherValues != null) {
                allValues.addAll(otherValues);
            }
            allValues.add(value);
            result.put(fieldName, Collections.unmodifiableList(allValues));
        }
        if (valueForNullKey != null) {
            result.put(null, Collections.unmodifiableList(Collections.singletonList(valueForNullKey)));
        }
        return Collections.unmodifiableMap(result);
    }

    static String getSystemProperty(String key, @Nullable String defaultValue) {
        String value;
        try {
            value = System.getProperty(key);
        }
        catch (AccessControlException ex) {
            return defaultValue;
        }
        return value != null ? value : defaultValue;
    }

    static String defaultUserAgent() {
        String agent = ObsoleteUrlFactory.getSystemProperty("http.agent", null);
        return agent != null ? ObsoleteUrlFactory.toHumanReadableAscii(agent) : "ObsoleteUrlFactory";
    }

    static IOException propagate(Throwable throwable) throws IOException {
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new AssertionError();
    }

    private static final class ResponseBodyInputStream
    extends InputStream {
        private final ResponseBody responseBody;
        private final InputStream inputStream;

        private ResponseBodyInputStream(ResponseBody responseBody) {
            this.responseBody = responseBody;
            this.inputStream = responseBody.byteStream();
        }

        @Override
        public int read() throws IOException {
            return this.inputStream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.inputStream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.inputStream.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.inputStream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.inputStream.available();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.inputStream.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.inputStream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.inputStream.markSupported();
        }

        @Override
        public void close() throws IOException {
            try {
                this.inputStream.close();
            }
            finally {
                this.responseBody.close();
            }
        }
    }

    static final class UnexpectedException
    extends IOException {
        static final Interceptor INTERCEPTOR = chain -> {
            try {
                return chain.proceed(chain.request());
            }
            catch (Error | RuntimeException e) {
                throw new UnexpectedException(e);
            }
        };

        UnexpectedException(Throwable cause) {
            super(cause);
        }
    }

    static final class OkHttpsURLConnection
    extends DelegatingHttpsURLConnection {
        private final OkHttpURLConnection delegate;

        OkHttpsURLConnection(URL url, OkHttpClient client) {
            this(new OkHttpURLConnection(url, client));
        }

        OkHttpsURLConnection(OkHttpURLConnection delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        protected Handshake handshake() {
            if (this.delegate.call == null) {
                throw new IllegalStateException("Connection has not yet been established");
            }
            return this.delegate.handshake;
        }

        @Override
        public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.delegate.client = this.delegate.client.newBuilder().hostnameVerifier(hostnameVerifier).build();
        }

        @Override
        public HostnameVerifier getHostnameVerifier() {
            return this.delegate.client.hostnameVerifier();
        }

        @Override
        public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
            if (sslSocketFactory == null) {
                throw new IllegalArgumentException("sslSocketFactory == null");
            }
            this.delegate.client = this.delegate.client.newBuilder().sslSocketFactory(sslSocketFactory).build();
        }

        @Override
        public SSLSocketFactory getSSLSocketFactory() {
            return this.delegate.client.sslSocketFactory();
        }
    }

    static abstract class DelegatingHttpsURLConnection
    extends HttpsURLConnection {
        private final HttpURLConnection delegate;

        DelegatingHttpsURLConnection(HttpURLConnection delegate) {
            super(delegate.getURL());
            this.delegate = delegate;
        }

        protected abstract Handshake handshake();

        @Override
        public abstract void setHostnameVerifier(HostnameVerifier var1);

        @Override
        public abstract HostnameVerifier getHostnameVerifier();

        @Override
        public abstract void setSSLSocketFactory(SSLSocketFactory var1);

        @Override
        public abstract SSLSocketFactory getSSLSocketFactory();

        @Override
        public String getCipherSuite() {
            Handshake handshake = this.handshake();
            return handshake != null ? handshake.cipherSuite().javaName() : null;
        }

        @Override
        public Certificate[] getLocalCertificates() {
            Handshake handshake = this.handshake();
            if (handshake == null) {
                return null;
            }
            List result = handshake.localCertificates();
            return !result.isEmpty() ? result.toArray(new Certificate[result.size()]) : null;
        }

        @Override
        public Certificate[] getServerCertificates() {
            Handshake handshake = this.handshake();
            if (handshake == null) {
                return null;
            }
            List result = handshake.peerCertificates();
            return !result.isEmpty() ? result.toArray(new Certificate[result.size()]) : null;
        }

        @Override
        public Principal getPeerPrincipal() {
            Handshake handshake = this.handshake();
            return handshake != null ? handshake.peerPrincipal() : null;
        }

        @Override
        public Principal getLocalPrincipal() {
            Handshake handshake = this.handshake();
            return handshake != null ? handshake.localPrincipal() : null;
        }

        @Override
        public void connect() throws IOException {
            this.connected = true;
            this.delegate.connect();
        }

        @Override
        public void disconnect() {
            this.delegate.disconnect();
        }

        @Override
        public InputStream getErrorStream() {
            return this.delegate.getErrorStream();
        }

        @Override
        public String getRequestMethod() {
            return this.delegate.getRequestMethod();
        }

        @Override
        public int getResponseCode() throws IOException {
            return this.delegate.getResponseCode();
        }

        @Override
        public String getResponseMessage() throws IOException {
            return this.delegate.getResponseMessage();
        }

        @Override
        public void setRequestMethod(String method) throws ProtocolException {
            this.delegate.setRequestMethod(method);
        }

        @Override
        public boolean usingProxy() {
            return this.delegate.usingProxy();
        }

        @Override
        public boolean getInstanceFollowRedirects() {
            return this.delegate.getInstanceFollowRedirects();
        }

        @Override
        public void setInstanceFollowRedirects(boolean followRedirects) {
            this.delegate.setInstanceFollowRedirects(followRedirects);
        }

        @Override
        public boolean getAllowUserInteraction() {
            return this.delegate.getAllowUserInteraction();
        }

        @Override
        public Object getContent() throws IOException {
            return this.delegate.getContent();
        }

        public Object getContent(Class[] types) throws IOException {
            return this.delegate.getContent(types);
        }

        @Override
        public String getContentEncoding() {
            return this.delegate.getContentEncoding();
        }

        @Override
        public int getContentLength() {
            return this.delegate.getContentLength();
        }

        @Override
        public long getContentLengthLong() {
            return this.delegate.getContentLengthLong();
        }

        @Override
        public String getContentType() {
            return this.delegate.getContentType();
        }

        @Override
        public long getDate() {
            return this.delegate.getDate();
        }

        @Override
        public boolean getDefaultUseCaches() {
            return this.delegate.getDefaultUseCaches();
        }

        @Override
        public boolean getDoInput() {
            return this.delegate.getDoInput();
        }

        @Override
        public boolean getDoOutput() {
            return this.delegate.getDoOutput();
        }

        @Override
        public long getExpiration() {
            return this.delegate.getExpiration();
        }

        @Override
        public String getHeaderField(int pos) {
            return this.delegate.getHeaderField(pos);
        }

        @Override
        public Map<String, List<String>> getHeaderFields() {
            return this.delegate.getHeaderFields();
        }

        @Override
        public Map<String, List<String>> getRequestProperties() {
            return this.delegate.getRequestProperties();
        }

        @Override
        public void addRequestProperty(String field, String newValue) {
            this.delegate.addRequestProperty(field, newValue);
        }

        @Override
        public String getHeaderField(String key) {
            return this.delegate.getHeaderField(key);
        }

        @Override
        public long getHeaderFieldLong(String field, long defaultValue) {
            return this.delegate.getHeaderFieldLong(field, defaultValue);
        }

        @Override
        public long getHeaderFieldDate(String field, long defaultValue) {
            return this.delegate.getHeaderFieldDate(field, defaultValue);
        }

        @Override
        public int getHeaderFieldInt(String field, int defaultValue) {
            return this.delegate.getHeaderFieldInt(field, defaultValue);
        }

        @Override
        public String getHeaderFieldKey(int position) {
            return this.delegate.getHeaderFieldKey(position);
        }

        @Override
        public long getIfModifiedSince() {
            return this.delegate.getIfModifiedSince();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.delegate.getInputStream();
        }

        @Override
        public long getLastModified() {
            return this.delegate.getLastModified();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.delegate.getOutputStream();
        }

        @Override
        public Permission getPermission() throws IOException {
            return this.delegate.getPermission();
        }

        @Override
        public String getRequestProperty(String field) {
            return this.delegate.getRequestProperty(field);
        }

        @Override
        public URL getURL() {
            return this.delegate.getURL();
        }

        @Override
        public boolean getUseCaches() {
            return this.delegate.getUseCaches();
        }

        @Override
        public void setAllowUserInteraction(boolean newValue) {
            this.delegate.setAllowUserInteraction(newValue);
        }

        @Override
        public void setDefaultUseCaches(boolean newValue) {
            this.delegate.setDefaultUseCaches(newValue);
        }

        @Override
        public void setDoInput(boolean newValue) {
            this.delegate.setDoInput(newValue);
        }

        @Override
        public void setDoOutput(boolean newValue) {
            this.delegate.setDoOutput(newValue);
        }

        @Override
        public void setFixedLengthStreamingMode(long contentLength) {
            this.delegate.setFixedLengthStreamingMode(contentLength);
        }

        @Override
        public void setIfModifiedSince(long newValue) {
            this.delegate.setIfModifiedSince(newValue);
        }

        @Override
        public void setRequestProperty(String field, String newValue) {
            this.delegate.setRequestProperty(field, newValue);
        }

        @Override
        public void setUseCaches(boolean newValue) {
            this.delegate.setUseCaches(newValue);
        }

        @Override
        public void setConnectTimeout(int timeoutMillis) {
            this.delegate.setConnectTimeout(timeoutMillis);
        }

        @Override
        public int getConnectTimeout() {
            return this.delegate.getConnectTimeout();
        }

        @Override
        public void setReadTimeout(int timeoutMillis) {
            this.delegate.setReadTimeout(timeoutMillis);
        }

        @Override
        public int getReadTimeout() {
            return this.delegate.getReadTimeout();
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void setFixedLengthStreamingMode(int contentLength) {
            this.delegate.setFixedLengthStreamingMode(contentLength);
        }

        @Override
        public void setChunkedStreamingMode(int chunkLength) {
            this.delegate.setChunkedStreamingMode(chunkLength);
        }
    }

    static final class StreamedRequestBody
    extends OutputStreamRequestBody {
        private final Pipe pipe = new Pipe(8192L);

        StreamedRequestBody(long expectedContentLength) {
            this.initOutputStream(Okio.buffer((Sink)this.pipe.sink()), expectedContentLength);
        }

        public boolean isOneShot() {
            return true;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            Buffer buffer = new Buffer();
            while (this.pipe.source().read(buffer, 8192L) != -1L) {
                sink.write(buffer, buffer.size());
            }
        }
    }

    static final class BufferedRequestBody
    extends OutputStreamRequestBody {
        final Buffer buffer = new Buffer();
        long contentLength = -1L;

        BufferedRequestBody(long expectedContentLength) {
            this.initOutputStream((BufferedSink)this.buffer, expectedContentLength);
        }

        @Override
        public long contentLength() {
            return this.contentLength;
        }

        @Override
        public Request prepareToSendRequest(Request request) throws IOException {
            if (request.header("Content-Length") != null) {
                return request;
            }
            this.outputStream.close();
            this.contentLength = this.buffer.size();
            return request.newBuilder().removeHeader("Transfer-Encoding").header("Content-Length", Long.toString(this.buffer.size())).build();
        }

        public void writeTo(BufferedSink sink) {
            this.buffer.copyTo(sink.buffer(), 0L, this.buffer.size());
        }
    }

    static abstract class OutputStreamRequestBody
    extends RequestBody {
        Timeout timeout;
        long expectedContentLength;
        OutputStream outputStream;
        boolean closed;

        OutputStreamRequestBody() {
        }

        void initOutputStream(final BufferedSink sink, final long expectedContentLength) {
            this.timeout = sink.timeout();
            this.expectedContentLength = expectedContentLength;
            this.outputStream = new OutputStream(){
                private long bytesReceived;

                @Override
                public void write(int b) throws IOException {
                    this.write(new byte[]{(byte)b}, 0, 1);
                }

                @Override
                public void write(byte[] source, int offset, int byteCount) throws IOException {
                    if (closed) {
                        throw new IOException("closed");
                    }
                    if (expectedContentLength != -1L && this.bytesReceived + (long)byteCount > expectedContentLength) {
                        throw new ProtocolException("expected " + expectedContentLength + " bytes but received " + this.bytesReceived + byteCount);
                    }
                    this.bytesReceived += (long)byteCount;
                    try {
                        sink.write(source, offset, byteCount);
                    }
                    catch (InterruptedIOException e) {
                        throw new SocketTimeoutException(e.getMessage());
                    }
                }

                @Override
                public void flush() throws IOException {
                    if (closed) {
                        return;
                    }
                    sink.flush();
                }

                @Override
                public void close() throws IOException {
                    closed = true;
                    if (expectedContentLength != -1L && this.bytesReceived < expectedContentLength) {
                        throw new ProtocolException("expected " + expectedContentLength + " bytes but received " + this.bytesReceived);
                    }
                    sink.close();
                }
            };
        }

        public long contentLength() {
            return this.expectedContentLength;
        }

        @Nullable
        public final MediaType contentType() {
            return null;
        }

        public Request prepareToSendRequest(Request request) throws IOException {
            return request;
        }
    }

    static final class OkHttpURLConnection
    extends HttpURLConnection
    implements Callback {
        OkHttpClient client;
        final NetworkInterceptor networkInterceptor = new NetworkInterceptor();
        Headers.Builder requestHeaders = new Headers.Builder();
        Headers responseHeaders;
        boolean executed;
        Call call;
        long fixedContentLength = -1L;
        private final Object lock = new Object();
        private Response response;
        private Throwable callFailure;
        Response networkResponse;
        boolean connectPending = true;
        Proxy proxy;
        Handshake handshake;

        OkHttpURLConnection(URL url, OkHttpClient client) {
            super(url);
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connect() throws IOException {
            if (this.executed) {
                return;
            }
            Call call = this.buildCall();
            this.executed = true;
            call.enqueue((Callback)this);
            Object object = this.lock;
            synchronized (object) {
                try {
                    while (this.connectPending && this.response == null && this.callFailure == null) {
                        this.lock.wait();
                    }
                    if (this.callFailure != null) {
                        throw ObsoleteUrlFactory.propagate(this.callFailure);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
        }

        @Override
        public void disconnect() {
            if (this.call == null) {
                return;
            }
            this.networkInterceptor.proceed();
            this.call.cancel();
        }

        @Override
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="hasBody checks for this")
        public InputStream getErrorStream() {
            try {
                Response response = this.getResponse(true);
                if (ObsoleteUrlFactory.hasBody(response) && response.code() >= 400) {
                    return new ResponseBodyInputStream(response.body());
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }

        Headers getHeaders() throws IOException {
            if (this.responseHeaders == null) {
                Response response = this.getResponse(true);
                Headers headers = response.headers();
                this.responseHeaders = headers.newBuilder().add(ObsoleteUrlFactory.SELECTED_PROTOCOL, response.protocol().toString()).add(ObsoleteUrlFactory.RESPONSE_SOURCE, ObsoleteUrlFactory.responseSourceHeader(response)).build();
            }
            return this.responseHeaders;
        }

        @Override
        public String getHeaderField(int position) {
            try {
                Headers headers = this.getHeaders();
                if (position < 0 || position >= headers.size()) {
                    return null;
                }
                return headers.value(position);
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public String getHeaderField(String fieldName) {
            try {
                return fieldName == null ? ObsoleteUrlFactory.statusLineToString(this.getResponse(true)) : this.getHeaders().get(fieldName);
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public String getHeaderFieldKey(int position) {
            try {
                Headers headers = this.getHeaders();
                if (position < 0 || position >= headers.size()) {
                    return null;
                }
                return headers.name(position);
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public Map<String, List<String>> getHeaderFields() {
            try {
                return ObsoleteUrlFactory.toMultimap(this.getHeaders(), ObsoleteUrlFactory.statusLineToString(this.getResponse(true)));
            }
            catch (IOException e) {
                return Collections.emptyMap();
            }
        }

        @Override
        public Map<String, List<String>> getRequestProperties() {
            if (this.connected) {
                throw new IllegalStateException("Cannot access request header fields after connection is set");
            }
            return ObsoleteUrlFactory.toMultimap(this.requestHeaders.build(), null);
        }

        @Override
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Good request will have body")
        public InputStream getInputStream() throws IOException {
            if (!this.doInput) {
                throw new ProtocolException("This protocol does not support input");
            }
            Response response = this.getResponse(false);
            if (response.code() >= 400) {
                throw new FileNotFoundException(this.url.toString());
            }
            return new ResponseBodyInputStream(response.body());
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            OutputStreamRequestBody requestBody = (OutputStreamRequestBody)this.buildCall().request().body();
            if (requestBody == null) {
                throw new ProtocolException("method does not support a request body: " + this.method);
            }
            if (requestBody instanceof StreamedRequestBody) {
                this.connect();
                this.networkInterceptor.proceed();
            }
            if (requestBody.closed) {
                throw new ProtocolException("cannot write request body after response has been read");
            }
            return requestBody.outputStream;
        }

        @Override
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="usingProxy() handles this")
        public Permission getPermission() {
            int hostPort;
            URL url = this.getURL();
            String hostname = url.getHost();
            int n = hostPort = url.getPort() != -1 ? url.getPort() : HttpUrl.defaultPort((String)url.getProtocol());
            if (this.usingProxy()) {
                InetSocketAddress proxyAddress = (InetSocketAddress)this.client.proxy().address();
                hostname = proxyAddress.getHostName();
                hostPort = proxyAddress.getPort();
            }
            return new SocketPermission(hostname + ":" + hostPort, "connect, resolve");
        }

        @Override
        public String getRequestProperty(String field) {
            if (field == null) {
                return null;
            }
            return this.requestHeaders.get(field);
        }

        @Override
        public void setConnectTimeout(int timeoutMillis) {
            this.client = this.client.newBuilder().connectTimeout((long)timeoutMillis, TimeUnit.MILLISECONDS).build();
        }

        @Override
        public void setInstanceFollowRedirects(boolean followRedirects) {
            this.client = this.client.newBuilder().followRedirects(followRedirects).build();
        }

        @Override
        public boolean getInstanceFollowRedirects() {
            return this.client.followRedirects();
        }

        @Override
        public int getConnectTimeout() {
            return this.client.connectTimeoutMillis();
        }

        @Override
        public void setReadTimeout(int timeoutMillis) {
            this.client = this.client.newBuilder().readTimeout((long)timeoutMillis, TimeUnit.MILLISECONDS).build();
        }

        @Override
        public int getReadTimeout() {
            return this.client.readTimeoutMillis();
        }

        @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
        private Call buildCall() throws IOException {
            HttpUrl url;
            if (this.call != null) {
                return this.call;
            }
            this.connected = true;
            if (this.doOutput) {
                if (this.method.equals("GET")) {
                    this.method = "POST";
                } else if (!ObsoleteUrlFactory.permitsRequestBody(this.method)) {
                    throw new ProtocolException(this.method + " does not support writing");
                }
            }
            if (this.requestHeaders.get("User-Agent") == null) {
                this.requestHeaders.add("User-Agent", ObsoleteUrlFactory.defaultUserAgent());
            }
            OutputStreamRequestBody requestBody = null;
            if (ObsoleteUrlFactory.permitsRequestBody(this.method)) {
                String contentType = this.requestHeaders.get("Content-Type");
                if (contentType == null) {
                    contentType = "application/x-www-form-urlencoded";
                    this.requestHeaders.add("Content-Type", contentType);
                }
                boolean stream = this.fixedContentLength != -1L || this.chunkLength > 0;
                long contentLength = -1L;
                String contentLengthString = this.requestHeaders.get("Content-Length");
                if (this.fixedContentLength != -1L) {
                    contentLength = this.fixedContentLength;
                } else if (contentLengthString != null) {
                    contentLength = Long.parseLong(contentLengthString);
                }
                requestBody = stream ? new StreamedRequestBody(contentLength) : new BufferedRequestBody(contentLength);
                requestBody.timeout.timeout((long)this.client.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
            }
            try {
                url = HttpUrl.get((String)this.getURL().toString());
            }
            catch (IllegalArgumentException e) {
                MalformedURLException malformedUrl = new MalformedURLException();
                malformedUrl.initCause(e);
                throw malformedUrl;
            }
            Request request = new Request.Builder().url(url).headers(this.requestHeaders.build()).method(this.method, requestBody).build();
            OkHttpClient.Builder clientBuilder = this.client.newBuilder();
            clientBuilder.interceptors().clear();
            clientBuilder.interceptors().add(UnexpectedException.INTERCEPTOR);
            clientBuilder.networkInterceptors().clear();
            clientBuilder.networkInterceptors().add(this.networkInterceptor);
            clientBuilder.dispatcher(new Dispatcher(this.client.dispatcher().executorService()));
            if (!this.getUseCaches()) {
                clientBuilder.cache(null);
            }
            this.call = clientBuilder.build().newCall(request);
            return this.call;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Response getResponse(boolean networkResponseOnError) throws IOException {
            Object object;
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.response != null) {
                    return this.response;
                }
                if (this.callFailure != null) {
                    if (networkResponseOnError && this.networkResponse != null) {
                        return this.networkResponse;
                    }
                    throw ObsoleteUrlFactory.propagate(this.callFailure);
                }
            }
            Call call = this.buildCall();
            this.networkInterceptor.proceed();
            OutputStreamRequestBody requestBody = (OutputStreamRequestBody)call.request().body();
            if (requestBody != null) {
                requestBody.outputStream.close();
            }
            if (this.executed) {
                object = this.lock;
                synchronized (object) {
                    try {
                        while (this.response == null && this.callFailure == null) {
                            this.lock.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                }
            }
            this.executed = true;
            try {
                this.onResponse(call, call.execute());
            }
            catch (IOException e) {
                this.onFailure(call, e);
            }
            object = this.lock;
            synchronized (object) {
                if (this.callFailure != null) {
                    throw ObsoleteUrlFactory.propagate(this.callFailure);
                }
                if (this.response != null) {
                    return this.response;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean usingProxy() {
            if (this.proxy != null) {
                return true;
            }
            Proxy clientProxy = this.client.proxy();
            return clientProxy != null && clientProxy.type() != Proxy.Type.DIRECT;
        }

        @Override
        public String getResponseMessage() throws IOException {
            return this.getResponse(true).message();
        }

        @Override
        public int getResponseCode() throws IOException {
            return this.getResponse(true).code();
        }

        @Override
        public void setRequestProperty(String field, String newValue) {
            if (this.connected) {
                throw new IllegalStateException("Cannot set request property after connection is made");
            }
            if (field == null) {
                throw new NullPointerException("field == null");
            }
            if (newValue == null) {
                return;
            }
            this.requestHeaders.set(field, newValue);
        }

        @Override
        public void setIfModifiedSince(long newValue) {
            super.setIfModifiedSince(newValue);
            if (this.ifModifiedSince != 0L) {
                this.requestHeaders.set("If-Modified-Since", ObsoleteUrlFactory.format(new Date(this.ifModifiedSince)));
            } else {
                this.requestHeaders.removeAll("If-Modified-Since");
            }
        }

        @Override
        public void addRequestProperty(String field, String value) {
            if (this.connected) {
                throw new IllegalStateException("Cannot add request property after connection is made");
            }
            if (field == null) {
                throw new NullPointerException("field == null");
            }
            if (value == null) {
                return;
            }
            this.requestHeaders.add(field, value);
        }

        @Override
        public void setRequestMethod(String method) throws ProtocolException {
            if (!METHODS.contains(method)) {
                throw new ProtocolException("Expected one of " + METHODS + " but was " + method);
            }
            this.method = method;
        }

        @Override
        public void setFixedLengthStreamingMode(int contentLength) {
            this.setFixedLengthStreamingMode((long)contentLength);
        }

        @Override
        public void setFixedLengthStreamingMode(long contentLength) {
            if (this.connected) {
                throw new IllegalStateException("Already connected");
            }
            if (this.chunkLength > 0) {
                throw new IllegalStateException("Already in chunked mode");
            }
            if (contentLength < 0L) {
                throw new IllegalArgumentException("contentLength < 0");
            }
            this.fixedContentLength = contentLength;
            ((HttpURLConnection)this).fixedContentLength = (int)Math.min(contentLength, Integer.MAX_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(Call call, IOException e) {
            Object object = this.lock;
            synchronized (object) {
                this.callFailure = e instanceof UnexpectedException ? e.getCause() : e;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(Call call, Response response) {
            Object object = this.lock;
            synchronized (object) {
                this.response = response;
                this.handshake = response.handshake();
                this.url = response.request().url().url();
                this.lock.notifyAll();
            }
        }

        final class NetworkInterceptor
        implements Interceptor {
            private boolean proceed;

            NetworkInterceptor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void proceed() {
                Object object = OkHttpURLConnection.this.lock;
                synchronized (object) {
                    this.proceed = true;
                    OkHttpURLConnection.this.lock.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="If we get here there is a connection and request.body() is checked")
            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Object object = OkHttpURLConnection.this.lock;
                synchronized (object) {
                    OkHttpURLConnection.this.connectPending = false;
                    OkHttpURLConnection.this.proxy = chain.connection().route().proxy();
                    OkHttpURLConnection.this.handshake = chain.connection().handshake();
                    OkHttpURLConnection.this.lock.notifyAll();
                    try {
                        while (!this.proceed) {
                            OkHttpURLConnection.this.lock.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                }
                if (request.body() instanceof OutputStreamRequestBody) {
                    OutputStreamRequestBody requestBody = (OutputStreamRequestBody)request.body();
                    request = requestBody.prepareToSendRequest(request);
                }
                Response response = chain.proceed(request);
                Object object2 = OkHttpURLConnection.this.lock;
                synchronized (object2) {
                    OkHttpURLConnection.this.networkResponse = response;
                    OkHttpURLConnection.this.url = response.request().url().url();
                }
                return response;
            }
        }
    }
}

