/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.forms;

import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.List;
import java.util.function.Consumer;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormActionFactory;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.authentication.actiontoken.inviteorg.InviteOrgActionToken;
import org.keycloak.common.Profile;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.utils.Organizations;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.validation.Validation;
import org.keycloak.userprofile.Attributes;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.ValidationException;

public class RegistrationUserCreation
implements FormAction,
FormActionFactory {
    public static final String PROVIDER_ID = "registration-user-creation";
    private static AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};

    public String getHelpText() {
        return "This action must always be first! Validates the username and user profile of the user in validation phase.  In success phase, this will create the user in the database including his user profile.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public void validate(ValidationContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        context.getEvent().detail("register_method", "form");
        UserProfile profile = this.getOrCreateUserProfile((FormContext)context, (MultivaluedMap<String, String>)formData);
        Attributes attributes = profile.getAttributes();
        String email = attributes.getFirst("email");
        if (!this.validateOrganizationInvitation(context, (MultivaluedMap<String, String>)formData, email)) {
            return;
        }
        String username = attributes.getFirst("username");
        String firstName = attributes.getFirst("firstName");
        String lastName = attributes.getFirst("lastName");
        context.getEvent().detail("email", email);
        context.getEvent().detail("username", username);
        context.getEvent().detail("first_name", firstName);
        context.getEvent().detail("last_name", lastName);
        if (context.getRealm().isRegistrationEmailAsUsername()) {
            context.getEvent().detail("username", email);
        }
        try {
            profile.validate();
        }
        catch (ValidationException pve) {
            List<FormMessage> errors = Validation.getFormErrorsFromValidation(pve.getErrors());
            if (pve.hasError(new String[]{"emailExistsMessage", "invalidEmailMessage"})) {
                context.getEvent().detail("email", attributes.getFirst("email"));
            }
            if (pve.hasError(new String[]{"emailExistsMessage"})) {
                context.error("email_in_use");
            } else if (pve.hasError(new String[]{"usernameExistsMessage"})) {
                context.error("username_in_use");
            } else {
                context.error("invalid_registration");
            }
            context.validationError(formData, errors);
            return;
        }
        context.success();
    }

    public void buildPage(FormContext context, LoginFormsProvider form) {
        this.checkNotOtherUserAuthenticating(context);
    }

    public void success(FormContext context) {
        RequiredActionProviderModel tacModel;
        this.checkNotOtherUserAuthenticating(context);
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String email = (String)formData.getFirst((Object)"email");
        String username = (String)formData.getFirst((Object)"username");
        if (context.getRealm().isRegistrationEmailAsUsername()) {
            username = email;
        }
        context.getEvent().detail("username", username).detail("register_method", "form").detail("email", email);
        UserProfile profile = this.getOrCreateUserProfile(context, (MultivaluedMap<String, String>)formData);
        UserModel user = profile.create();
        this.addOrganizationMember(context, user);
        user.setEnabled(true);
        if ("on".equals(formData.getFirst((Object)"termsAccepted")) && (tacModel = context.getRealm().getRequiredActionProviderByAlias(UserModel.RequiredAction.TERMS_AND_CONDITIONS.name())) != null && tacModel.isEnabled()) {
            user.setSingleAttribute("terms_and_conditions", Integer.toString(Time.currentTime()));
            context.getAuthenticationSession().removeRequiredAction(UserModel.RequiredAction.TERMS_AND_CONDITIONS);
            user.removeRequiredAction(UserModel.RequiredAction.TERMS_AND_CONDITIONS);
        }
        context.setUser(user);
        context.getAuthenticationSession().setClientNote("login_hint", username);
        context.getEvent().user(user);
        context.getEvent().success();
        context.newEvent().event(EventType.LOGIN);
        context.getEvent().client(context.getAuthenticationSession().getClient().getClientId()).detail("redirect_uri", context.getAuthenticationSession().getRedirectUri()).detail("auth_method", context.getAuthenticationSession().getProtocol());
        String authType = context.getAuthenticationSession().getAuthNote("auth_type");
        if (authType != null) {
            context.getEvent().detail("auth_type", authType);
        }
    }

    private void checkNotOtherUserAuthenticating(FormContext context) {
        if (context.getUser() != null) {
            context.getEvent().detail("previous_user", context.getUser().getUsername());
            throw new AuthenticationFlowException(AuthenticationFlowError.GENERIC_AUTHENTICATION_ERROR, "different_user_authenticating", "expiredActionMessage");
        }
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public void close() {
    }

    public String getDisplayType() {
        return "Registration User Profile Creation";
    }

    public String getReferenceCategory() {
        return null;
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public FormAction create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    private MultivaluedMap<String, String> normalizeFormParameters(MultivaluedMap<String, String> formParams) {
        MultivaluedHashMap copy = new MultivaluedHashMap(formParams);
        copy.remove((Object)"g-recaptcha-response");
        copy.remove((Object)"password");
        copy.remove((Object)"password-confirm");
        return copy;
    }

    public UserProfile getOrCreateUserProfile(FormContext formContext, MultivaluedMap<String, String> formData) {
        KeycloakSession session = formContext.getSession();
        UserProfile profile = (UserProfile)session.getAttribute("UP_REGISTER");
        if (profile == null) {
            formData = this.normalizeFormParameters(formData);
            UserProfileProvider profileProvider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
            profile = profileProvider.create(UserProfileContext.REGISTRATION, formData);
            session.setAttribute("UP_REGISTER", (Object)profile);
        }
        return profile;
    }

    private boolean validateOrganizationInvitation(ValidationContext context, MultivaluedMap<String, String> formData, String email) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION)) {
            InviteOrgActionToken token;
            Consumer<List> error = messages -> {
                context.error("invalid_token");
                context.validationError(formData, messages);
            };
            try {
                token = Organizations.parseInvitationToken(context.getHttpRequest());
            }
            catch (VerificationException e) {
                error.accept(List.of(new FormMessage("Unexpected error parsing the invitation token", new Object[0])));
                return false;
            }
            if (token == null) {
                return true;
            }
            KeycloakSession session = context.getSession();
            OrganizationProvider provider = (OrganizationProvider)session.getProvider(OrganizationProvider.class);
            OrganizationModel organization = provider.getById(token.getOrgId());
            if (organization == null) {
                error.accept(List.of(new FormMessage("The provided token contains an invalid organization id", new Object[0])));
                return false;
            }
            session.getContext().setOrganization(organization);
            session.setAttribute(InviteOrgActionToken.class.getName(), (Object)token);
            if (token.isExpired() || !token.getActionId().equals("ORGIVT")) {
                error.accept(List.of(new FormMessage("The provided token is not valid or has expired.", new Object[0])));
                return false;
            }
            if (!token.getEmail().equals(email)) {
                error.accept(List.of(new FormMessage("email", "Email does not match the invitation")));
                return false;
            }
        }
        return true;
    }

    private void addOrganizationMember(FormContext context, UserModel user) {
        InviteOrgActionToken token;
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION) && (token = (InviteOrgActionToken)((Object)context.getSession().getAttribute(InviteOrgActionToken.class.getName()))) != null) {
            KeycloakSession session = context.getSession();
            OrganizationProvider provider = (OrganizationProvider)session.getProvider(OrganizationProvider.class);
            OrganizationModel orgModel = provider.getById(token.getOrgId());
            provider.addManagedMember(orgModel, user);
            context.getEvent().detail("org_id", orgModel.getId());
            context.getAuthenticationSession().setRedirectUri(token.getRedirectUri());
        }
    }
}

