/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.jaxws;

import com.sun.tools.ws.WsGen;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.jvnet.jax_ws_commons.jaxws.AbstractJaxwsMojo;

abstract class AbstractWsGenMojo
extends AbstractJaxwsMojo {
    protected boolean genWsdl;
    private String sei;
    private String protocol;
    private List<Artifact> pluginArtifacts;
    private String servicename;
    private String portname;
    private boolean inlineSchemas;
    private boolean xnocompile;
    private boolean xdonotoverwrite;

    AbstractWsGenMojo() {
    }

    protected abstract File getResourceDestDir();

    protected abstract File getClassesDir();

    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        String orginalSystemClasspath = this.initClassLoader(parent);
        HashSet<String> seis = new HashSet<String>();
        if (this.sei != null) {
            seis.add(this.sei);
        } else {
            seis.addAll(this.getSEIs(this.getClassesDir()));
        }
        if (seis.isEmpty()) {
            throw new MojoFailureException("No @javax.jws.WebService found.");
        }
        try {
            for (String aSei : seis) {
                ArrayList<String> args = this.getWsGenArgs(aSei);
                if (WsGen.doMain((String[])args.toArray(new String[args.size()])) == 0) continue;
                throw new MojoExecutionException("Error executing: wsgen " + args);
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new MojoExecutionException("Failed to execute wsgen", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(parent);
            System.setProperty("java.class.path", orginalSystemClasspath);
        }
    }

    private ArrayList<String> getWsGenArgs(String aSei) throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.getCommonArgs());
        args.add("-cp");
        StringBuilder buf = new StringBuilder();
        buf.append(this.getDestDir().getAbsolutePath());
        for (Artifact a : this.project.getArtifacts()) {
            buf.append(File.pathSeparatorChar);
            buf.append(a.getFile().getAbsolutePath());
        }
        for (Artifact a : this.pluginArtifacts) {
            buf.append(File.pathSeparatorChar);
            buf.append(a.getFile().getAbsolutePath());
        }
        args.add(buf.toString());
        if (this.genWsdl) {
            if (this.protocol != null) {
                args.add("-wsdl:" + this.protocol);
            } else {
                args.add("-wsdl");
            }
            if (this.inlineSchemas) {
                args.add("-inlineSchemas");
            }
            if (this.servicename != null) {
                args.add("-servicename");
                args.add(this.servicename);
            }
            if (this.portname != null) {
                args.add("-portname");
                args.add(this.portname);
            }
            File resourceDir = this.getResourceDestDir();
            resourceDir.mkdirs();
            args.add("-r");
            args.add(resourceDir.getAbsolutePath());
            Resource r = new Resource();
            r.setDirectory(this.getRelativePath(this.project.getBasedir(), this.getResourceDestDir()));
            this.project.addResource(r);
        }
        if (this.xdonotoverwrite) {
            args.add("-Xdonotoverwrite");
        }
        args.add(aSei);
        this.getLog().debug((CharSequence)("jaxws:wsgen args: " + args));
        return args;
    }

    private String getRelativePath(File root, File f) {
        return root.toURI().relativize(f.toURI()).getPath();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<String> getSEIs(File directory) throws MojoExecutionException {
        HashSet<String> seis = new HashSet<String>();
        if (!directory.exists() || directory.isFile()) {
            return seis;
        }
        URLClassLoader cl = null;
        try {
            cl = new URLClassLoader(new URL[]{directory.toURI().toURL()});
            for (String s : FileUtils.getFileAndDirectoryNames((File)directory, (String)"**/*.class", null, (boolean)false, (boolean)true, (boolean)true, (boolean)false)) {
                try {
                    String clsName = s.replace(File.separator, ".");
                    Class<?> c = cl.loadClass(clsName.substring(0, clsName.length() - 6));
                    WebService ann = c.getAnnotation(WebService.class);
                    if (c.isInterface() || ann == null) continue;
                    seis.add(c.getName());
                }
                catch (ClassNotFoundException ex) {
                    throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
                    return seis;
                }
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        finally {
            if (cl != null && cl instanceof Closeable) {
                try {
                    ((Closeable)cl).close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

