/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.reflection.resolver.argument;

import com.google.common.base.Optional;
import java.util.Collection;
import org.jtwig.reflection.model.Value;
import org.jtwig.reflection.model.java.JavaMethodArgument;
import org.jtwig.reflection.resolver.argument.ArgumentResolver;

public class CompositeArgumentResolver
implements ArgumentResolver {
    private final Collection<ArgumentResolver> argumentResolvers;

    public CompositeArgumentResolver(Collection<ArgumentResolver> argumentResolvers) {
        this.argumentResolvers = argumentResolvers;
    }

    @Override
    public Optional<Value> resolve(JavaMethodArgument methodArgument) {
        for (ArgumentResolver argumentResolver : this.argumentResolvers) {
            Optional<Value> resolve = argumentResolver.resolve(methodArgument);
            if (!resolve.isPresent()) continue;
            return resolve;
        }
        return Optional.absent();
    }
}

