/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.reflection.model.java;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jtwig.reflection.model.java.JavaConstant;
import org.jtwig.reflection.model.java.JavaField;
import org.jtwig.reflection.model.java.JavaMethods;

public class JavaClass {
    private final Class nativeType;
    private final Map<String, JavaConstant> constants;
    private final Map<String, JavaField> fields;
    private final Map<String, JavaMethods> methodsByName;

    public JavaClass(Class nativeType, Map<String, JavaConstant> constants, Map<String, JavaField> fields, Map<String, JavaMethods> methodsByName) {
        this.nativeType = nativeType;
        this.constants = constants;
        this.fields = fields;
        this.methodsByName = methodsByName;
    }

    public Optional<JavaConstant> constant(String name) {
        return Optional.fromNullable((Object)this.constants.get(name));
    }

    public Collection<JavaConstant> constants() {
        return this.constants.values();
    }

    public Optional<JavaField> field(String name) {
        return Optional.fromNullable((Object)this.fields.get(name));
    }

    public Collection<JavaField> fields() {
        return this.fields.values();
    }

    public JavaMethods method(String name) {
        return (JavaMethods)Optional.fromNullable((Object)this.methodsByName.get(name)).or((Object)new JavaMethods(Collections.emptyMap()));
    }

    public void merge(JavaClass origin) {
        for (Map.Entry<String, JavaMethods> entry : origin.methodsByName.entrySet()) {
            if (this.methodsByName.containsKey(entry.getKey())) {
                this.methodsByName.get(entry.getKey()).merge(origin.methodsByName.get(entry.getKey()));
                continue;
            }
            this.methodsByName.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : origin.fields.entrySet()) {
            if (this.fields.containsKey(entry.getKey())) continue;
            this.fields.put(entry.getKey(), (JavaField)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.constants.entrySet()) {
            if (this.constants.containsKey(entry.getKey())) continue;
            this.constants.put(entry.getKey(), (JavaConstant)entry.getValue());
        }
    }

    public Class getNative() {
        return this.nativeType;
    }
}

