/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.util;

import java.io.PrintWriter;
import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Attribute;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.org.objectweb.asm.FieldVisitor;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.ModuleVisitor;
import org.jruby.org.objectweb.asm.TypePath;
import org.jruby.org.objectweb.asm.util.Printer;
import org.jruby.org.objectweb.asm.util.Textifier;
import org.jruby.org.objectweb.asm.util.TraceAnnotationVisitor;
import org.jruby.org.objectweb.asm.util.TraceFieldVisitor;
import org.jruby.org.objectweb.asm.util.TraceMethodVisitor;
import org.jruby.org.objectweb.asm.util.TraceModuleVisitor;

public final class TraceClassVisitor
extends ClassVisitor {
    private final PrintWriter pw;
    public final Printer p;

    public TraceClassVisitor(PrintWriter pw) {
        this(null, pw);
    }

    public TraceClassVisitor(ClassVisitor cv, PrintWriter pw) {
        this(cv, new Textifier(), pw);
    }

    public TraceClassVisitor(ClassVisitor cv, Printer p2, PrintWriter pw) {
        super(393216, cv);
        this.pw = pw;
        this.p = p2;
    }

    public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces2) {
        this.p.visit(version, access, name2, signature, superName, interfaces2);
        super.visit(version, access, name2, signature, superName, interfaces2);
    }

    public void visitSource(String file2, String debug) {
        this.p.visitSource(file2, debug);
        super.visitSource(file2, debug);
    }

    public ModuleVisitor visitModule(String name2, int flags2, String version) {
        Printer p2 = this.p.visitModule(name2, flags2, version);
        ModuleVisitor mv = super.visitModule(name2, flags2, version);
        return new TraceModuleVisitor(mv, p2);
    }

    public void visitOuterClass(String owner2, String name2, String desc) {
        this.p.visitOuterClass(owner2, name2, desc);
        super.visitOuterClass(owner2, name2, desc);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        Printer p2 = this.p.visitClassAnnotation(desc, visible);
        AnnotationVisitor av = this.cv == null ? null : this.cv.visitAnnotation(desc, visible);
        return new TraceAnnotationVisitor(av, p2);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        Printer p2 = this.p.visitClassTypeAnnotation(typeRef, typePath, desc, visible);
        AnnotationVisitor av = this.cv == null ? null : this.cv.visitTypeAnnotation(typeRef, typePath, desc, visible);
        return new TraceAnnotationVisitor(av, p2);
    }

    public void visitAttribute(Attribute attr2) {
        this.p.visitClassAttribute(attr2);
        super.visitAttribute(attr2);
    }

    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        this.p.visitInnerClass(name2, outerName, innerName, access);
        super.visitInnerClass(name2, outerName, innerName, access);
    }

    public FieldVisitor visitField(int access, String name2, String desc, String signature, Object value2) {
        Printer p2 = this.p.visitField(access, name2, desc, signature, value2);
        FieldVisitor fv = this.cv == null ? null : this.cv.visitField(access, name2, desc, signature, value2);
        return new TraceFieldVisitor(fv, p2);
    }

    public MethodVisitor visitMethod(int access, String name2, String desc, String signature, String[] exceptions) {
        Printer p2 = this.p.visitMethod(access, name2, desc, signature, exceptions);
        MethodVisitor mv = this.cv == null ? null : this.cv.visitMethod(access, name2, desc, signature, exceptions);
        return new TraceMethodVisitor(mv, p2);
    }

    public void visitEnd() {
        this.p.visitClassEnd();
        if (this.pw != null) {
            this.p.print(this.pw);
            this.pw.flush();
        }
        super.visitEnd();
    }
}

