/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class UnsyncByteArrayInputStream
extends InputStream {
    protected byte[] myBuffer;
    private int myPosition;
    private int myCount;
    private int myMarkedPosition;

    public UnsyncByteArrayInputStream(@NotNull byte[] buf) {
        if (buf == null) {
            UnsyncByteArrayInputStream.$$$reportNull$$$0(0);
        }
        this(buf, 0, buf.length);
    }

    public UnsyncByteArrayInputStream(@NotNull byte[] buf, int offset2, int length) {
        if (buf == null) {
            UnsyncByteArrayInputStream.$$$reportNull$$$0(1);
        }
        this.init(buf, offset2, length);
    }

    public void init(@NotNull byte[] buf, int offset2, int length) {
        if (buf == null) {
            UnsyncByteArrayInputStream.$$$reportNull$$$0(2);
        }
        this.myBuffer = buf;
        this.myPosition = offset2;
        this.myCount = length;
    }

    public int read() {
        return this.myPosition < this.myCount ? this.myBuffer[this.myPosition++] & 0xFF : -1;
    }

    public int read(@NotNull byte[] b, int off, int len) {
        if (b == null) {
            UnsyncByteArrayInputStream.$$$reportNull$$$0(3);
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.myPosition >= this.myCount) {
            return -1;
        }
        if (this.myPosition + len > this.myCount) {
            len = this.myCount - this.myPosition;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.myBuffer, this.myPosition, b, off, len);
        this.myPosition += len;
        return len;
    }

    public long skip(long n) {
        if ((long)this.myPosition + n > (long)this.myCount) {
            n = this.myCount - this.myPosition;
        }
        if (n < 0L) {
            return 0L;
        }
        this.myPosition = (int)((long)this.myPosition + n);
        return n;
    }

    public int available() {
        return this.myCount - this.myPosition;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readLimit) {
        this.myMarkedPosition = this.myPosition;
    }

    public void reset() {
        this.myPosition = this.myMarkedPosition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/UnsyncByteArrayInputStream";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

