/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AsyncAfterSynchronization;
import com.arjuna.ats.arjuna.coordinator.AsyncBeforeSynchronization;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.HeuristicNotification;
import com.arjuna.ats.arjuna.coordinator.Reapable;
import com.arjuna.ats.arjuna.coordinator.SynchronizationRecord;
import com.arjuna.ats.arjuna.coordinator.TwoPhaseCommitThreadPool;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.logging.tsLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TwoPhaseCoordinator
extends BasicAction
implements Reapable {
    private SortedSet<SynchronizationRecord> _synchs;
    private List<Future<Boolean>> runningSynchronizations = null;
    private CompletionService<Boolean> synchronizationCompletionService = null;
    private boolean executingInterposedSynchs = false;
    private SynchronizationRecord _currentRecord;
    private Throwable _deferredThrowable;
    private Lock _syncLock = new ReentrantLock();
    private boolean _beforeCalled = false;
    private boolean _afterCalled = false;

    public TwoPhaseCoordinator() {
    }

    public TwoPhaseCoordinator(Uid id) {
        super(id);
    }

    public int start() {
        return this.start(BasicAction.Current());
    }

    public int start(BasicAction parentAction) {
        if (parentAction != null && this.typeOfAction() == 1) {
            parentAction.addChildAction(this);
        }
        return super.Begin(parentAction);
    }

    public int end(boolean report_heuristics) {
        if (this.parent() != null) {
            this.parent().removeChildAction(this);
        }
        boolean canEnd = true;
        if (this.status() != 3 || TxControl.isBeforeCompletionWhenRollbackOnly()) {
            canEnd = this.beforeCompletion();
        }
        int outcome = canEnd ? super.End(report_heuristics) : super.Abort();
        this.afterCompletion(outcome, report_heuristics);
        return outcome;
    }

    @Override
    public int cancel() {
        int outcome;
        if (this.parent() != null) {
            this.parent().removeChildAction(this);
        }
        if ((outcome = super.Abort(true)) == 4) {
            this.afterCompletion(outcome);
        }
        return outcome;
    }

    public int addSynchronization(SynchronizationRecord sr) {
        if (sr == null) {
            return 3;
        }
        int result = 3;
        if (this.parent() != null) {
            return 3;
        }
        switch (this.status()) {
            case 0: 
            case 1: {
                if (this.runningSynchronizations != null) {
                    if (this.executingInterposedSynchs && !sr.isInterposed()) {
                        return 3;
                    }
                    this.runningSynchronizations.add(this.synchronizationCompletionService.submit(new AsyncBeforeSynchronization(this, sr)));
                    return 2;
                }
                if (this._currentRecord != null && sr.compareTo(this._currentRecord) != 1) {
                    return 3;
                }
                this._syncLock.lock();
                try {
                    if (this._synchs == null) {
                        this._synchs = new TreeSet<SynchronizationRecord>();
                    }
                    if (!this._synchs.add(sr)) break;
                    result = 2;
                    break;
                }
                finally {
                    this._syncLock.unlock();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean asyncBeforeCompletion() {
        boolean problem;
        block26: {
            problem = false;
            ArrayList<SynchronizationRecord> interposedSynchs = new ArrayList<SynchronizationRecord>();
            this._syncLock.lock();
            try {
                this.synchronizationCompletionService = TwoPhaseCommitThreadPool.getNewCompletionService();
                this.runningSynchronizations = new ArrayList<Future<Boolean>>(this._synchs.size());
                for (SynchronizationRecord synchronizationRecord : this._synchs) {
                    if (synchronizationRecord.isInterposed()) {
                        interposedSynchs.add(synchronizationRecord);
                        continue;
                    }
                    this.runningSynchronizations.add(this.synchronizationCompletionService.submit(new AsyncBeforeSynchronization(this, synchronizationRecord)));
                }
            }
            finally {
                this._syncLock.unlock();
            }
            try {
                int processed = 0;
                do {
                    block25: {
                        this._syncLock.lock();
                        try {
                            if (processed != this.runningSynchronizations.size()) break block25;
                            if (this.executingInterposedSynchs || interposedSynchs.isEmpty()) break block26;
                            this.executingInterposedSynchs = true;
                            processed = 0;
                            this.runningSynchronizations.clear();
                            for (SynchronizationRecord synchRecord : interposedSynchs) {
                                this.runningSynchronizations.add(this.synchronizationCompletionService.submit(new AsyncBeforeSynchronization(this, synchRecord)));
                            }
                        }
                        finally {
                            this._syncLock.unlock();
                        }
                    }
                    ++processed;
                    try {
                        if (this.synchronizationCompletionService.take().get().booleanValue()) continue;
                        problem = true;
                    }
                    catch (ExecutionException executionException) {
                        if (this._deferredThrowable == null) {
                            this._deferredThrowable = executionException.getCause();
                        }
                        problem = true;
                    }
                    catch (InterruptedException interruptedException) {
                        tsLogger.i18NLogger.warn_coordinator_TwoPhaseCoordinator_2(this._currentRecord.toString(), interruptedException);
                        problem = true;
                    }
                } while (!problem);
            }
            finally {
                try {
                    for (Future<Boolean> future : this.runningSynchronizations) {
                        future.cancel(false);
                    }
                }
                finally {
                    this.runningSynchronizations.clear();
                }
            }
        }
        return !problem;
    }

    @Override
    public boolean running() {
        return this.status() == 0 || this.status() == 3;
    }

    @Override
    public String type() {
        return "/StateManager/BasicAction/AtomicAction/TwoPhaseCoordinator";
    }

    public Throwable getDeferredThrowable() {
        return this._deferredThrowable;
    }

    protected TwoPhaseCoordinator(int at) {
        super(at);
    }

    protected TwoPhaseCoordinator(Uid u, int at) {
        super(u, at);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean beforeCompletion() {
        boolean problem = false;
        this._syncLock.lock();
        try {
            if (!this._beforeCalled) {
                this._beforeCalled = true;
                if (this._synchs != null) {
                    if (TxControl.asyncBeforeSynch && this._synchs.size() > 1) {
                        problem = !this.asyncBeforeCompletion();
                    } else {
                        int lastIndexProcessed = -1;
                        SynchronizationRecord[] copiedSynchs = this._synchs.toArray(new SynchronizationRecord[0]);
                        while (lastIndexProcessed < this._synchs.size() - 1 && !problem) {
                            if (copiedSynchs.length != this._synchs.size()) {
                                copiedSynchs = this._synchs.toArray(new SynchronizationRecord[0]);
                            }
                            this._currentRecord = copiedSynchs[++lastIndexProcessed];
                            try {
                                problem = !this._currentRecord.beforeCompletion();
                            }
                            catch (Exception ex) {
                                tsLogger.i18NLogger.warn_coordinator_TwoPhaseCoordinator_2(this._currentRecord.toString(), ex);
                                if (this._deferredThrowable == null) {
                                    this._deferredThrowable = ex;
                                }
                                problem = true;
                            }
                            catch (Error er) {
                                tsLogger.i18NLogger.warn_coordinator_TwoPhaseCoordinator_2(this._currentRecord.toString(), er);
                                if (this._deferredThrowable == null) {
                                    this._deferredThrowable = er;
                                }
                                problem = true;
                            }
                        }
                    }
                }
            }
            if (problem && !this.preventCommit()) {
                tsLogger.i18NLogger.warn_coordinator_TwoPhaseCoordinator_1();
            }
        }
        finally {
            this._syncLock.unlock();
        }
        return !problem;
    }

    protected boolean asyncAfterCompletion(int myStatus, boolean report_heuristics) {
        boolean problem = false;
        if (this.synchronizationCompletionService == null) {
            this.synchronizationCompletionService = TwoPhaseCommitThreadPool.getNewCompletionService();
        }
        if (this.runningSynchronizations == null) {
            this.runningSynchronizations = new ArrayList<Future<Boolean>>(this._synchs.size());
        }
        Iterator i = this._synchs.iterator();
        while (i.hasNext()) {
            SynchronizationRecord synchRecord = (SynchronizationRecord)i.next();
            if (!report_heuristics && synchRecord instanceof HeuristicNotification) {
                ((HeuristicNotification)synchRecord).heuristicOutcome(this.getHeuristicDecision());
            }
            if (!synchRecord.isInterposed()) continue;
            i.remove();
            this.runningSynchronizations.add(this.synchronizationCompletionService.submit(new AsyncAfterSynchronization(this, synchRecord, myStatus)));
        }
        int processed = 0;
        this.executingInterposedSynchs = true;
        while (true) {
            if (processed == this.runningSynchronizations.size()) {
                if (!this.executingInterposedSynchs || this._synchs.isEmpty()) break;
                this.executingInterposedSynchs = false;
                processed = 0;
                this.runningSynchronizations.clear();
                for (SynchronizationRecord synchRecord : this._synchs) {
                    this.runningSynchronizations.add(this.synchronizationCompletionService.submit(new AsyncAfterSynchronization(this, synchRecord, myStatus)));
                }
                this._synchs.clear();
            }
            ++processed;
            try {
                if (this.synchronizationCompletionService.take().get().booleanValue()) continue;
                problem = true;
            }
            catch (InterruptedException e) {
                problem = true;
            }
            catch (ExecutionException e) {
                problem = true;
            }
        }
        return !problem;
    }

    protected boolean afterCompletion(int myStatus) {
        return this.afterCompletion(myStatus, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean afterCompletion(int myStatus, boolean report_heuristics) {
        boolean problem;
        block15: {
            if (myStatus == 0) {
                tsLogger.i18NLogger.warn_coordinator_TwoPhaseCoordinator_3();
                return false;
            }
            problem = false;
            this._syncLock.lock();
            try {
                if (this._afterCalled) break block15;
                this._afterCalled = true;
                if (this._synchs == null) {
                    boolean bl = !problem;
                    return bl;
                }
                if (TxControl.asyncAfterSynch && this._synchs.size() > 1) {
                    problem = this.asyncAfterCompletion(myStatus, report_heuristics);
                    break block15;
                }
                Stack stack = new Stack();
                Iterator iterator = this._synchs.iterator();
                try {
                    while (iterator.hasNext()) {
                        stack.push(iterator.next());
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                while (!stack.isEmpty()) {
                    SynchronizationRecord record = (SynchronizationRecord)stack.pop();
                    if (!report_heuristics && record instanceof HeuristicNotification) {
                        ((HeuristicNotification)record).heuristicOutcome(this.getHeuristicDecision());
                    }
                    try {
                        if (record.afterCompletion(myStatus)) continue;
                        tsLogger.i18NLogger.warn_coordinator_TwoPhaseCoordinator_4(record.toString());
                        problem = true;
                    }
                    catch (Exception ex) {
                        tsLogger.i18NLogger.warn_coordinator_TwoPhaseCoordinator_4a(record.toString(), ex);
                        problem = true;
                    }
                    catch (Error er) {
                        tsLogger.i18NLogger.warn_coordinator_TwoPhaseCoordinator_4b(record.toString(), er);
                        problem = true;
                    }
                }
                this._synchs.clear();
            }
            finally {
                this._syncLock.unlock();
            }
        }
        return !problem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Uid, String> getSynchronizations() {
        HashMap<Uid, String> synchs = new HashMap<Uid, String>();
        this._syncLock.lock();
        try {
            if (this._synchs != null) {
                for (Object e : this._synchs) {
                    SynchronizationRecord synch = (SynchronizationRecord)e;
                    synchs.put(synch.get_uid(), synch.toString());
                }
            }
        }
        finally {
            this._syncLock.unlock();
        }
        return synchs;
    }

    @Override
    public void recordStackTraces() {
        super.recordStackTraces();
    }

    @Override
    public void outputCapturedStackTraces() {
        super.outputCapturedStackTraces();
    }
}

