/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.service.BatchServiceTarget;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;

public final class DelegatingServiceContainer
implements ServiceContainer {
    private final ServiceTarget delegateTarget;
    private final ServiceRegistry delegateRegistry;

    public DelegatingServiceContainer(ServiceTarget delegateTarget, ServiceRegistry delegateRegistry) {
        this.delegateTarget = delegateTarget;
        this.delegateRegistry = delegateRegistry;
    }

    @Override
    public <T> ServiceBuilder<T> addServiceValue(ServiceName name, Value<? extends Service<T>> value) throws IllegalArgumentException {
        return this.delegateTarget.addServiceValue(name, value);
    }

    @Override
    public <T> ServiceBuilder<T> addService(ServiceName name, Service<T> service) throws IllegalArgumentException {
        return this.delegateTarget.addService(name, service);
    }

    @Override
    public ServiceContainer addListener(ServiceListener<Object> listener) {
        this.delegateTarget.addListener(listener);
        return this;
    }

    @Override
    public ServiceContainer addListener(ServiceListener<Object> ... listeners) {
        this.delegateTarget.addListener(listeners);
        return this;
    }

    @Override
    public ServiceContainer addListener(Collection<ServiceListener<Object>> listeners) {
        this.delegateTarget.addListener(listeners);
        return this;
    }

    @Override
    public ServiceContainer addListener(ServiceListener.Inheritance inheritance, ServiceListener<Object> listener) {
        this.delegateTarget.addListener(inheritance, listener);
        return this;
    }

    @Override
    public ServiceContainer addListener(ServiceListener.Inheritance inheritance, ServiceListener<Object> ... listeners) {
        this.delegateTarget.addListener(inheritance, listeners);
        return this;
    }

    @Override
    public ServiceContainer addListener(ServiceListener.Inheritance inheritance, Collection<ServiceListener<Object>> listeners) {
        this.delegateTarget.addListener(inheritance, listeners);
        return this;
    }

    @Override
    public ServiceContainer removeListener(ServiceListener<Object> listener) {
        this.delegateTarget.removeListener(listener);
        return this;
    }

    @Override
    public Set<ServiceListener<Object>> getListeners() {
        return this.delegateTarget.getListeners();
    }

    @Override
    public ServiceContainer addDependency(ServiceName dependency) {
        this.delegateTarget.addDependency(dependency);
        return this;
    }

    @Override
    public ServiceContainer addDependency(ServiceName ... dependencies) {
        this.delegateTarget.addDependency(dependencies);
        return this;
    }

    @Override
    public ServiceContainer addDependency(Collection<ServiceName> dependencies) {
        this.delegateTarget.addDependency(dependencies);
        return this;
    }

    @Override
    public ServiceContainer removeDependency(ServiceName dependency) {
        this.delegateTarget.removeDependency(dependency);
        return this;
    }

    @Override
    public Set<ServiceName> getDependencies() {
        return this.delegateTarget.getDependencies();
    }

    @Override
    public ServiceTarget subTarget() {
        return this.delegateTarget.subTarget();
    }

    @Override
    public BatchServiceTarget batchTarget() {
        return this.delegateTarget.batchTarget();
    }

    @Override
    public ServiceController<?> getRequiredService(ServiceName serviceName) throws ServiceNotFoundException {
        return this.delegateRegistry.getRequiredService(serviceName);
    }

    @Override
    public ServiceController<?> getService(ServiceName serviceName) {
        return this.delegateRegistry.getService(serviceName);
    }

    @Override
    public List<ServiceName> getServiceNames() {
        return this.delegateRegistry.getServiceNames();
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdownComplete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpServices() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpServices(PrintStream stream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addTerminateListener(ServiceContainer.TerminateListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void awaitTermination() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }
}

