/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.managed.api.ManagedObject;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.plugins.values.MetaValueFactoryBuilder;
import org.jboss.system.server.profileservice.persistence.AbstractManagedObjectPersistencePlugin;
import org.jboss.system.server.profileservice.persistence.AbstractValuePersistence;
import org.jboss.system.server.profileservice.persistence.DefaultManagedObjectPlugin;
import org.jboss.system.server.profileservice.persistence.ManagedObjectPersistencePlugin;
import org.jboss.system.server.profileservice.persistence.xml.PersistedManagedObject;

public class DelegatingPersistencePlugin
implements ManagedObjectPersistencePlugin {
    private Map<String, ManagedObjectPersistencePlugin> plugins = new ConcurrentHashMap<String, ManagedObjectPersistencePlugin>();
    private final ManagedObjectPersistencePlugin defaultPlugin;
    private final MetaValueFactory metaValueFactory = MetaValueFactoryBuilder.create();
    private final AbstractValuePersistence valuePersistence = new AbstractValuePersistence(this, this.metaValueFactory);

    public DelegatingPersistencePlugin() {
        this(new DefaultManagedObjectPlugin());
    }

    public DelegatingPersistencePlugin(ManagedObjectPersistencePlugin defaultPlugin) {
        this.defaultPlugin = defaultPlugin;
        this.defaultPlugin.setValuePersistence(this.valuePersistence);
    }

    public PersistedManagedObject createPersistedManagedObject(ManagedObject mo) {
        if (mo == null) {
            throw new IllegalArgumentException("Null managed object.");
        }
        ManagedObjectPersistencePlugin plugin = this.getPlugin(mo);
        return plugin.createPersistedManagedObject(mo);
    }

    public PersistedManagedObject createPersistedManagedObject(PersistedManagedObject persisted, ManagedObject mo) {
        if (persisted == null) {
            throw new IllegalArgumentException("Null persisted managed object.");
        }
        if (mo == null) {
            throw new IllegalArgumentException("Null managed object.");
        }
        ManagedObjectPersistencePlugin plugin = this.getPlugin(mo);
        return plugin.createPersistedManagedObject(persisted, mo);
    }

    protected ManagedObjectPersistencePlugin getPlugin(ManagedObject mo) {
        String type = mo.getAttachmentName();
        if (type == null && mo.getAttachment() != null) {
            type = mo.getAttachment().getClass().getName();
        }
        if (type == null) {
            return this.defaultPlugin;
        }
        return this.getPlugin(type);
    }

    public ManagedObjectPersistencePlugin getPlugin(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type.");
        }
        ManagedObjectPersistencePlugin plugin = this.plugins.get(type);
        if (plugin == null) {
            plugin = this.defaultPlugin;
        }
        return plugin;
    }

    public void addPlugin(AbstractManagedObjectPersistencePlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Null plugin.");
        }
        if (plugin.getType() == null) {
            throw new IllegalArgumentException("Null plugin type.");
        }
        plugin.setValuePersistence(this.valuePersistence);
        this.plugins.put(plugin.getType(), plugin);
    }

    public void removePlugin(AbstractManagedObjectPersistencePlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Null plugin.");
        }
        if (plugin.getType() == null) {
            throw new IllegalArgumentException("Null plugin type.");
        }
        this.plugins.remove(plugin.getType());
    }

    public AbstractValuePersistence getValuePersistence() {
        return this.valuePersistence;
    }

    public void setValuePersistence(AbstractValuePersistence valuePersistence) {
    }
}

