/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.system.server.ServerInfoMBean;
import org.jboss.util.platform.Java;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagementObject(name="jboss.system:type=ServerInfo", isRuntime=true, description="provides a view of system information for the JBoss server in which it is deployed", componentType=@ManagementComponent(type="MCBean", subtype="ServerInfo"))
public class ServerInfo
implements ServerInfoMBean,
MBeanRegistration {
    private static final Logger log = Logger.getLogger(ServerInfo.class);
    private static final Integer ZERO = new Integer(0);
    private static final Class[] NO_PARAMS_SIG = new Class[0];
    private static final Object[] NO_PARAMS = new Object[0];
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private String hostName;
    private String hostAddress;
    private boolean isObjectMonitorUsageSupported;
    private boolean isSynchronizerUsageSupported;
    private Method findDeadlockedThreads;
    private Method dumpAllThreads;
    private Method getThreadInfoWithSyncInfo;
    private Method getLockInfo;
    private Method getLockedMonitors;
    private Method getLockedSynchronizers;
    private Method getClassName;
    private Method getIdentityHashCode;
    private Method from;
    private Method getLockedStackDepth;
    private Method getLockedStackFrame;

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        log.info((Object)("Java version: " + System.getProperty("java.version") + "," + System.getProperty("java.vendor")));
        log.info((Object)("Java Runtime: " + System.getProperty("java.runtime.name") + " (build " + System.getProperty("java.runtime.version") + ")"));
        log.info((Object)("Java VM: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + "," + System.getProperty("java.vm.vendor")));
        log.info((Object)("OS-System: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "," + System.getProperty("os.arch")));
        log.info((Object)("VM arguments: " + this.getVMArguments()));
        log.debug((Object)"Full System Properties Dump");
        Enumeration<?> names = System.getProperties().propertyNames();
        while (names.hasMoreElements()) {
            String pname = (String)names.nextElement();
            log.debug((Object)("    " + pname + ": " + System.getProperty(pname)));
        }
        if (Java.isCompatible((int)7)) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class clazz = ThreadMXBean.class;
                Method method = clazz.getMethod("isObjectMonitorUsageSupported", NO_PARAMS_SIG);
                this.isObjectMonitorUsageSupported = (Boolean)method.invoke((Object)threadMXBean, NO_PARAMS);
                method = clazz.getMethod("isSynchronizerUsageSupported", NO_PARAMS_SIG);
                this.isSynchronizerUsageSupported = (Boolean)method.invoke((Object)threadMXBean, NO_PARAMS);
                this.findDeadlockedThreads = clazz.getMethod("findDeadlockedThreads", NO_PARAMS_SIG);
                this.dumpAllThreads = clazz.getMethod("dumpAllThreads", Boolean.TYPE, Boolean.TYPE);
                this.getThreadInfoWithSyncInfo = clazz.getMethod("getThreadInfo", long[].class, Boolean.TYPE, Boolean.TYPE);
                clazz = ThreadInfo.class;
                this.getLockInfo = clazz.getMethod("getLockInfo", NO_PARAMS_SIG);
                this.getLockedMonitors = clazz.getMethod("getLockedMonitors", NO_PARAMS_SIG);
                this.getLockedSynchronizers = clazz.getMethod("getLockedSynchronizers", NO_PARAMS_SIG);
                clazz = cl.loadClass("java.lang.management.LockInfo");
                this.getClassName = clazz.getMethod("getClassName", NO_PARAMS_SIG);
                this.getIdentityHashCode = clazz.getMethod("getIdentityHashCode", NO_PARAMS_SIG);
                clazz = cl.loadClass("java.lang.management.MonitorInfo");
                this.from = clazz.getMethod("from", CompositeData.class);
                this.getLockedStackDepth = clazz.getMethod("getLockedStackDepth", NO_PARAMS_SIG);
                this.getLockedStackFrame = clazz.getMethod("getLockedStackFrame", NO_PARAMS_SIG);
            }
            catch (Exception e) {
                log.debug((Object)"Cannot access platform ThreadMXBean", (Throwable)e);
            }
        }
        return name == null ? new ObjectName("jboss.system:type=ServerInfo") : name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    @Override
    @ManagementProperty(use={ViewUse.RUNTIME}, readOnly=true)
    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    @Override
    @ManagementProperty(use={ViewUse.RUNTIME}, readOnly=true)
    public String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    @Override
    @ManagementProperty(use={ViewUse.RUNTIME}, readOnly=true)
    public String getJavaVMName() {
        return System.getProperty("java.vm.name");
    }

    @Override
    @ManagementProperty(use={ViewUse.RUNTIME}, readOnly=true)
    public String getJavaVMVersion() {
        return System.getProperty("java.vm.version");
    }

    @Override
    @ManagementProperty(use={ViewUse.RUNTIME}, readOnly=true)
    public String getJavaVMVendor() {
        return System.getProperty("java.vm.vendor");
    }

    @Override
    @ManagementProperty(use={ViewUse.RUNTIME}, readOnly=true)
    public String getOSName() {
        return System.getProperty("os.name");
    }

    @Override
    @ManagementProperty(use={ViewUse.RUNTIME}, readOnly=true)
    public String getOSVersion() {
        return System.getProperty("os.version");
    }

    @Override
    @ManagementProperty(use={ViewUse.RUNTIME}, readOnly=true)
    public String getOSArch() {
        return System.getProperty("os.arch");
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC}, readOnly=true)
    public Long getTotalMemory() {
        return new Long(Runtime.getRuntime().totalMemory());
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC}, readOnly=true)
    public Long getFreeMemory() {
        return new Long(Runtime.getRuntime().freeMemory());
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC}, readOnly=true)
    public Long getMaxMemory() {
        if (Java.isCompatible((int)5)) {
            try {
                Runtime rt = Runtime.getRuntime();
                Method m = rt.getClass().getMethod("maxMemory", NO_PARAMS_SIG);
                return (Long)m.invoke((Object)rt, NO_PARAMS);
            }
            catch (Exception e) {
                log.error((Object)"Operation failed", (Throwable)e);
            }
        }
        return new Long(-1L);
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC}, readOnly=true)
    public Integer getAvailableProcessors() {
        if (Java.isCompatible((int)5)) {
            try {
                Runtime rt = Runtime.getRuntime();
                Method m = rt.getClass().getMethod("availableProcessors", NO_PARAMS_SIG);
                return (Integer)m.invoke((Object)rt, NO_PARAMS);
            }
            catch (Exception e) {
                log.error((Object)"Operation failed", (Throwable)e);
            }
        }
        return new Integer(-1);
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC}, readOnly=true)
    public String getHostName() {
        if (this.hostName == null) {
            try {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                log.error((Object)"Error looking up local hostname", (Throwable)e);
                this.hostName = "<unknown>";
            }
        }
        return this.hostName;
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC}, readOnly=true)
    public String getHostAddress() {
        if (this.hostAddress == null) {
            try {
                this.hostAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                log.error((Object)"Error looking up local address", (Throwable)e);
                this.hostAddress = "<unknown>";
            }
        }
        return this.hostAddress;
    }

    @Override
    @ManagementOperation(description="Return a listing of the thread pools on jdk5+", impact=ManagedOperation.Impact.ReadOnly, params={@ManagementParameter(name="fancy", description="produce a text-based graph when true")})
    public String listMemoryPools(boolean fancy) {
        StringBuffer sbuf = new StringBuffer(4196);
        List<MemoryPoolMXBean> poolList = ManagementFactory.getMemoryPoolMXBeans();
        sbuf.append("<b>Total Memory Pools:</b> ").append(poolList.size());
        sbuf.append("<blockquote>");
        for (MemoryPoolMXBean pool : poolList) {
            String name = pool.getName();
            MemoryType type = pool.getType();
            sbuf.append("<b>Pool: ").append(name);
            sbuf.append("</b> (").append((Object)type).append(")");
            MemoryUsage peakUsage = pool.getPeakUsage();
            MemoryUsage usage = pool.getUsage();
            sbuf.append("<blockquote>");
            if (usage != null && peakUsage != null) {
                Long init = peakUsage.getInit();
                Long used = peakUsage.getUsed();
                Long committed = peakUsage.getCommitted();
                Long max = peakUsage.getMax();
                sbuf.append("Peak Usage    : ");
                sbuf.append("init:").append(init);
                sbuf.append(", used:").append(used);
                sbuf.append(", committed:").append(committed);
                sbuf.append(", max:").append(max);
                sbuf.append("<br/>");
                init = usage.getInit();
                used = usage.getUsed();
                committed = usage.getCommitted();
                max = usage.getMax();
                sbuf.append("Current Usage : ");
                sbuf.append("init:").append(init);
                sbuf.append(", used:").append(used);
                sbuf.append(", committed:").append(committed);
                sbuf.append(", max:").append(max);
                if (fancy) {
                    TextGraphHelper.poolUsage(sbuf, used, committed, max);
                }
            } else {
                sbuf.append("Memory pool NOT valid!");
            }
            sbuf.append("</blockquote><br/>");
        }
        return sbuf.toString();
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC}, readOnly=true)
    public Integer getActiveThreadCount() {
        return new Integer(this.getRootThreadGroup().activeCount());
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC}, readOnly=true)
    public Integer getActiveThreadGroupCount() {
        return new Integer(this.getRootThreadGroup().activeGroupCount());
    }

    @Override
    @ManagementOperation(description="Return a listing of the active threads and thread groups", impact=ManagedOperation.Impact.ReadOnly)
    public String listThreadDump() {
        ThreadGroup root = this.getRootThreadGroup();
        ThreadGroupCount count = new ThreadGroupCount();
        StringBuffer rc = new StringBuffer();
        this.findDeadlockedThreads(rc);
        this.getThreadGroupInfo(root, count, rc);
        String threadDump = "<b>Total Threads:</b> " + count.threads + "<br/>" + "<b>Total Thread Groups:</b> " + count.groups + "<br/>" + "<b>Timestamp:</b> " + dateFormat.format(new Date()) + "<br/>" + rc.toString();
        return threadDump;
    }

    @Override
    @ManagementOperation(description="Return a listing of the active threads and thread groups", impact=ManagedOperation.Impact.ReadOnly)
    public String listThreadCpuUtilization() {
        Set<ThreadCPU> threads = this.getThreadCpuUtilization();
        if (threads == null) {
            return "Thread cpu utilization requires J2SE5+";
        }
        long totalCPU = 0L;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<table><tr><th>Thread Name</th><th>CPU (milliseconds)</th></tr>");
        for (ThreadCPU thread : threads) {
            buffer.append("<tr><td>").append(thread.name).append("</td><td>");
            buffer.append(thread.cpuTime).append("</td></tr>");
            totalCPU += thread.cpuTime;
        }
        buffer.append("<tr><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td>Total</td><td>");
        buffer.append(totalCPU).append("</td></tr></table>");
        return buffer.toString();
    }

    private Set<ThreadCPU> getThreadCpuUtilization() {
        TreeSet<ThreadCPU> result = new TreeSet<ThreadCPU>();
        long[] threads = threadMXBean.getAllThreadIds();
        for (int i = 0; i < threads.length; ++i) {
            Long id = new Long(threads[i]);
            Long cpuTime = threadMXBean.getThreadCpuTime(id);
            ThreadInfo threadInfo = threadMXBean.getThreadInfo(id, (int)ZERO);
            if (threadInfo == null) continue;
            String name = threadInfo.getThreadName();
            result.add(new ThreadCPU(name, cpuTime));
        }
        return result;
    }

    private ThreadGroup getRootThreadGroup() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        return group;
    }

    private void getThreadGroupInfo(ThreadGroup group, ThreadGroupCount count, StringBuffer rc) {
        if (Java.isCompatible((int)7) && (this.isObjectMonitorUsageSupported || this.isSynchronizerUsageSupported)) {
            log.debug((Object)("Generate a thread dump [show monitors = " + this.isObjectMonitorUsageSupported + ", show ownable synchronizers = " + this.isSynchronizerUsageSupported + "]"));
            this.getThreadGroupInfoWithLocks(group, count, rc);
        } else {
            log.debug((Object)"Generate a thread dump without locks.");
            this.getThreadGroupInfoWithoutLocks(group, count, rc);
        }
    }

    private void getThreadGroupInfoWithoutLocks(ThreadGroup group, ThreadGroupCount count, StringBuffer rc) {
        ++count.groups;
        rc.append("<br/><b>");
        rc.append("Thread Group: " + group.getName());
        rc.append("</b> : ");
        rc.append("max priority:" + group.getMaxPriority() + ", demon:" + group.isDaemon());
        rc.append("<blockquote>");
        Thread[] threads = new Thread[group.activeCount()];
        group.enumerate(threads, false);
        for (int i = 0; i < threads.length && threads[i] != null; ++i) {
            ++count.threads;
            rc.append("<b>");
            rc.append("Thread: " + threads[i].getName());
            rc.append("</b> : ");
            rc.append("priority:" + threads[i].getPriority() + ", demon:" + threads[i].isDaemon() + ", ");
            this.outputJdk5ThreadMXBeanInfo(rc, threads[i]);
        }
        ThreadGroup[] groups = new ThreadGroup[group.activeGroupCount()];
        group.enumerate(groups, false);
        for (int i = 0; i < groups.length && groups[i] != null; ++i) {
            this.getThreadGroupInfoWithoutLocks(groups[i], count, rc);
        }
        rc.append("</blockquote>");
    }

    private void getThreadGroupInfoWithLocks(ThreadGroup group, ThreadGroupCount count, StringBuffer rc) {
        ++count.groups;
        rc.append("<br/><b>");
        rc.append("Thread Group: " + group.getName());
        rc.append("</b> : ");
        rc.append("max priority:" + group.getMaxPriority() + ", demon:" + group.isDaemon());
        rc.append("<blockquote>");
        Thread[] threads = new Thread[group.activeCount()];
        group.enumerate(threads, false);
        long[] idsTmp = new long[threads.length];
        int numberNonNullThreads = 0;
        for (int i = 0; i < threads.length && threads[i] != null; ++i) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Adding " + threads[i] + " with id=" + threads[i].getId()));
            }
            idsTmp[i] = threads[i].getId();
            ++numberNonNullThreads;
        }
        long[] ids = new long[numberNonNullThreads];
        System.arraycopy(idsTmp, 0, ids, 0, numberNonNullThreads);
        if (log.isTraceEnabled()) {
            log.trace((Object)("List of ids after trimming " + Arrays.toString(ids)));
        }
        try {
            ThreadInfo[] infos = (ThreadInfo[])this.getThreadInfoWithSyncInfo.invoke((Object)threadMXBean, ids, this.isObjectMonitorUsageSupported, this.isSynchronizerUsageSupported);
            for (int i = 0; i < infos.length && threads[i] != null; ++i) {
                ++count.threads;
                rc.append("<b>");
                rc.append("Thread: " + infos[i].getThreadName());
                rc.append("</b> : ");
                rc.append("priority:" + threads[i].getPriority() + ", demon:" + threads[i].isDaemon() + ", ");
                this.outputJdk6ThreadMXBeanInfo(rc, infos[i]);
            }
            ThreadGroup[] groups = new ThreadGroup[group.activeGroupCount()];
            group.enumerate(groups, false);
            for (int i = 0; i < groups.length && groups[i] != null; ++i) {
                this.getThreadGroupInfoWithLocks(groups[i], count, rc);
            }
        }
        catch (Exception ignore) {
            log.debug((Object)"Exception to be ignored", (Throwable)ignore);
        }
        rc.append("</blockquote>");
    }

    private void outputJdk5ThreadMXBeanInfo(StringBuffer sbuf, Thread thread) {
        Long threadId = thread.getId();
        ThreadInfo threadInfo = threadMXBean.getThreadInfo(threadId, (int)new Integer(Integer.MAX_VALUE));
        this.outputJdk5ThreadMXBeanInfo(sbuf, threadInfo);
    }

    private void outputJdk5ThreadMXBeanInfo(StringBuffer sbuf, ThreadInfo threadInfo) {
        if (threadInfo != null) {
            Thread.State threadState = threadInfo.getThreadState();
            String lockName = threadInfo.getLockName();
            StackTraceElement[] stackTrace = threadInfo.getStackTrace();
            Long threadId = threadInfo.getThreadId();
            sbuf.append("threadId:").append(threadId);
            sbuf.append(", threadState:").append((Object)threadState);
            sbuf.append("<br/>");
            if (stackTrace.length > 0) {
                sbuf.append("<blockquote>");
                this.printLockName(sbuf, "waiting on", lockName);
                for (int i = 0; i < stackTrace.length; ++i) {
                    sbuf.append(stackTrace[i]).append("<br/>");
                }
                sbuf.append("</blockquote>");
            }
        } else {
            sbuf.append("<br/>");
        }
    }

    private void outputJdk6ThreadMXBeanInfo(StringBuffer sbuf, ThreadInfo threadInfo) throws Exception {
        Long threadId = threadInfo.getThreadId();
        sbuf.append("threadId:").append(threadId);
        if (threadInfo != null) {
            Thread.State threadState = threadInfo.getThreadState();
            String lockName = threadInfo.getLockName();
            StackTraceElement[] stackTrace = threadInfo.getStackTrace();
            Object[] monitors = (Object[])this.getLockedMonitors.invoke((Object)threadInfo, NO_PARAMS);
            sbuf.append(", threadState:").append((Object)threadState);
            sbuf.append("<br/>");
            if (stackTrace.length > 0) {
                sbuf.append("<blockquote>");
                this.printLockName(sbuf, "waiting on", lockName);
                for (int i = 0; i < stackTrace.length; ++i) {
                    sbuf.append(stackTrace[i]).append("<br/>");
                    for (Object monitor : monitors) {
                        int lockedStackDepth = (Integer)this.getLockedStackDepth.invoke(monitor, NO_PARAMS);
                        if (lockedStackDepth != i) continue;
                        this.printLockName(sbuf, "locked", monitor.toString());
                    }
                }
                Object[] synchronizers = (Object[])this.getLockedSynchronizers.invoke((Object)threadInfo, NO_PARAMS);
                if (synchronizers.length > 0) {
                    sbuf.append("<br/>").append("<b>Locked synchronizers</b> : ").append("<br/>");
                    for (Object synchronizer : synchronizers) {
                        this.printLockName(sbuf, "locked", synchronizer.toString());
                    }
                }
                sbuf.append("</blockquote>");
            }
        } else {
            sbuf.append("<br/>");
        }
    }

    private void printLockName(StringBuffer sbuf, String status, String lockName) {
        if (lockName != null) {
            String[] lockInfo = lockName.split("@");
            sbuf.append("- " + status + " <0x" + lockInfo[1] + "> (a " + lockInfo[0] + ")").append("<br/>");
        }
    }

    private void findDeadlockedThreads(StringBuffer rc) {
        if (Java.isCompatible((int)7) && this.isSynchronizerUsageSupported) {
            this.findDeadlockedThreadsMonitorsOrSynchronisers(rc);
        } else {
            this.findDeadlockedThreadsOnlyMonitors(rc);
        }
    }

    private void findDeadlockedThreadsMonitorsOrSynchronisers(StringBuffer sb) {
        try {
            long[] ids = (long[])this.findDeadlockedThreads.invoke((Object)threadMXBean, NO_PARAMS);
            if (ids == null) {
                return;
            }
            ThreadInfo[] threadsInfo = (ThreadInfo[])this.getThreadInfoWithSyncInfo.invoke((Object)threadMXBean, ids, this.isObjectMonitorUsageSupported, this.isSynchronizerUsageSupported);
            sb.append("<br/><b>Found deadlock(s)</b> : <br/><br/>");
            for (ThreadInfo threadInfo : threadsInfo) {
                sb.append("<b>");
                sb.append("Thread: " + threadInfo.getThreadName());
                sb.append("</b> : ");
                this.outputJdk6ThreadMXBeanInfo(sb, threadInfo);
            }
        }
        catch (Exception ignore) {
            log.debug((Object)"Exception to be ignored", (Throwable)ignore);
        }
    }

    private void findDeadlockedThreadsOnlyMonitors(StringBuffer sb) {
        try {
            long[] ids = threadMXBean.findMonitorDeadlockedThreads();
            if (ids == null) {
                return;
            }
            ThreadInfo[] threadsInfo = threadMXBean.getThreadInfo(ids, Integer.MAX_VALUE);
            sb.append("<br/><b>Found deadlock(s)</b> : <br/><br/>");
            for (ThreadInfo threadInfo : threadsInfo) {
                sb.append("<b>");
                sb.append("Thread: " + threadInfo.getThreadName());
                sb.append("</b> : ");
                this.outputJdk5ThreadMXBeanInfo(sb, threadInfo);
            }
        }
        catch (Exception ignore) {
            log.debug((Object)"Exception to be ignored", (Throwable)ignore);
        }
    }

    private String getVMArguments() {
        String args = "";
        RuntimeMXBean rmBean = ManagementFactory.getRuntimeMXBean();
        List<String> inputArguments = rmBean.getInputArguments();
        for (String arg : inputArguments) {
            args = args + arg + " ";
        }
        return args;
    }

    @Override
    public String displayPackageInfo(String pkgName) {
        Package pkg = Package.getPackage(pkgName);
        if (pkg == null) {
            return "<h2>Package:" + pkgName + " Not Found!</h2>";
        }
        StringBuffer info = new StringBuffer("<h2>Package: " + pkgName + "</h2>");
        this.displayPackageInfo(pkg, info);
        return info.toString();
    }

    private void displayPackageInfo(Package pkg, StringBuffer info) {
        info.append("<pre>\n");
        info.append("SpecificationTitle: " + pkg.getSpecificationTitle());
        info.append("\nSpecificationVersion: " + pkg.getSpecificationVersion());
        info.append("\nSpecificationVendor: " + pkg.getSpecificationVendor());
        info.append("\nImplementationTitle: " + pkg.getImplementationTitle());
        info.append("\nImplementationVersion: " + pkg.getImplementationVersion());
        info.append("\nImplementationVendor: " + pkg.getImplementationVendor());
        info.append("\nisSealed: " + pkg.isSealed());
        info.append("</pre>\n");
    }

    private static class ThreadGroupCount {
        public int threads;
        public int groups;

        private ThreadGroupCount() {
        }
    }

    private static class ThreadCPU
    implements Comparable {
        public String name;
        public long cpuTime;

        public ThreadCPU(String name, long cpuTime) {
            this.name = name;
            this.cpuTime = cpuTime / 1000000L;
        }

        public int compareTo(Object o) {
            ThreadCPU other = (ThreadCPU)o;
            long value = this.cpuTime - other.cpuTime;
            if (value > 0L) {
                return -1;
            }
            if (value < 0L) {
                return 1;
            }
            return this.name.compareTo(other.name);
        }
    }

    private static class TextGraphHelper {
        static final DecimalFormat formatter = new DecimalFormat("#.##");
        static final long KILO = 1024L;
        static final long MEGA = 0x100000L;
        static final long GIGA = 0x40000000L;
        static final int factor = 70;
        static char[] fixedline;
        static char[] baseline;
        static char[] barline;
        static char[] spaces;

        private TextGraphHelper() {
        }

        public static void poolUsage(StringBuffer sbuf, long used, long committed, long max) {
            long assumedMax = max == -1L ? committed : max;
            int localUsed = (int)(70L * used / assumedMax);
            int localCommitted = (int)(70L * committed / assumedMax);
            int localMax = 70;
            sbuf.append("<blockquote><br/>");
            sbuf.append(baseline, 0, localCommitted).append("| committed:").append(TextGraphHelper.outputNumber(committed)).append("<br/>");
            sbuf.append(fixedline).append("<br/>");
            sbuf.append(barline, 0, localUsed);
            if (localUsed < localCommitted) {
                sbuf.append(localUsed > 0 ? (char)'/' : '|');
                sbuf.append(spaces, 0, localCommitted - localUsed - 1);
            }
            sbuf.append('|');
            if (localCommitted < localMax) {
                sbuf.append(spaces, 0, localMax - localCommitted - 1);
                sbuf.append('|');
            }
            sbuf.append(" max:").append(TextGraphHelper.outputNumber(max)).append("<br/>");
            sbuf.append(fixedline).append("<br/>");
            sbuf.append(baseline, 0, localUsed).append("| used:").append(TextGraphHelper.outputNumber(used));
            sbuf.append("</blockquote>");
        }

        private static String outputNumber(long value) {
            if (value >= 0x40000000L) {
                return formatter.format((double)value / 1.073741824E9) + "Gb";
            }
            if (value >= 0x100000L) {
                return formatter.format((double)value / 1048576.0) + "Mb";
            }
            if (value >= 1024L) {
                return formatter.format((double)value / 1024.0) + "Kb";
            }
            if (value >= 0L) {
                return value + "b";
            }
            return Long.toString(value);
        }

        static {
            StringBuffer sbuf0 = new StringBuffer();
            StringBuffer sbuf1 = new StringBuffer();
            StringBuffer sbuf2 = new StringBuffer();
            StringBuffer sbuf3 = new StringBuffer();
            sbuf0.append('+');
            sbuf1.append('|');
            sbuf2.append('|');
            for (int i = 1; i < 70; ++i) {
                sbuf0.append('-');
                sbuf1.append('-');
                sbuf2.append('/');
                sbuf3.append(' ');
            }
            sbuf0.append('+');
            fixedline = sbuf0.toString().toCharArray();
            baseline = sbuf1.toString().toCharArray();
            barline = sbuf2.toString().toCharArray();
            spaces = sbuf3.toString().toCharArray();
        }
    }
}

