/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.protocol.v1;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.naming.remote.client.ClientUtil;
import org.jboss.naming.remote.client.RemoteContext;
import org.jboss.naming.remote.client.RemoteNamingStore;
import org.jboss.naming.remote.protocol.ProtocolCommand;
import org.jboss.naming.remote.protocol.v1.BaseProtocolCommand;
import org.jboss.naming.remote.protocol.v1.ProtocolIoFuture;
import org.jboss.naming.remote.protocol.v1.ReadUtil;
import org.jboss.naming.remote.protocol.v1.WriteUtil;
import org.jboss.naming.remote.server.RemoteNamingService;
import org.jboss.remoting3.Channel;
import org.xnio.IoFuture;

class Protocol {
    static ProtocolCommand<Object> LOOKUP = new BaseProtocolCommand<Object>(1){

        @Override
        public Object execute(Channel channel, Object ... args) throws IOException, NamingException {
            if (args.length != 1 || !(args[0] instanceof Name)) {
                throw new IllegalArgumentException("Lookup requires a single name argument");
            }
            final Name name = (Name)Name.class.cast(args[0]);
            NamedIoFuture future = new NamedIoFuture(name);
            final int correlationId = this.reserveNextCorrelationId(future);
            try {
                WriteUtil.write(channel, new WriteUtil.Writer(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(this.getCommandId());
                        output.writeInt(correlationId);
                        Marshaller marshaller = WriteUtil.prepareForMarshalling(output);
                        marshaller.writeByte(0);
                        marshaller.writeObject((Object)name);
                        marshaller.finish();
                    }
                });
                IoFuture.Status result = future.await(10L, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        if (future.getHeldException() != null) {
                            throw future.getHeldException();
                        }
                        throw future.getException();
                    }
                    case DONE: {
                        Object object = future.get();
                        return object;
                    }
                }
                try {
                    throw new NamingException("Unable to invoke lookup, status=" + result.toString());
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ClientUtil.namingException("Failed to lookup", e);
                }
            }
            finally {
                this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void handleServerMessage(Channel channel, DataInput input, final int correlationId, RemoteNamingService remoteNamingService) throws IOException {
            Name name;
            Unmarshaller unmarshaller = ReadUtil.prepareForUnMarshalling(input);
            try {
                byte paramType = unmarshaller.readByte();
                if (paramType != 0) {
                    remoteNamingService.getLogger().unexpectedParameterType((byte)0, paramType);
                }
                name = (Name)unmarshaller.readObject(Name.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            finally {
                unmarshaller.close();
            }
            try {
                final Object result = remoteNamingService.getLocalContext().lookup(name);
                WriteUtil.write(channel, new WriteUtil.Writer(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(this.getCommandId());
                        output.writeInt(correlationId);
                        output.writeByte(0);
                        if (result instanceof Context) {
                            output.writeByte(5);
                        } else {
                            output.writeByte(1);
                            Marshaller marshaller = WriteUtil.prepareForMarshalling(output);
                            marshaller.writeObject(result);
                            marshaller.finish();
                        }
                    }
                });
            }
            catch (NamingException e) {
                WriteUtil.writeExceptionResponse(channel, e, this.getCommandId(), correlationId);
            }
        }

        @Override
        public void handleClientMessage(DataInput input, int correlationId, final RemoteNamingStore namingStore) throws IOException {
            this.readResult(correlationId, input, new BaseProtocolCommand.ValueReader<Object>(){

                @Override
                public void read(DataInput input, ProtocolIoFuture<Object> future) throws IOException {
                    byte parameterType = input.readByte();
                    switch (parameterType) {
                        case 1: {
                            try {
                                Unmarshaller unmarshaller = ReadUtil.prepareForUnMarshalling(input);
                                future.setResult(unmarshaller.readObject());
                                unmarshaller.finish();
                                break;
                            }
                            catch (ClassNotFoundException e) {
                                throw new IOException(e);
                            }
                            catch (ClassCastException e) {
                                throw new IOException(e);
                            }
                        }
                        case 5: {
                            future.setResult(new RemoteContext(((NamedIoFuture)((Object)NamedIoFuture.class.cast(future))).name, namingStore, new Hashtable<String, Object>()));
                            break;
                        }
                        default: {
                            throw new IOException("Unexpected response parameter received.");
                        }
                    }
                }
            });
        }
    };
    static ProtocolCommand<Void> BIND = new BaseProtocolCommand<Void>(2){

        @Override
        public Void execute(Channel channel, Object ... args) throws IOException, NamingException {
            if (args.length != 2 || !(args[0] instanceof Name)) {
                throw new IllegalArgumentException("Rebind requires a name and object argument");
            }
            final Name name = (Name)Name.class.cast(args[0]);
            final Object object = args[1];
            ProtocolIoFuture future = new ProtocolIoFuture();
            final int correlationId = this.reserveNextCorrelationId(future);
            try {
                WriteUtil.write(channel, new WriteUtil.Writer(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(this.getCommandId());
                        output.writeInt(correlationId);
                        Marshaller marshaller = WriteUtil.prepareForMarshalling(output);
                        marshaller.writeByte(0);
                        marshaller.writeObject((Object)name);
                        marshaller.writeByte(1);
                        marshaller.writeObject(object);
                        marshaller.finish();
                    }
                });
                IoFuture.Status result = future.await(10L, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        if (future.getHeldException() != null) {
                            throw future.getHeldException();
                        }
                        throw future.getException();
                    }
                    case DONE: {
                        Void void_ = null;
                        return void_;
                    }
                }
                try {
                    throw new NamingException("Unable to invoke bind, status=" + result.toString());
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ClientUtil.namingException("Failed to bind", e);
                }
            }
            finally {
                this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void handleServerMessage(Channel channel, DataInput input, int correlationId, RemoteNamingService remoteNamingService) throws IOException {
            Object object;
            Name name;
            Unmarshaller unmarshaller = ReadUtil.prepareForUnMarshalling(input);
            try {
                byte paramType = unmarshaller.readByte();
                if (paramType != 0) {
                    remoteNamingService.getLogger().unexpectedParameterType((byte)0, paramType);
                }
                name = (Name)unmarshaller.readObject(Name.class);
                paramType = unmarshaller.readByte();
                if (paramType != 1) {
                    remoteNamingService.getLogger().unexpectedParameterType((byte)1, paramType);
                }
                object = unmarshaller.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            finally {
                unmarshaller.finish();
            }
            try {
                remoteNamingService.getLocalContext().bind(name, object);
                WriteUtil.writeResponse(channel, this.getCommandId(), correlationId);
            }
            catch (NamingException e) {
                WriteUtil.writeExceptionResponse(channel, e, this.getCommandId(), correlationId);
            }
        }

        @Override
        public void handleClientMessage(DataInput input, int correlationId, RemoteNamingStore namingStore) throws IOException {
            this.readResult(correlationId, input, new BaseProtocolCommand.ValueReader<Object>(){

                @Override
                public void read(DataInput input, ProtocolIoFuture<Object> future) throws IOException {
                    future.setResult(null);
                }
            });
        }
    };
    static ProtocolCommand<Void> REBIND = new BaseProtocolCommand<Void>(3){

        @Override
        public Void execute(Channel channel, Object ... args) throws IOException, NamingException {
            if (args.length != 2 || !(args[0] instanceof Name)) {
                throw new IllegalArgumentException("Bind requires a name and object argument");
            }
            final Name name = (Name)Name.class.cast(args[0]);
            final Object object = args[1];
            ProtocolIoFuture future = new ProtocolIoFuture();
            final int correlationId = this.reserveNextCorrelationId(future);
            try {
                WriteUtil.write(channel, new WriteUtil.Writer(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(this.getCommandId());
                        output.writeInt(correlationId);
                        Marshaller marshaller = WriteUtil.prepareForMarshalling(output);
                        marshaller.writeByte(0);
                        marshaller.writeObject((Object)name);
                        marshaller.writeByte(1);
                        marshaller.writeObject(object);
                        marshaller.finish();
                    }
                });
                IoFuture.Status result = future.await(10L, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        if (future.getHeldException() != null) {
                            throw future.getHeldException();
                        }
                        throw future.getException();
                    }
                    case DONE: {
                        Void void_ = null;
                        return void_;
                    }
                }
                try {
                    throw new NamingException("Unable to invoke rebind, status=" + result.toString());
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ClientUtil.namingException("Failed to rebind", e);
                }
            }
            finally {
                this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void handleServerMessage(Channel channel, DataInput input, int correlationId, RemoteNamingService remoteNamingService) throws IOException {
            Object object;
            Name name;
            Unmarshaller unmarshaller = ReadUtil.prepareForUnMarshalling(input);
            try {
                byte paramType = unmarshaller.readByte();
                if (paramType != 0) {
                    remoteNamingService.getLogger().unexpectedParameterType((byte)0, paramType);
                }
                name = (Name)unmarshaller.readObject(Name.class);
                paramType = unmarshaller.readByte();
                if (paramType != 1) {
                    remoteNamingService.getLogger().unexpectedParameterType((byte)1, paramType);
                }
                object = unmarshaller.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            finally {
                unmarshaller.finish();
            }
            try {
                remoteNamingService.getLocalContext().rebind(name, object);
                WriteUtil.writeResponse(channel, this.getCommandId(), correlationId);
            }
            catch (NamingException e) {
                WriteUtil.writeExceptionResponse(channel, e, this.getCommandId(), correlationId);
            }
        }

        @Override
        public void handleClientMessage(DataInput input, int correlationId, RemoteNamingStore namingStore) throws IOException {
            this.readResult(correlationId, input, new BaseProtocolCommand.ValueReader<Object>(){

                @Override
                public void read(DataInput input, ProtocolIoFuture<Object> future) throws IOException {
                    future.setResult(null);
                }
            });
        }
    };
    static ProtocolCommand<List<NameClassPair>> LIST = new BaseProtocolCommand<List<NameClassPair>>(4){

        @Override
        public List<NameClassPair> execute(Channel channel, Object ... args) throws IOException, NamingException {
            if (args.length != 1 || !(args[0] instanceof Name)) {
                throw new IllegalArgumentException("List requires a name argument.");
            }
            final Name name = (Name)Name.class.cast(args[0]);
            ProtocolIoFuture future = new ProtocolIoFuture();
            final int correlationId = this.reserveNextCorrelationId(future);
            try {
                WriteUtil.write(channel, new WriteUtil.Writer(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(this.getCommandId());
                        output.writeInt(correlationId);
                        Marshaller marshaller = WriteUtil.prepareForMarshalling(output);
                        marshaller.writeByte(0);
                        marshaller.writeObject((Object)name);
                        marshaller.finish();
                    }
                });
                IoFuture.Status result = future.await(10L, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        if (future.getHeldException() != null) {
                            throw future.getHeldException();
                        }
                        throw future.getException();
                    }
                    case DONE: {
                        List list = (List)future.get();
                        return list;
                    }
                }
                try {
                    throw new NamingException("Unable to invoke list, status=" + result.toString());
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ClientUtil.namingException("Failed to list", e);
                }
            }
            finally {
                this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void handleServerMessage(Channel channel, DataInput input, final int correlationId, RemoteNamingService remoteNamingService) throws IOException {
            Name name;
            Unmarshaller unmarshaller = ReadUtil.prepareForUnMarshalling(input);
            try {
                byte paramType = unmarshaller.readByte();
                if (paramType != 0) {
                    remoteNamingService.getLogger().unexpectedParameterType((byte)0, paramType);
                }
                name = (Name)unmarshaller.readObject(Name.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            finally {
                unmarshaller.finish();
            }
            try {
                NamingEnumeration<NameClassPair> results = remoteNamingService.getLocalContext().list(name);
                final ArrayList<NameClassPair> resultList = new ArrayList<NameClassPair>();
                while (results.hasMore()) {
                    resultList.add(results.next());
                }
                WriteUtil.write(channel, new WriteUtil.Writer(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(this.getCommandId());
                        output.writeInt(correlationId);
                        output.writeByte(0);
                        output.writeByte(6);
                        output.writeInt(resultList.size());
                        Marshaller marshaller = WriteUtil.prepareForMarshalling(output);
                        for (NameClassPair nameClassPair : resultList) {
                            marshaller.writeObject((Object)nameClassPair);
                        }
                        marshaller.finish();
                    }
                });
            }
            catch (NamingException e) {
                WriteUtil.writeExceptionResponse(channel, e, this.getCommandId(), correlationId);
            }
        }

        @Override
        public void handleClientMessage(DataInput input, int correlationId, RemoteNamingStore namingStore) throws IOException {
            this.readResult(correlationId, input, new BaseProtocolCommand.ValueReader<Object>(){

                @Override
                public void read(DataInput input, ProtocolIoFuture<Object> future) throws IOException {
                    byte parameterType = input.readByte();
                    if (parameterType != 6) {
                        throw new IOException("Unexpected response parameter received.");
                    }
                    int listSize = input.readInt();
                    ArrayList<Object> results = new ArrayList<Object>(listSize);
                    Unmarshaller unmarshaller = ReadUtil.prepareForUnMarshalling(input);
                    for (int i = 0; i < listSize; ++i) {
                        try {
                            results.add(unmarshaller.readObject(NameClassPair.class));
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            throw new IOException(e);
                        }
                        catch (ClassCastException e) {
                            throw new IOException(e);
                        }
                    }
                    unmarshaller.finish();
                    future.setResult(results);
                }
            });
        }
    };
    static ProtocolCommand<List<Binding>> LIST_BINDINGS = new BaseProtocolCommand<List<Binding>>(5){

        @Override
        public List<Binding> execute(Channel channel, Object ... args) throws IOException, NamingException {
            if (args.length != 1 || !(args[0] instanceof Name)) {
                throw new IllegalArgumentException("List requires a name argument.");
            }
            final Name name = (Name)Name.class.cast(args[0]);
            NamedIoFuture future = new NamedIoFuture(name);
            final int correlationId = this.reserveNextCorrelationId(future);
            try {
                WriteUtil.write(channel, new WriteUtil.Writer(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(this.getCommandId());
                        output.writeInt(correlationId);
                        Marshaller marshaller = WriteUtil.prepareForMarshalling(output);
                        marshaller.writeByte(0);
                        marshaller.writeObject((Object)name);
                        marshaller.finish();
                    }
                });
                IoFuture.Status result = future.await(10L, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        if (future.getHeldException() != null) {
                            throw future.getHeldException();
                        }
                        throw future.getException();
                    }
                    case DONE: {
                        List list = (List)future.get();
                        return list;
                    }
                }
                try {
                    throw new NamingException("Unable to invoke listBindings, status=" + result.toString());
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ClientUtil.namingException("Failed to list bindings", e);
                }
            }
            finally {
                this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void handleServerMessage(Channel channel, DataInput input, final int correlationId, RemoteNamingService remoteNamingService) throws IOException {
            Name name;
            Unmarshaller unmarshaller = ReadUtil.prepareForUnMarshalling(input);
            try {
                byte paramType = unmarshaller.readByte();
                if (paramType != 0) {
                    remoteNamingService.getLogger().unexpectedParameterType((byte)0, paramType);
                }
                name = (Name)unmarshaller.readObject(Name.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            finally {
                unmarshaller.finish();
            }
            try {
                NamingEnumeration<Binding> results = remoteNamingService.getLocalContext().listBindings(name);
                final ArrayList<Binding> resultList = new ArrayList<Binding>();
                while (results.hasMore()) {
                    resultList.add(results.next());
                }
                WriteUtil.write(channel, new WriteUtil.Writer(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(this.getCommandId());
                        output.writeInt(correlationId);
                        output.writeByte(0);
                        output.writeByte(6);
                        output.writeInt(resultList.size());
                        Marshaller marshaller = WriteUtil.prepareForMarshalling(output);
                        for (Binding binding : resultList) {
                            if (binding.getObject() instanceof Context) {
                                marshaller.writeByte(5);
                                marshaller.writeUTF(binding.getName());
                                continue;
                            }
                            marshaller.writeByte(4);
                            marshaller.writeObject((Object)binding);
                        }
                        marshaller.finish();
                    }
                });
            }
            catch (NamingException e) {
                WriteUtil.writeExceptionResponse(channel, e, this.getCommandId(), correlationId);
            }
        }

        @Override
        public void handleClientMessage(DataInput input, int correlationId, final RemoteNamingStore namingStore) throws IOException {
            this.readResult(correlationId, input, new BaseProtocolCommand.ValueReader<Object>(){

                @Override
                public void read(DataInput input, ProtocolIoFuture<Object> future) throws IOException {
                    byte parameterType = input.readByte();
                    if (parameterType != 6) {
                        throw new IOException("Unexpected response parameter received.");
                    }
                    int listSize = input.readInt();
                    ArrayList<Binding> results = new ArrayList<Binding>(listSize);
                    Unmarshaller unmarshaller = ReadUtil.prepareForUnMarshalling(input);
                    block9: for (int i = 0; i < listSize; ++i) {
                        parameterType = unmarshaller.readByte();
                        switch (parameterType) {
                            case 4: {
                                try {
                                    Binding binding = (Binding)unmarshaller.readObject(Binding.class);
                                    results.add(binding);
                                    continue block9;
                                }
                                catch (ClassNotFoundException e) {
                                    throw new IOException(e);
                                }
                                catch (ClassCastException e) {
                                    throw new IOException(e);
                                }
                            }
                            case 5: {
                                Name contextName;
                                String bindingName = unmarshaller.readUTF();
                                try {
                                    contextName = ((Name)Name.class.cast(((NamedIoFuture)((Object)NamedIoFuture.class.cast(future))).name.clone())).add(bindingName);
                                }
                                catch (InvalidNameException e) {
                                    throw new IOException(e);
                                }
                                RemoteContext context = new RemoteContext(contextName, namingStore, new Hashtable<String, Object>());
                                results.add(new Binding(bindingName, Context.class.getName(), context));
                                continue block9;
                            }
                            default: {
                                throw new IOException("Unexpected response parameter received.");
                            }
                        }
                    }
                    unmarshaller.finish();
                    future.setResult(results);
                }
            });
        }
    };
    static ProtocolCommand<Void> UNBIND = new BaseProtocolCommand<Void>(6){

        @Override
        public Void execute(Channel channel, Object ... args) throws IOException, NamingException {
            if (args.length != 1 || !(args[0] instanceof Name)) {
                throw new IllegalArgumentException("Rebind requires a name");
            }
            final Name name = (Name)Name.class.cast(args[0]);
            ProtocolIoFuture future = new ProtocolIoFuture();
            final int correlationId = this.reserveNextCorrelationId(future);
            try {
                WriteUtil.write(channel, new WriteUtil.Writer(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(this.getCommandId());
                        output.writeInt(correlationId);
                        Marshaller marshaller = WriteUtil.prepareForMarshalling(output);
                        marshaller.writeByte(0);
                        marshaller.writeObject((Object)name);
                        marshaller.finish();
                    }
                });
                IoFuture.Status result = future.await(10L, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        if (future.getHeldException() != null) {
                            throw future.getHeldException();
                        }
                        throw future.getException();
                    }
                    case DONE: {
                        Void void_ = null;
                        return void_;
                    }
                }
                try {
                    throw new NamingException("Unable to invoke unbind, status=" + result.toString());
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ClientUtil.namingException("Failed to unbind", e);
                }
            }
            finally {
                this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void handleServerMessage(Channel channel, DataInput input, int correlationId, RemoteNamingService remoteNamingService) throws IOException {
            Name name;
            Unmarshaller unmarshaller = ReadUtil.prepareForUnMarshalling(input);
            try {
                byte paramType = unmarshaller.readByte();
                if (paramType != 0) {
                    remoteNamingService.getLogger().unexpectedParameterType((byte)0, paramType);
                }
                name = (Name)unmarshaller.readObject(Name.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            finally {
                unmarshaller.finish();
            }
            try {
                remoteNamingService.getLocalContext().unbind(name);
                WriteUtil.writeResponse(channel, this.getCommandId(), correlationId);
            }
            catch (NamingException e) {
                WriteUtil.writeExceptionResponse(channel, e, this.getCommandId(), correlationId);
            }
        }

        @Override
        public void handleClientMessage(DataInput input, int correlationId, RemoteNamingStore namingStore) throws IOException {
            this.readResult(correlationId, input, new BaseProtocolCommand.ValueReader<Object>(){

                @Override
                public void read(DataInput input, ProtocolIoFuture<Object> future) throws IOException {
                    future.setResult(null);
                }
            });
        }
    };
    static ProtocolCommand<Void> RENAME = new BaseProtocolCommand<Void>(7){

        @Override
        public Void execute(Channel channel, Object ... args) throws IOException, NamingException {
            if (args.length != 2 || !(args[0] instanceof Name) || !(args[0] instanceof Name)) {
                throw new IllegalArgumentException("Rename requires two name arguments");
            }
            final Name name = (Name)Name.class.cast(args[0]);
            final Name newName = (Name)Name.class.cast(args[1]);
            ProtocolIoFuture future = new ProtocolIoFuture();
            final int correlationId = this.reserveNextCorrelationId(future);
            try {
                WriteUtil.write(channel, new WriteUtil.Writer(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(this.getCommandId());
                        output.writeInt(correlationId);
                        Marshaller marshaller = WriteUtil.prepareForMarshalling(output);
                        marshaller.writeByte(0);
                        marshaller.writeObject((Object)name);
                        marshaller.writeByte(0);
                        marshaller.writeObject((Object)newName);
                        marshaller.finish();
                    }
                });
                IoFuture.Status result = future.await(10L, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        if (future.getHeldException() != null) {
                            throw future.getHeldException();
                        }
                        throw future.getException();
                    }
                    case DONE: {
                        Void void_ = null;
                        return void_;
                    }
                }
                try {
                    throw new NamingException("Unable to invoke rename, status=" + result.toString());
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ClientUtil.namingException("Failed to rename", e);
                }
            }
            finally {
                this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void handleServerMessage(Channel channel, DataInput input, int correlationId, RemoteNamingService remoteNamingService) throws IOException {
            Name newName;
            Name name;
            Unmarshaller unmarshaller = ReadUtil.prepareForUnMarshalling(input);
            try {
                byte paramType = unmarshaller.readByte();
                if (paramType != 0) {
                    remoteNamingService.getLogger().unexpectedParameterType((byte)0, paramType);
                }
                name = (Name)unmarshaller.readObject(Name.class);
                paramType = unmarshaller.readByte();
                if (paramType != 0) {
                    remoteNamingService.getLogger().unexpectedParameterType((byte)1, paramType);
                }
                newName = (Name)unmarshaller.readObject(Name.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            finally {
                unmarshaller.finish();
            }
            try {
                remoteNamingService.getLocalContext().rename(name, newName);
                WriteUtil.writeResponse(channel, this.getCommandId(), correlationId);
            }
            catch (NamingException e) {
                WriteUtil.writeExceptionResponse(channel, e, this.getCommandId(), correlationId);
            }
        }

        @Override
        public void handleClientMessage(DataInput input, int correlationId, RemoteNamingStore namingStore) throws IOException {
            this.readResult(correlationId, input, new BaseProtocolCommand.ValueReader<Object>(){

                @Override
                public void read(DataInput input, ProtocolIoFuture<Object> future) throws IOException {
                    future.setResult(null);
                }
            });
        }
    };
    static ProtocolCommand<Context> CREATE_SUBCONTEXT = new BaseProtocolCommand<Context>(8){

        @Override
        public Context execute(Channel channel, Object ... args) throws IOException, NamingException {
            if (args.length != 1 || !(args[0] instanceof Name)) {
                throw new IllegalArgumentException("Create subcontext requires a single name argument");
            }
            final Name name = (Name)Name.class.cast(args[0]);
            NamedIoFuture future = new NamedIoFuture(name);
            final int correlationId = this.reserveNextCorrelationId(future);
            try {
                WriteUtil.write(channel, new WriteUtil.Writer(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(this.getCommandId());
                        output.writeInt(correlationId);
                        Marshaller marshaller = WriteUtil.prepareForMarshalling(output);
                        marshaller.writeByte(0);
                        marshaller.writeObject((Object)name);
                        marshaller.finish();
                    }
                });
                IoFuture.Status result = future.await(10L, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        if (future.getHeldException() != null) {
                            throw future.getHeldException();
                        }
                        throw future.getException();
                    }
                    case DONE: {
                        Context context = (Context)future.get();
                        return context;
                    }
                }
                try {
                    throw new NamingException("Unable to invoke createSubcontext, status=" + result.toString());
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ClientUtil.namingException("Failed to create subcontext", e);
                }
            }
            finally {
                this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void handleServerMessage(Channel channel, DataInput input, final int correlationId, RemoteNamingService remoteNamingService) throws IOException {
            Name name;
            try {
                Unmarshaller unmarshaller = ReadUtil.prepareForUnMarshalling(input);
                byte paramType = unmarshaller.readByte();
                if (paramType != 0) {
                    remoteNamingService.getLogger().unexpectedParameterType((byte)0, paramType);
                }
                name = (Name)unmarshaller.readObject(Name.class);
                unmarshaller.finish();
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            try {
                remoteNamingService.getLocalContext().createSubcontext(name);
                WriteUtil.write(channel, new WriteUtil.Writer(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(this.getCommandId());
                        output.writeInt(correlationId);
                        output.writeByte(0);
                        output.writeByte(5);
                    }
                });
            }
            catch (NamingException e) {
                WriteUtil.writeExceptionResponse(channel, e, this.getCommandId(), correlationId);
            }
        }

        @Override
        public void handleClientMessage(DataInput input, int correlationId, final RemoteNamingStore namingStore) throws IOException {
            this.readResult(correlationId, input, new BaseProtocolCommand.ValueReader<Context>(){

                @Override
                public void read(DataInput input, ProtocolIoFuture<Context> future) throws IOException {
                    byte parameterType = input.readByte();
                    if (parameterType != 5) {
                        throw new IOException("Unexpected paramType");
                    }
                    future.setResult(new RemoteContext(((NamedIoFuture)((Object)NamedIoFuture.class.cast(future))).name, namingStore, new Hashtable<String, Object>()));
                }
            });
        }
    };
    static ProtocolCommand<Object> DESTROY_SUBCONTEXT = new BaseProtocolCommand<Object>(9){

        @Override
        public Context execute(Channel channel, Object ... args) throws IOException, NamingException {
            if (args.length != 1 || !(args[0] instanceof Name)) {
                throw new IllegalArgumentException("Destroy subcontext requires a single name argument");
            }
            final Name name = (Name)Name.class.cast(args[0]);
            NamedIoFuture future = new NamedIoFuture(name);
            final int correlationId = this.reserveNextCorrelationId(future);
            try {
                WriteUtil.write(channel, new WriteUtil.Writer(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(this.getCommandId());
                        output.writeInt(correlationId);
                        Marshaller marshaller = WriteUtil.prepareForMarshalling(output);
                        marshaller.writeByte(0);
                        marshaller.writeObject((Object)name);
                        marshaller.finish();
                    }
                });
                IoFuture.Status result = future.await(10L, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        if (future.getHeldException() != null) {
                            throw future.getHeldException();
                        }
                        throw future.getException();
                    }
                    case DONE: {
                        Context context = (Context)future.get();
                        return context;
                    }
                }
                try {
                    throw new NamingException("Unable to invoke destroySubcontext, status=" + result.toString());
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ClientUtil.namingException("Failed to destroy subcontext", e);
                }
            }
            finally {
                this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void handleServerMessage(Channel channel, DataInput input, int correlationId, RemoteNamingService remoteNamingService) throws IOException {
            Name name;
            try {
                Unmarshaller unmarshaller = ReadUtil.prepareForUnMarshalling(input);
                byte paramType = unmarshaller.readByte();
                if (paramType != 0) {
                    remoteNamingService.getLogger().unexpectedParameterType((byte)0, paramType);
                }
                name = (Name)unmarshaller.readObject(Name.class);
                unmarshaller.finish();
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            try {
                remoteNamingService.getLocalContext().destroySubcontext(name);
                WriteUtil.writeResponse(channel, this.getCommandId(), correlationId);
            }
            catch (NamingException e) {
                WriteUtil.writeExceptionResponse(channel, e, this.getCommandId(), correlationId);
            }
        }

        @Override
        public void handleClientMessage(DataInput input, int correlationId, RemoteNamingStore namingStore) throws IOException {
            this.readResult(correlationId, input, new BaseProtocolCommand.ValueReader<Object>(){

                @Override
                public void read(DataInput input, ProtocolIoFuture<Object> future) throws IOException {
                    future.setResult(null);
                }
            });
        }
    };
    static ProtocolCommand<Object> LOOKUP_LINK = new BaseProtocolCommand<Object>(16){

        @Override
        public Object execute(Channel channel, Object ... args) throws IOException, NamingException {
            if (args.length != 1 || !(args[0] instanceof Name)) {
                throw new IllegalArgumentException("Lookup link requires a single name argument");
            }
            final Name name = (Name)Name.class.cast(args[0]);
            NamedIoFuture future = new NamedIoFuture(name);
            final int correlationId = this.reserveNextCorrelationId(future);
            try {
                WriteUtil.write(channel, new WriteUtil.Writer(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(this.getCommandId());
                        output.writeInt(correlationId);
                        Marshaller marshaller = WriteUtil.prepareForMarshalling(output);
                        marshaller.writeByte(0);
                        marshaller.writeObject((Object)name);
                        marshaller.finish();
                    }
                });
                IoFuture.Status result = future.await(10L, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        if (future.getHeldException() != null) {
                            throw future.getHeldException();
                        }
                        throw future.getException();
                    }
                    case DONE: {
                        Object object = future.get();
                        return object;
                    }
                }
                try {
                    throw new NamingException("Unable to invoke lookupLink, status=" + result.toString());
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ClientUtil.namingException("Failed to lookup link", e);
                }
            }
            finally {
                this.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void handleServerMessage(Channel channel, DataInput input, final int correlationId, RemoteNamingService remoteNamingService) throws IOException {
            Name name;
            Unmarshaller unmarshaller = ReadUtil.prepareForUnMarshalling(input);
            try {
                byte paramType = unmarshaller.readByte();
                if (paramType != 0) {
                    remoteNamingService.getLogger().unexpectedParameterType((byte)0, paramType);
                }
                name = (Name)unmarshaller.readObject(Name.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            finally {
                unmarshaller.close();
            }
            try {
                final Object result = remoteNamingService.getLocalContext().lookupLink(name);
                WriteUtil.write(channel, new WriteUtil.Writer(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(this.getCommandId());
                        output.writeInt(correlationId);
                        output.writeByte(0);
                        if (result instanceof Context) {
                            output.writeByte(5);
                        } else {
                            output.writeByte(4);
                            Marshaller marshaller = WriteUtil.prepareForMarshalling(output);
                            marshaller.writeObject(result);
                            marshaller.finish();
                        }
                    }
                });
            }
            catch (NamingException e) {
                WriteUtil.writeExceptionResponse(channel, e, this.getCommandId(), correlationId);
            }
        }

        @Override
        public void handleClientMessage(DataInput input, int correlationId, final RemoteNamingStore namingStore) throws IOException {
            this.readResult(correlationId, input, new BaseProtocolCommand.ValueReader<Object>(){

                @Override
                public void read(DataInput input, ProtocolIoFuture<Object> future) throws IOException {
                    byte parameterType = input.readByte();
                    switch (parameterType) {
                        case 4: {
                            try {
                                Unmarshaller unmarshaller = ReadUtil.prepareForUnMarshalling(input);
                                future.setResult(unmarshaller.readObject());
                                unmarshaller.finish();
                                break;
                            }
                            catch (ClassNotFoundException e) {
                                throw new IOException(e);
                            }
                            catch (ClassCastException e) {
                                throw new IOException(e);
                            }
                        }
                        case 5: {
                            future.setResult(new RemoteContext(((NamedIoFuture)((Object)NamedIoFuture.class.cast(future))).name, namingStore, new Hashtable<String, Object>()));
                            break;
                        }
                        default: {
                            throw new IOException("Unexpected response parameter received.");
                        }
                    }
                }
            });
        }
    };
    private static final Map<Byte, ProtocolCommand> commands = new HashMap<Byte, ProtocolCommand>();

    Protocol() {
    }

    static void register(ProtocolCommand<?> command) {
        commands.put(command.getCommandId(), command);
    }

    public static ProtocolCommand forId(byte id) {
        return commands.get(id);
    }

    static {
        Protocol.register(LOOKUP);
        Protocol.register(BIND);
        Protocol.register(REBIND);
        Protocol.register(LIST);
        Protocol.register(LIST_BINDINGS);
        Protocol.register(UNBIND);
        Protocol.register(RENAME);
        Protocol.register(CREATE_SUBCONTEXT);
        Protocol.register(DESTROY_SUBCONTEXT);
        Protocol.register(LOOKUP_LINK);
    }

    private static class NamedIoFuture<T>
    extends ProtocolIoFuture<T> {
        private final Name name;

        private NamedIoFuture(Name name) {
            this.name = name;
        }
    }
}

