/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.threads.ScheduledThreadPoolAdd;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.ThreadsWriteAttributeOperationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class ScheduledThreadPoolWriteAttributeHandler
extends ThreadsWriteAttributeOperationHandler {
    public static final ScheduledThreadPoolWriteAttributeHandler INSTANCE = new ScheduledThreadPoolWriteAttributeHandler();

    private ScheduledThreadPoolWriteAttributeHandler() {
        super(ScheduledThreadPoolAdd.ATTRIBUTES, ScheduledThreadPoolAdd.RW_ATTRIBUTES);
    }

    @Override
    protected void applyOperation(OperationContext context, ModelNode operation, String attributeName, ServiceController<?> service) {
        throw new IllegalArgumentException("Unexpected attribute '" + attributeName + "'");
    }

    @Override
    protected ServiceController<?> getService(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
        ServiceName serviceName = ThreadsServices.executorName(name);
        ServiceController controller = context.getServiceRegistry(true).getService(serviceName);
        if (controller == null) {
            throw new OperationFailedException(new ModelNode().set("Service " + serviceName + " not found."));
        }
        return controller;
    }
}

