/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.interfaces.ParsedInterfaceCriteria;
import org.jboss.as.controller.operations.common.InterfaceAddHandler;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class SpecifiedInterfaceAddHandler
extends InterfaceAddHandler {
    public static SpecifiedInterfaceAddHandler INSTANCE = new SpecifiedInterfaceAddHandler();

    protected SpecifiedInterfaceAddHandler() {
        super(true);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getProcessType().isServer();
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, String name, ParsedInterfaceCriteria criteria) {
        ServiceTarget target = context.getServiceTarget();
        ServiceBuilder builder = target.addService(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{name}), SpecifiedInterfaceAddHandler.createInterfaceService(name, criteria));
        newControllers.add(builder.setInitialMode(ServiceController.Mode.ON_DEMAND).install());
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }

    public static Service<NetworkInterfaceBinding> createInterfaceService(String name, ParsedInterfaceCriteria criteria) {
        return NetworkInterfaceService.create(name, criteria);
    }
}

