/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.io.IOException;
import java.util.List;
import java.util.jar.Manifest;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.module.IgnoreMetaInfMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class ManifestAttachmentProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        List<ResourceRoot> resourceRoots = DeploymentUtils.allResourceRoots(deploymentUnit);
        for (ResourceRoot resourceRoot : resourceRoots) {
            Manifest manifest;
            if (IgnoreMetaInfMarker.isIgnoreMetaInf(resourceRoot) || (manifest = resourceRoot.getAttachment(Attachments.MANIFEST)) != null) continue;
            VirtualFile deploymentRoot = resourceRoot.getRoot();
            try {
                manifest = VFSUtils.getManifest((VirtualFile)deploymentRoot);
                if (manifest == null) continue;
                resourceRoot.putAttachment(Attachments.MANIFEST, manifest);
            }
            catch (IOException e) {
                throw new DeploymentUnitProcessingException("Failed to get manifest for deployment " + deploymentRoot, e);
            }
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
        List<ResourceRoot> resourceRoots = DeploymentUtils.allResourceRoots(context);
        for (ResourceRoot resourceRoot : resourceRoots) {
            resourceRoot.removeAttachment(Attachments.MANIFEST);
        }
    }
}

