/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.ejb.client.remoting.IoFutureHelper;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

class RemotingConnectionHandler {
    private final Endpoint endpoint;
    private final URI connectionURI;
    private final OptionMap connectionCreationOptions;
    private final CallbackHandler callbackHandler;

    RemotingConnectionHandler(Endpoint endpoint, URI uri, OptionMap connectionCreationOptions, CallbackHandler callbackHandler) {
        this.endpoint = endpoint;
        this.connectionURI = uri;
        this.connectionCreationOptions = connectionCreationOptions == null ? OptionMap.EMPTY : connectionCreationOptions;
        this.callbackHandler = callbackHandler;
    }

    Connection createConnection(long connectionTimeout, TimeUnit unit) throws IOException {
        IoFuture<Connection> futureConnection = this.endpoint.connect(this.connectionURI, this.connectionCreationOptions, this.callbackHandler);
        return IoFutureHelper.get(futureConnection, connectionTimeout, unit);
    }

    URI getConnectionURI() {
        return this.connectionURI;
    }
}

