/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.remoting.MaxAttemptsReconnectHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.OptionMap;

class EJBClientContextConnectionReconnectHandler
extends MaxAttemptsReconnectHandler {
    private final EJBClientContext ejbClientContext;

    EJBClientContextConnectionReconnectHandler(EJBClientContext clientContext, Endpoint endpoint, URI uri, OptionMap connectionCreationOptions, CallbackHandler callbackHandler, OptionMap channelCreationOptions, int maxReconnectAttempts) {
        super(endpoint, uri, connectionCreationOptions, callbackHandler, channelCreationOptions, maxReconnectAttempts);
        this.ejbClientContext = clientContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect() throws IOException {
        Connection connection = null;
        try {
            connection = this.tryConnect(5000L, TimeUnit.SECONDS);
            if (connection == null) {
                return;
            }
            RemotingConnectionEJBReceiver ejbReceiver = new RemotingConnectionEJBReceiver(connection, this, this.channelCreationOptions);
            this.ejbClientContext.registerEJBReceiver(ejbReceiver);
        }
        finally {
            if (connection != null || !this.hasMoreAttempts()) {
                this.ejbClientContext.unregisterReconnectHandler(this);
            }
        }
    }
}

