/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.version.impl;

import java.io.Serializable;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.version.Version;

public class VersionImpl
implements Version,
Serializable {
    private static final long serialVersionUID = -5271227256591080403L;
    private static final Logger log = Logger.getLogger(VersionImpl.class);
    private final String versionName;
    private final int majorVersion;
    private final int minorVersion;
    private final int microVersion;
    private final int incrementingVersion;
    private final String versionSuffix;
    private final String nettyVersion;
    private final int[] compatibleVersionList;

    public VersionImpl(String versionName, int majorVersion, int minorVersion, int microVersion, int incrementingVersion, String versionSuffix, String nettyVersion, int[] compatibleVersionList) {
        this.versionName = versionName;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.microVersion = microVersion;
        this.incrementingVersion = incrementingVersion;
        this.versionSuffix = versionSuffix;
        this.nettyVersion = nettyVersion;
        this.compatibleVersionList = compatibleVersionList;
    }

    public String getFullVersion() {
        return this.majorVersion + "." + this.minorVersion + "." + this.microVersion + "." + this.versionSuffix + " (" + this.versionName + ", " + this.incrementingVersion + ")";
    }

    public String getVersionName() {
        return this.versionName;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMicroVersion() {
        return this.microVersion;
    }

    public String getVersionSuffix() {
        return this.versionSuffix;
    }

    public int getIncrementingVersion() {
        return this.incrementingVersion;
    }

    public String getNettyVersion() {
        return this.nettyVersion;
    }

    public int[] getCompatibleVersionList() {
        return this.compatibleVersionList;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        Version v = (Version)other;
        return this.versionName.equals(v.getVersionName()) && this.majorVersion == v.getMajorVersion() && this.minorVersion == v.getMinorVersion() && this.microVersion == v.getMicroVersion() && this.versionSuffix.equals(v.getVersionSuffix()) && this.incrementingVersion == v.getIncrementingVersion();
    }
}

