/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.netty;

import java.util.Set;
import java.util.concurrent.Semaphore;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.core.buffers.impl.ChannelBufferWrapper;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.security.HornetQPrincipal;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.spi.core.remoting.ReadyListener;
import org.hornetq.utils.ConcurrentHashSet;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.handler.ssl.SslHandler;

public class NettyConnection
implements Connection {
    private static final Logger log = Logger.getLogger(NettyConnection.class);
    private static final int BATCHING_BUFFER_SIZE = 8192;
    private final Channel channel;
    private boolean closed;
    private final ConnectionLifeCycleListener listener;
    private final boolean batchingEnabled;
    private final boolean directDeliver;
    private volatile HornetQBuffer batchBuffer;
    private final Semaphore writeLock = new Semaphore(1);
    private final Set<ReadyListener> readyListeners = new ConcurrentHashSet<ReadyListener>();

    public NettyConnection(Channel channel, ConnectionLifeCycleListener listener, boolean batchingEnabled, boolean directDeliver) {
        this(null, channel, listener, batchingEnabled, directDeliver);
    }

    public NettyConnection(Acceptor acceptor, Channel channel, ConnectionLifeCycleListener listener, boolean batchingEnabled, boolean directDeliver) {
        this.channel = channel;
        this.listener = listener;
        this.batchingEnabled = batchingEnabled;
        this.directDeliver = directDeliver;
        listener.connectionCreated(acceptor, this, ProtocolType.CORE);
    }

    public synchronized void close() {
        ChannelFuture closeFuture;
        if (this.closed) {
            return;
        }
        SslHandler sslHandler = (SslHandler)this.channel.getPipeline().get("ssl");
        if (sslHandler != null) {
            try {
                ChannelFuture sslCloseFuture = sslHandler.close();
                if (!sslCloseFuture.awaitUninterruptibly(10000L)) {
                    log.warn("Timed out waiting for ssl close future to complete");
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (!(closeFuture = this.channel.close()).awaitUninterruptibly(10000L)) {
            log.warn("Timed out waiting for channel to close");
        }
        this.closed = true;
        this.listener.connectionDestroyed(this.getID());
    }

    public HornetQBuffer createBuffer(int size) {
        return new ChannelBufferWrapper(ChannelBuffers.dynamicBuffer(size));
    }

    public Object getID() {
        return this.channel.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFlushBatchBuffer() {
        if (!this.batchingEnabled) {
            return;
        }
        if (this.writeLock.tryAcquire()) {
            try {
                if (this.batchBuffer != null && this.batchBuffer.readable()) {
                    this.channel.write(this.batchBuffer.channelBuffer());
                    this.batchBuffer = HornetQBuffers.dynamicBuffer(8192);
                }
            }
            finally {
                this.writeLock.release();
            }
        }
    }

    public void write(HornetQBuffer buffer) {
        this.write(buffer, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(HornetQBuffer buffer, boolean flush, boolean batched) {
        block13: {
            try {
                this.writeLock.acquire();
                try {
                    if (this.batchBuffer == null && this.batchingEnabled && batched && !flush) {
                        this.batchBuffer = HornetQBuffers.dynamicBuffer(8192);
                    }
                    if (this.batchBuffer != null) {
                        this.batchBuffer.writeBytes(buffer, 0, buffer.writerIndex());
                        if (this.batchBuffer.writerIndex() < 8192 && batched && !flush) {
                            return;
                        }
                        buffer = this.batchBuffer;
                        this.batchBuffer = !batched || flush ? null : HornetQBuffers.dynamicBuffer(8192);
                    }
                    ChannelFuture future = this.channel.write(buffer.channelBuffer());
                    if (!flush) break block13;
                    while (true) {
                        try {
                            boolean ok = future.await(10000L);
                            if (!ok) {
                                log.warn("Timed out waiting for packet to be flushed");
                            }
                        }
                        catch (InterruptedException ignore) {
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    this.writeLock.release();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public String getRemoteAddress() {
        return this.channel.getRemoteAddress().toString();
    }

    public boolean isDirectDeliver() {
        return this.directDeliver;
    }

    public void addReadyListener(ReadyListener listener) {
        this.readyListeners.add(listener);
    }

    public void removeReadyListener(ReadyListener listener) {
        this.readyListeners.remove(listener);
    }

    public HornetQPrincipal getDefaultHornetQPrincipal() {
        return null;
    }

    public void fireReady(boolean ready) {
        for (ReadyListener listener : this.readyListeners) {
            listener.readyForWriting(ready);
        }
    }

    public String toString() {
        return super.toString() + "[local= " + this.channel.getLocalAddress() + ", remote=" + this.channel.getRemoteAddress() + "]";
    }
}

