/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.util.reflection.HierarchyDiscovery;

public class Observers {
    public static void checkEventObjectType(Type eventType) {
        Type[] types;
        Type resolvedType = new HierarchyDiscovery(eventType).getResolvedType();
        if (resolvedType instanceof Class) {
            types = new Type[]{};
        } else if (resolvedType instanceof ParameterizedType) {
            types = ((ParameterizedType)resolvedType).getActualTypeArguments();
        } else {
            throw new IllegalArgumentException(UtilMessage.EVENT_TYPE_NOT_ALLOWED, resolvedType);
        }
        for (Type type : types) {
            if (!(type instanceof TypeVariable)) continue;
            throw new IllegalArgumentException(UtilMessage.TYPE_PARAMETER_NOT_ALLOWED_IN_EVENT_TYPE, resolvedType);
        }
    }

    public static void checkEventObjectType(Object event) {
        Observers.checkEventObjectType(event.getClass());
    }
}

