/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.auth;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.auth.AbstractSTSLoginModule;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STSIssuingLoginModule
extends AbstractSTSLoginModule {
    public static final String ENDPOINT_OPTION = "endpointURI";
    public static final String TOKEN_TYPE_OPTION = "tokenType";
    private String endpointURI;
    private String tokenType;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.endpointURI = (String)options.get(ENDPOINT_OPTION);
        if (this.endpointURI == null) {
            this.endpointURI = (String)options.get("endpointAddress");
        }
        this.tokenType = (String)options.get(TOKEN_TYPE_OPTION);
        if (this.tokenType == null) {
            this.tokenType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0";
        }
    }

    @Override
    public Element invokeSTS(STSClient stsClient) throws WSTrustException {
        return stsClient.issueToken(this.endpointURI, this.tokenType);
    }
}

