/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.providers;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.interfaces.SecurityTokenProvider;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLProtocolContext;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.exceptions.IssueInstantMissingException;
import org.picketlink.identity.federation.core.saml.v2.factories.SAMLAssertionFactory;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.sts.AbstractSecurityTokenProvider;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionsType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML20AssertionTokenProvider
extends AbstractSecurityTokenProvider
implements SecurityTokenProvider {
    public static final String NS = JBossSAMLURIConstants.ASSERTION_NSURI.get();
    private long ASSERTION_VALIDITY = 5000L;
    private long CLOCK_SKEW = 2000L;

    @Override
    public void initialize(Map<String, String> props) {
        String skew;
        super.initialize(props);
        String validity = (String)this.properties.get("ASSERTION_VALIDITY");
        if (validity != null) {
            this.ASSERTION_VALIDITY = Long.parseLong(validity);
        }
        if ((skew = (String)this.properties.get("CLOCK_SKEW")) != null) {
            this.CLOCK_SKEW = Long.parseLong(skew);
        }
    }

    @Override
    public boolean supports(String namespace) {
        return NS.equals(namespace);
    }

    @Override
    public void issueToken(ProtocolContext context) throws ProcessingException {
        XMLGregorianCalendar issueInstant;
        if (!(context instanceof SAMLProtocolContext)) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        SAMLProtocolContext samlProtocolContext = (SAMLProtocolContext)context;
        NameIDType issuerID = samlProtocolContext.getIssuerID();
        try {
            issueInstant = XMLTimeUtil.getIssueInstant();
        }
        catch (ConfigurationException e) {
            throw new ProcessingException(e);
        }
        ConditionsType conditions = samlProtocolContext.getConditions();
        SubjectType subject = samlProtocolContext.getSubjectType();
        List<StatementAbstractType> statements = samlProtocolContext.getStatements();
        String assertionID = IDGenerator.create("ID_");
        AssertionType assertionType = SAMLAssertionFactory.createAssertion(assertionID, issuerID, issueInstant, conditions, subject, statements);
        try {
            AssertionUtil.createTimedConditions(assertionType, this.ASSERTION_VALIDITY, this.CLOCK_SKEW);
        }
        catch (ConfigurationException e) {
            throw new ProcessingException(e);
        }
        catch (IssueInstantMissingException e) {
            throw new ProcessingException(e);
        }
        try {
            this.tokenRegistry.addToken(assertionID, assertionType);
        }
        catch (IOException e) {
            throw new ProcessingException(e);
        }
        samlProtocolContext.setIssuedAssertion(assertionType);
    }

    @Override
    public void renewToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof SAMLProtocolContext)) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        SAMLProtocolContext samlProtocolContext = (SAMLProtocolContext)context;
        AssertionType issuedAssertion = samlProtocolContext.getIssuedAssertion();
        try {
            XMLGregorianCalendar currentTime = XMLTimeUtil.getIssueInstant();
            issuedAssertion.updateIssueInstant(currentTime);
        }
        catch (ConfigurationException e) {
            throw new ProcessingException(e);
        }
        try {
            AssertionUtil.createTimedConditions(issuedAssertion, this.ASSERTION_VALIDITY, this.CLOCK_SKEW);
        }
        catch (ConfigurationException e) {
            throw new ProcessingException(e);
        }
        catch (IssueInstantMissingException e) {
            throw new ProcessingException(e);
        }
        try {
            this.tokenRegistry.addToken(issuedAssertion.getID(), issuedAssertion);
        }
        catch (IOException e) {
            throw new ProcessingException(e);
        }
        samlProtocolContext.setIssuedAssertion(issuedAssertion);
    }

    @Override
    public void cancelToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof SAMLProtocolContext)) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        SAMLProtocolContext samlProtocolContext = (SAMLProtocolContext)context;
        AssertionType issuedAssertion = samlProtocolContext.getIssuedAssertion();
        try {
            this.tokenRegistry.removeToken(issuedAssertion.getID());
        }
        catch (IOException e) {
            throw new ProcessingException(e);
        }
    }

    @Override
    public void validateToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof SAMLProtocolContext)) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        SAMLProtocolContext samlProtocolContext = (SAMLProtocolContext)context;
        AssertionType issuedAssertion = samlProtocolContext.getIssuedAssertion();
        try {
            if (!AssertionUtil.hasExpired(issuedAssertion)) {
                throw new ProcessingException("PL00079: Assertion has expired:");
            }
        }
        catch (ConfigurationException e) {
            throw new ProcessingException(e);
        }
        if (issuedAssertion == null) {
            throw new ProcessingException("PL00054: Assertion is null");
        }
        if (this.tokenRegistry.getToken(issuedAssertion.getID()) == null) {
            throw new ProcessingException("PL00080: Invalid Assertion:");
        }
    }

    @Override
    public String tokenType() {
        return NS;
    }

    @Override
    public QName getSupportedQName() {
        return new QName(NS, JBossSAMLConstants.ASSERTION.get());
    }

    @Override
    public String family() {
        return SecurityTokenProvider.FAMILY_TYPE.SAML2.toString();
    }
}

