/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import java.net.URI;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.protocol.StatusCodeType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusType;

public abstract class SAMLStatusResponseTypeParser {
    protected StatusResponseType parseBaseAttributes(StartElement startElement) throws ParsingException {
        Attribute inResponseTo;
        Attribute consent;
        Attribute idAttr = startElement.getAttributeByName(new QName(JBossSAMLConstants.ID.get()));
        if (idAttr == null) {
            throw new RuntimeException("PL00063: Parser: Required attribute missing: ID");
        }
        String id = StaxParserUtil.getAttributeValue(idAttr);
        Attribute version = startElement.getAttributeByName(new QName(JBossSAMLConstants.VERSION.get()));
        if (version == null) {
            throw new RuntimeException("PL00063: Parser: Required attribute missing: Version");
        }
        StringUtil.match(JBossSAMLConstants.VERSION_2_0.get(), StaxParserUtil.getAttributeValue(version));
        Attribute issueInstant = startElement.getAttributeByName(new QName(JBossSAMLConstants.ISSUE_INSTANT.get()));
        if (issueInstant == null) {
            throw new RuntimeException("PL00063: Parser: Required attribute missing: IssueInstant");
        }
        XMLGregorianCalendar issueInstantVal = XMLTimeUtil.parse(StaxParserUtil.getAttributeValue(issueInstant));
        StatusResponseType response = new StatusResponseType(id, issueInstantVal);
        Attribute destination = startElement.getAttributeByName(new QName(JBossSAMLConstants.DESTINATION.get()));
        if (destination != null) {
            response.setDestination(StaxParserUtil.getAttributeValue(destination));
        }
        if ((consent = startElement.getAttributeByName(new QName(JBossSAMLConstants.CONSENT.get()))) != null) {
            response.setConsent(StaxParserUtil.getAttributeValue(consent));
        }
        if ((inResponseTo = startElement.getAttributeByName(new QName(JBossSAMLConstants.IN_RESPONSE_TO.get()))) != null) {
            response.setInResponseTo(StaxParserUtil.getAttributeValue(inResponseTo));
        }
        return response;
    }

    protected StatusType parseStatus(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        String STATUS = JBossSAMLConstants.STATUS.get();
        StaxParserUtil.validate(startElement, STATUS);
        StatusType status = new StatusType();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent;
            EndElement endElement;
            startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (startElement == null) break;
            QName startElementName = startElement.getName();
            String elementTag = startElementName.getLocalPart();
            StatusCodeType statusCode = new StatusCodeType();
            if (JBossSAMLConstants.STATUS_CODE.get().equals(elementTag)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                if (startElement == null) break;
                Attribute valueAttr = startElement.getAttributeByName(new QName("Value"));
                if (valueAttr != null) {
                    statusCode.setValue(URI.create(StaxParserUtil.getAttributeValue(valueAttr)));
                }
                status.setStatusCode(statusCode);
                startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
                if (startElement == null) {
                    endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    StaxParserUtil.validate(endElement, JBossSAMLConstants.STATUS_CODE.get());
                    continue;
                }
                elementTag = startElement.getName().getLocalPart();
                if (JBossSAMLConstants.STATUS_CODE.get().equals(elementTag)) {
                    StatusCodeType subStatusCodeType = new StatusCodeType();
                    startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                    Attribute subValueAttr = startElement.getAttributeByName(new QName("Value"));
                    if (subValueAttr != null) {
                        subStatusCodeType.setValue(URI.create(StaxParserUtil.getAttributeValue(subValueAttr)));
                    }
                    statusCode.setStatusCode(subStatusCodeType);
                    EndElement endElement2 = StaxParserUtil.getNextEndElement(xmlEventReader);
                    StaxParserUtil.validate(endElement2, JBossSAMLConstants.STATUS_CODE.get());
                    continue;
                }
            }
            if (!((xmlEvent = StaxParserUtil.peek(xmlEventReader)) instanceof EndElement) || StaxParserUtil.matches(endElement = StaxParserUtil.getNextEndElement(xmlEventReader), STATUS)) break;
            throw new RuntimeException("PL00061: Parser: Unknown End Element:" + StaxParserUtil.getEndElementName(endElement));
        }
        return status;
    }
}

