/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.api.saml.v2.request;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import javax.xml.datatype.XMLGregorianCalendar;
import org.picketlink.identity.federation.api.saml.v2.request.SecurityActions;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLRequestWriter;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLResponseWriter;
import org.picketlink.identity.federation.core.util.JAXPValidationUtil;
import org.picketlink.identity.federation.core.util.StaxUtil;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.NameIDPolicyType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.w3c.dom.Document;

public class SAML2Request {
    private SAMLDocumentHolder samlDocumentHolder = null;
    private String nameIDFormat = JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get();

    public void setNameIDFormat(String nameIDFormat) {
        this.nameIDFormat = nameIDFormat;
    }

    public AuthnRequestType createAuthnRequestType(String id, String assertionConsumerURL, String destination, String issuerValue) throws ConfigurationException {
        XMLGregorianCalendar issueInstant = XMLTimeUtil.getIssueInstant();
        AuthnRequestType authnRequest = new AuthnRequestType(id, issueInstant);
        authnRequest.setAssertionConsumerServiceURL(URI.create(assertionConsumerURL));
        authnRequest.setProtocolBinding(URI.create(JBossSAMLConstants.HTTP_POST_BINDING.get()));
        if (destination != null) {
            authnRequest.setDestination(URI.create(destination));
        }
        NameIDType issuer = new NameIDType();
        issuer.setValue(issuerValue);
        authnRequest.setIssuer(issuer);
        NameIDPolicyType nameIDPolicy = new NameIDPolicyType();
        nameIDPolicy.setAllowCreate(Boolean.TRUE);
        nameIDPolicy.setFormat(URI.create(this.nameIDFormat));
        authnRequest.setNameIDPolicy(nameIDPolicy);
        return authnRequest;
    }

    public AuthnRequestType getAuthnRequestType(String fileName) throws ConfigurationException, ProcessingException, ParsingException {
        if (fileName == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:fileName");
        }
        URL resourceURL = SecurityActions.loadResource(this.getClass(), fileName);
        if (resourceURL == null) {
            throw new ProcessingException("PL00018: Resource not found:" + fileName + " could not be loaded");
        }
        InputStream is = null;
        try {
            is = resourceURL.openStream();
        }
        catch (IOException e) {
            throw new ProcessingException(e);
        }
        return this.getAuthnRequestType(is);
    }

    public SAML2Object getSAML2ObjectFromStream(InputStream is) throws ConfigurationException, ParsingException, ProcessingException {
        if (is == null) {
            throw new IllegalStateException("PL00078: Null Parameter:InputStream");
        }
        Document samlDocument = DocumentUtil.getDocument(is);
        SAMLParser samlParser = new SAMLParser();
        JAXPValidationUtil.checkSchemaValidation(samlDocument);
        SAML2Object requestType = (SAML2Object)samlParser.parse(DocumentUtil.getNodeAsStream(samlDocument));
        this.samlDocumentHolder = new SAMLDocumentHolder(requestType, samlDocument);
        return requestType;
    }

    public RequestAbstractType getRequestType(InputStream is) throws ParsingException, ConfigurationException, ProcessingException {
        if (is == null) {
            throw new IllegalStateException("PL00078: Null Parameter:InputStream");
        }
        Document samlDocument = DocumentUtil.getDocument(is);
        SAMLParser samlParser = new SAMLParser();
        JAXPValidationUtil.checkSchemaValidation(samlDocument);
        RequestAbstractType requestType = (RequestAbstractType)samlParser.parse(DocumentUtil.getNodeAsStream(samlDocument));
        this.samlDocumentHolder = new SAMLDocumentHolder(requestType, samlDocument);
        return requestType;
    }

    public AuthnRequestType getAuthnRequestType(InputStream is) throws ConfigurationException, ProcessingException, ParsingException {
        if (is == null) {
            throw new IllegalStateException("PL00078: Null Parameter:InputStream");
        }
        Document samlDocument = DocumentUtil.getDocument(is);
        SAMLParser samlParser = new SAMLParser();
        JAXPValidationUtil.checkSchemaValidation(samlDocument);
        AuthnRequestType requestType = (AuthnRequestType)samlParser.parse(DocumentUtil.getNodeAsStream(samlDocument));
        this.samlDocumentHolder = new SAMLDocumentHolder(requestType, samlDocument);
        return requestType;
    }

    public SAMLDocumentHolder getSamlDocumentHolder() {
        return this.samlDocumentHolder;
    }

    public LogoutRequestType createLogoutRequest(String issuer) throws ConfigurationException {
        LogoutRequestType lrt = new LogoutRequestType(IDGenerator.create("ID_"), XMLTimeUtil.getIssueInstant());
        NameIDType issuerNameID = new NameIDType();
        issuerNameID.setValue(issuer);
        lrt.setIssuer(issuerNameID);
        return lrt;
    }

    public Document convert(RequestAbstractType rat) throws ProcessingException, ConfigurationException, ParsingException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SAMLRequestWriter writer = new SAMLRequestWriter(StaxUtil.getXMLStreamWriter(bos));
        if (rat instanceof AuthnRequestType) {
            writer.write((AuthnRequestType)rat);
        } else if (rat instanceof LogoutRequestType) {
            writer.write((LogoutRequestType)rat);
        }
        return DocumentUtil.getDocument(new String(bos.toByteArray()));
    }

    public Document convert(ResponseType responseType) throws ProcessingException, ParsingException, ConfigurationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SAMLResponseWriter writer = new SAMLResponseWriter(StaxUtil.getXMLStreamWriter(baos));
        writer.write(responseType);
        ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
        return DocumentUtil.getDocument(bis);
    }

    public void marshall(RequestAbstractType requestType, OutputStream os) throws ProcessingException {
        SAMLRequestWriter samlRequestWriter = new SAMLRequestWriter(StaxUtil.getXMLStreamWriter(os));
        if (requestType instanceof AuthnRequestType) {
            samlRequestWriter.write((AuthnRequestType)requestType);
        } else if (requestType instanceof LogoutRequestType) {
            samlRequestWriter.write((LogoutRequestType)requestType);
        } else {
            throw new RuntimeException("PL00069: Parser: Type not supported:" + requestType.getClass().getName());
        }
    }

    public void marshall(RequestAbstractType requestType, Writer writer) throws ProcessingException {
        SAMLRequestWriter samlRequestWriter = new SAMLRequestWriter(StaxUtil.getXMLStreamWriter(writer));
        if (requestType instanceof AuthnRequestType) {
            samlRequestWriter.write((AuthnRequestType)requestType);
        } else if (requestType instanceof LogoutRequestType) {
            samlRequestWriter.write((LogoutRequestType)requestType);
        } else {
            throw new RuntimeException("PL00069: Parser: Type not supported:" + requestType.getClass().getName());
        }
    }
}

