/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.management;

import java.util.ResourceBundle;
import javax.management.JMException;
import javax.management.MBeanServer;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.management.DefaultEndpointRegistry;
import org.jboss.ws.common.management.ManagedEndpoint;
import org.jboss.ws.common.management.ManagedEndpointRegistryMBean;
import org.jboss.wsf.spi.deployment.Endpoint;

public class ManagedEndpointRegistry
extends DefaultEndpointRegistry
implements ManagedEndpointRegistryMBean {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ManagedEndpointRegistry.class);
    private static final Logger log = Logger.getLogger(ManagedEndpointRegistry.class);
    private MBeanServer mbeanServer;

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    @Override
    public void register(Endpoint endpoint) {
        super.register(endpoint);
        try {
            ManagedEndpoint jmxEndpoint = new ManagedEndpoint(endpoint, this.mbeanServer);
            this.getMbeanServer().registerMBean(jmxEndpoint, endpoint.getName());
        }
        catch (Exception ex) {
            log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_REGISTER_ENDPOINT_WITH_JMX_SERVER", (Object[])new Object[0]), (Throwable)ex);
        }
    }

    @Override
    public void unregister(Endpoint endpoint) {
        super.unregister(endpoint);
        try {
            if (this.getMbeanServer() != null) {
                this.getMbeanServer().unregisterMBean(endpoint.getName());
            } else {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"MBEANSERVER_NOT_AVAILABLE", (Object[])new Object[0]));
            }
        }
        catch (JMException ex) {
            log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_UNREGISTER_ENDPOINT_WITH_JMX_SERVER", (Object[])new Object[0]), (Throwable)ex);
        }
    }

    public void create() throws Exception {
        if (this.mbeanServer != null) {
            this.getMbeanServer().registerMBean(this, OBJECT_NAME);
        }
    }

    public void destroy() throws Exception {
        log.debug((Object)"Destroy service endpoint manager");
        if (this.mbeanServer != null) {
            this.getMbeanServer().unregisterMBean(OBJECT_NAME);
        }
    }
}

