/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import org.hornetq.core.config.impl.Validators;
import org.hornetq.utils.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLConfigurationUtil {
    public static Double getDouble(Element e, String name, double def, Validators.Validator validator) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            double val = XMLUtil.parseDouble(nl.item(0));
            validator.validate(name, val);
            return val;
        }
        validator.validate(name, def);
        return def;
    }

    public static String getString(Element e, String name, String def, Validators.Validator validator) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            String val = nl.item(0).getTextContent().trim();
            validator.validate(name, val);
            return val;
        }
        validator.validate(name, def);
        return def;
    }

    public static Long getLong(Element e, String name, long def, Validators.Validator validator) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            long val = XMLUtil.parseLong(nl.item(0));
            validator.validate(name, val);
            return val;
        }
        validator.validate(name, def);
        return def;
    }

    public static Integer getInteger(Element e, String name, int def, Validators.Validator validator) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            int val = XMLUtil.parseInt(nl.item(0));
            validator.validate(name, val);
            return val;
        }
        validator.validate(name, def);
        return def;
    }

    public static Boolean getBoolean(Element e, String name, boolean def) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            return XMLUtil.parseBoolean(nl.item(0));
        }
        return def;
    }
}

