/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor.transform;

import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.interceptor.StaxOutEndingInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.transform.TransformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final String OUTPUT_STREAM_HOLDER = TransformOutInterceptor.class.getName() + ".outputstream";
    private static final StaxOutEndingInterceptor ENDING = new StaxOutEndingInterceptor(OUTPUT_STREAM_HOLDER);
    private Map<String, String> outElementsMap;
    private Map<String, String> outAppendMap;
    private List<String> outDropElements;
    private boolean attributesToElements;
    private String contextPropertyName;
    private String defaultNamespace;

    public TransformOutInterceptor() {
        this("pre-stream");
    }

    public TransformOutInterceptor(String phase) {
        super(phase);
        this.addBefore(StaxOutInterceptor.class.getName());
        this.addAfter(LoggingOutInterceptor.class.getName());
    }

    public void handleFault(Message message) {
        super.handleFault(message);
        OutputStream os = (OutputStream)message.get((Object)OUTPUT_STREAM_HOLDER);
        if (os != null) {
            message.setContent(OutputStream.class, (Object)os);
        }
    }

    public void handleMessage(Message message) {
        OutputStream out;
        if (!this.isHttpVerbSupported(message)) {
            return;
        }
        if (this.contextPropertyName != null && !MessageUtils.getContextualBoolean((Message)message.getExchange().getInMessage(), (String)this.contextPropertyName, (boolean)false)) {
            return;
        }
        if (null != message.getContent(Exception.class)) {
            return;
        }
        XMLStreamWriter writer = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
        XMLStreamWriter transformWriter = this.createTransformWriterIfNeeded(writer, out = (OutputStream)message.getContent(OutputStream.class));
        if (transformWriter != null) {
            message.setContent(XMLStreamWriter.class, (Object)transformWriter);
            if (MessageUtils.isRequestor((Message)message)) {
                message.removeContent(OutputStream.class);
                message.put((Object)OUTPUT_STREAM_HOLDER, (Object)out);
                message.put((Object)"disable.outputstream.optimization", (Object)Boolean.TRUE);
                message.getInterceptorChain().add((Interceptor)ENDING);
            }
        }
    }

    protected XMLStreamWriter createTransformWriterIfNeeded(XMLStreamWriter writer, OutputStream os) {
        return TransformUtils.createTransformWriterIfNeeded((XMLStreamWriter)writer, (OutputStream)os, this.outElementsMap, this.outDropElements, this.outAppendMap, (boolean)this.attributesToElements, (String)this.defaultNamespace);
    }

    public void setOutTransformElements(Map<String, String> outElements) {
        this.outElementsMap = outElements;
    }

    public void setOutAppendElements(Map<String, String> map) {
        this.outAppendMap = map;
    }

    public void setOutDropElements(List<String> dropElementsSet) {
        this.outDropElements = dropElementsSet;
    }

    public void setAttributesToElements(boolean value) {
        this.attributesToElements = value;
    }

    protected boolean isHttpVerbSupported(Message message) {
        return !this.isRequestor(message) || !this.isGET(message);
    }

    public void setContextPropertyName(String propertyName) {
        this.contextPropertyName = propertyName;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }
}

