/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.impl;

import org.jacorb.config.Configuration;
import org.jacorb.notification.AnyMessage;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.StructuredEventMessage;
import org.jacorb.notification.TypedEventMessage;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.servant.IProxyConsumer;
import org.jacorb.notification.util.AbstractObjectPool;
import org.jacorb.notification.util.AbstractPoolablePool;
import org.omg.CORBA.Any;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.ORB;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.StructuredEventHelper;

public class DefaultMessageFactory
implements Disposable,
MessageFactory {
    private final ORB orb;
    private final AbstractObjectPool typedEventMessagePool_ = new AbstractPoolablePool("TypedEventMessagePool"){

        public Object newInstance() {
            return new TypedEventMessage();
        }
    };
    private final AbstractObjectPool anyMessagePool_ = new AbstractPoolablePool("AnyMessagePool"){

        public Object newInstance() {
            return new AnyMessage();
        }
    };
    private final AbstractObjectPool structuredEventMessagePool_ = new AbstractPoolablePool("StructuredEventMessagePool"){

        public Object newInstance() {
            return new StructuredEventMessage(DefaultMessageFactory.this.orb);
        }
    };

    public DefaultMessageFactory(ORB oRB, Configuration configuration) {
        this.orb = oRB;
        this.anyMessagePool_.configure(configuration);
        this.structuredEventMessagePool_.configure(configuration);
        this.typedEventMessagePool_.configure(configuration);
    }

    public void dispose() {
        this.structuredEventMessagePool_.dispose();
        this.anyMessagePool_.dispose();
        this.typedEventMessagePool_.dispose();
    }

    public Message newMessage(Any any, IProxyConsumer iProxyConsumer) {
        if (StructuredEventHelper.type().equals(any.type())) {
            return this.newMessage(StructuredEventHelper.extract(any), iProxyConsumer);
        }
        AnyMessage anyMessage = this.newAnyMessage(any);
        anyMessage.initReceiveTimestamp();
        anyMessage.setFilterStage(iProxyConsumer.getFirstStage());
        return anyMessage.getHandle();
    }

    public Message newMessage(StructuredEvent structuredEvent, IProxyConsumer iProxyConsumer) {
        String string = structuredEvent.header.fixed_header.event_type.type_name;
        if ("%ANY".equals(string)) {
            return this.newMessage(structuredEvent.remainder_of_body, iProxyConsumer);
        }
        StructuredEventMessage structuredEventMessage = (StructuredEventMessage)this.structuredEventMessagePool_.lendObject();
        structuredEventMessage.initReceiveTimestamp();
        structuredEventMessage.setFilterStage(iProxyConsumer.getFirstStage());
        structuredEventMessage.setStructuredEvent(structuredEvent, iProxyConsumer.getStartTimeSupported(), iProxyConsumer.getStopTimeSupported());
        return structuredEventMessage.getHandle();
    }

    public Message newMessage(String string, String string2, NVList nVList, IProxyConsumer iProxyConsumer) {
        try {
            TypedEventMessage typedEventMessage = (TypedEventMessage)this.typedEventMessagePool_.lendObject();
            typedEventMessage.initReceiveTimestamp();
            Property[] propertyArray = new Property[nVList.count()];
            for (int i = 0; i < propertyArray.length; ++i) {
                NamedValue namedValue = nVList.item(i);
                propertyArray[i] = new Property(namedValue.name(), namedValue.value());
            }
            typedEventMessage.setTypedEvent(string, string2, propertyArray);
            typedEventMessage.setFilterStage(iProxyConsumer.getFirstStage());
            return typedEventMessage.getHandle();
        }
        catch (Bounds bounds) {
            throw new RuntimeException(bounds.toString());
        }
    }

    public Message newMessage(Property[] propertyArray) {
        TypedEventMessage typedEventMessage = (TypedEventMessage)this.typedEventMessagePool_.lendObject();
        typedEventMessage.setTypedEvent(propertyArray);
        return typedEventMessage.getHandle();
    }

    public Message newMessage(Any any) {
        if (StructuredEventHelper.type().equals(any.type())) {
            return this.newMessage(StructuredEventHelper.extract(any));
        }
        AnyMessage anyMessage = this.newAnyMessage(any);
        return anyMessage.getHandle();
    }

    private AnyMessage newAnyMessage(Any any) {
        AnyMessage anyMessage = (AnyMessage)this.anyMessagePool_.lendObject();
        anyMessage.setAny(any);
        return anyMessage;
    }

    public Message newMessage(StructuredEvent structuredEvent) {
        String string = structuredEvent.header.fixed_header.event_type.type_name;
        if ("%ANY".equals(string)) {
            return this.newMessage(structuredEvent.remainder_of_body);
        }
        StructuredEventMessage structuredEventMessage = (StructuredEventMessage)this.structuredEventMessagePool_.lendObject();
        structuredEventMessage.setStructuredEvent(structuredEvent, false, false);
        return structuredEventMessage.getHandle();
    }
}

