/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.as.clustering.registry.RegistryCollector;
import org.jboss.as.ejb3.deployment.DeploymentModuleIdentifier;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.deployment.DeploymentRepositoryListener;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.protocol.versionone.AbstractMessageHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.ClusterTopologyWriter;
import org.jboss.as.ejb3.remote.protocol.versionone.MethodInvocationMessageHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.ModuleAvailabilityWriter;
import org.jboss.as.ejb3.remote.protocol.versionone.SessionOpenRequestHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.TransactionRequestHandler;
import org.jboss.as.network.ClientMapping;
import org.jboss.logging.Logger;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.MessageInputStream;
import org.xnio.IoUtils;

public class VersionOneProtocolChannelReceiver
implements Channel.Receiver,
DeploymentRepositoryListener,
RegistryCollector.Listener<String, List<ClientMapping>> {
    private static final Logger logger = Logger.getLogger(VersionOneProtocolChannelReceiver.class);
    private static final byte HEADER_SESSION_OPEN_REQUEST = 1;
    private static final byte HEADER_INVOCATION_REQUEST = 3;
    private static final byte HEADER_TX_COMMIT_REQUEST = 15;
    private static final byte HEADER_TX_ROLLBACK_REQUEST = 16;
    private static final byte HEADER_TX_PREPARE_REQUEST = 17;
    private static final byte HEADER_TX_FORGET_REQUEST = 18;
    private static final byte HEADER_TX_BEFORE_COMPLETION_REQUEST = 19;
    private final Channel channel;
    private final DeploymentRepository deploymentRepository;
    private final EJBRemoteTransactionsRepository transactionsRepository;
    private final MarshallerFactory marshallerFactory;
    private final ExecutorService executorService;
    private final RegistryCollector<String, List<ClientMapping>> clientMappingRegistryCollector;

    public VersionOneProtocolChannelReceiver(Channel channel, DeploymentRepository deploymentRepository, EJBRemoteTransactionsRepository transactionsRepository, RegistryCollector<String, List<ClientMapping>> clientMappingRegistryCollector, MarshallerFactory marshallerFactory, ExecutorService executorService) {
        this.marshallerFactory = marshallerFactory;
        this.channel = channel;
        this.executorService = executorService;
        this.deploymentRepository = deploymentRepository;
        this.transactionsRepository = transactionsRepository;
        this.clientMappingRegistryCollector = clientMappingRegistryCollector;
    }

    public void startReceiving() {
        this.channel.addCloseHandler((CloseHandler)new ChannelCloseHandler());
        this.channel.receiveMessage((Channel.Receiver)this);
        this.deploymentRepository.addListener(this);
        this.clientMappingRegistryCollector.addListener((RegistryCollector.Listener)this);
        Collection clusters = this.clientMappingRegistryCollector.getRegistries();
        try {
            this.sendNewClusterFormedMessage(clusters);
        }
        catch (IOException ioe) {
            logger.warn((Object)("Could not send cluster formation message to the client on channel " + this.channel), (Throwable)ioe);
        }
        for (Registry cluster : clusters) {
            cluster.addListener((Registry.Listener)new ClusterTopologyUpdateListener(cluster.getName(), this));
        }
    }

    public void handleError(Channel channel, IOException error) {
        try {
            channel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.deploymentRepository.removeListener(this);
            this.clientMappingRegistryCollector.removeListener((RegistryCollector.Listener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEnd(Channel channel) {
        try {
            channel.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.deploymentRepository.removeListener(this);
            this.clientMappingRegistryCollector.removeListener((RegistryCollector.Listener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Channel channel, MessageInputStream messageInputStream) {
        try {
            int header = messageInputStream.read();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Got message with header 0x" + Integer.toHexString(header) + " on channel " + channel));
            }
            AbstractMessageHandler messageHandler = null;
            switch (header) {
                case 3: {
                    messageHandler = new MethodInvocationMessageHandler(this.deploymentRepository, this.marshallerFactory, this.executorService);
                    break;
                }
                case 1: {
                    messageHandler = new SessionOpenRequestHandler(this.deploymentRepository, this.marshallerFactory, this.executorService);
                    break;
                }
                case 15: {
                    messageHandler = new TransactionRequestHandler(this.transactionsRepository, this.marshallerFactory, this.executorService, TransactionRequestHandler.TransactionRequestType.COMMIT);
                    break;
                }
                case 16: {
                    messageHandler = new TransactionRequestHandler(this.transactionsRepository, this.marshallerFactory, this.executorService, TransactionRequestHandler.TransactionRequestType.ROLLBACK);
                    break;
                }
                case 18: {
                    messageHandler = new TransactionRequestHandler(this.transactionsRepository, this.marshallerFactory, this.executorService, TransactionRequestHandler.TransactionRequestType.FORGET);
                    break;
                }
                case 17: {
                    messageHandler = new TransactionRequestHandler(this.transactionsRepository, this.marshallerFactory, this.executorService, TransactionRequestHandler.TransactionRequestType.PREPARE);
                    break;
                }
                case 19: {
                    messageHandler = new TransactionRequestHandler(this.transactionsRepository, this.marshallerFactory, this.executorService, TransactionRequestHandler.TransactionRequestType.BEFORE_COMPLETION);
                    break;
                }
                default: {
                    logger.warn((Object)("Received unsupported message header 0x" + Integer.toHexString(header) + " on channel " + channel));
                    return;
                }
            }
            messageHandler.processMessage(channel, messageInputStream);
            channel.receiveMessage((Channel.Receiver)this);
        }
        catch (IOException e) {
            logger.errorf((Throwable)e, "Exception on channel %s from message %s", (Object)channel, (Object)messageInputStream);
            IoUtils.safeClose((Closeable)channel);
        }
        finally {
            IoUtils.safeClose((Closeable)messageInputStream);
        }
    }

    @Override
    public void listenerAdded(DeploymentRepository repository) {
        Map<DeploymentModuleIdentifier, ModuleDeployment> availableModules = this.deploymentRepository.getModules();
        if (availableModules != null && !availableModules.isEmpty()) {
            try {
                logger.debug((Object)("Sending initial module availability message, containing " + availableModules.size() + " module(s) to channel " + this.channel));
                this.sendModuleAvailability(availableModules.keySet().toArray(new DeploymentModuleIdentifier[availableModules.size()]));
            }
            catch (IOException e) {
                logger.warn((Object)("Could not send initial module availability report to channel " + this.channel), (Throwable)e);
            }
        }
    }

    @Override
    public void deploymentAvailable(DeploymentModuleIdentifier deploymentModuleIdentifier, ModuleDeployment moduleDeployment) {
        try {
            this.sendModuleAvailability(new DeploymentModuleIdentifier[]{deploymentModuleIdentifier});
        }
        catch (IOException e) {
            logger.warn((Object)("Could not send module availability notification of module " + deploymentModuleIdentifier + " to channel " + this.channel), (Throwable)e);
        }
    }

    @Override
    public void deploymentRemoved(DeploymentModuleIdentifier deploymentModuleIdentifier) {
        try {
            this.sendModuleUnAvailability(new DeploymentModuleIdentifier[]{deploymentModuleIdentifier});
        }
        catch (IOException e) {
            logger.warn((Object)("Could not send module un-availability notification of module " + deploymentModuleIdentifier + " to channel " + this.channel), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendModuleAvailability(DeploymentModuleIdentifier[] availableModules) throws IOException {
        DataOutputStream outputStream = new DataOutputStream((OutputStream)this.channel.writeMessage());
        ModuleAvailabilityWriter moduleAvailabilityWriter = new ModuleAvailabilityWriter();
        try {
            moduleAvailabilityWriter.writeModuleAvailability(outputStream, availableModules);
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendModuleUnAvailability(DeploymentModuleIdentifier[] availableModules) throws IOException {
        DataOutputStream outputStream = new DataOutputStream((OutputStream)this.channel.writeMessage());
        ModuleAvailabilityWriter moduleAvailabilityWriter = new ModuleAvailabilityWriter();
        try {
            moduleAvailabilityWriter.writeModuleUnAvailability(outputStream, availableModules);
        }
        finally {
            outputStream.close();
        }
    }

    public void registryAdded(Registry<String, List<ClientMapping>> registry) {
        try {
            logger.debug((Object)("Received new cluster formation notification for cluster " + registry.getName()));
            this.sendNewClusterFormedMessage(Collections.singleton(registry));
        }
        catch (IOException ioe) {
            logger.warn((Object)("Could not send a cluster formation message for cluster: " + registry.getName() + " to the client on channel " + this.channel), (Throwable)ioe);
        }
    }

    public void registryRemoved(Registry<String, List<ClientMapping>> registry) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNewClusterFormedMessage(Collection<Registry<String, List<ClientMapping>>> clientMappingRegistries) throws IOException {
        DataOutputStream outputStream = new DataOutputStream((OutputStream)this.channel.writeMessage());
        ClusterTopologyWriter clusterTopologyWriter = new ClusterTopologyWriter();
        try {
            logger.debug((Object)("Writing out cluster formation message for " + clientMappingRegistries.size() + " clusters, to channel " + this.channel));
            clusterTopologyWriter.writeCompleteClusterTopology(outputStream, clientMappingRegistries);
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendClusterRemovedMessage(Registry<String, List<ClientMapping>> registry) throws IOException {
        DataOutputStream outputStream = new DataOutputStream((OutputStream)this.channel.writeMessage());
        ClusterTopologyWriter clusterTopologyWriter = new ClusterTopologyWriter();
        try {
            logger.debug((Object)("Cluster " + registry.getName() + " removed, writing cluster removal message to channel " + this.channel));
            clusterTopologyWriter.writeClusterRemoved(outputStream, Collections.singleton(registry));
        }
        finally {
            outputStream.close();
        }
    }

    private class ClusterTopologyUpdateListener
    implements Registry.Listener<String, List<ClientMapping>> {
        private final String clusterName;
        private final VersionOneProtocolChannelReceiver channelReceiver;

        ClusterTopologyUpdateListener(String clusterName, VersionOneProtocolChannelReceiver channelReceiver) {
            this.channelReceiver = channelReceiver;
            this.clusterName = clusterName;
        }

        public void addedEntries(Map<String, List<ClientMapping>> added) {
            try {
                this.sendClusterNodesAdded(added);
            }
            catch (IOException ioe) {
                logger.warn((Object)("Could not write a new cluster node addition message to channel " + this.channelReceiver.channel), (Throwable)ioe);
            }
        }

        public void updatedEntries(Map<String, List<ClientMapping>> updated) {
        }

        public void removedEntries(Set<String> removed) {
            try {
                this.sendClusterNodesRemoved(removed);
            }
            catch (IOException ioe) {
                logger.warn((Object)("Could not write a cluster node removal message to channel " + this.channelReceiver.channel), (Throwable)ioe);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendClusterNodesRemoved(Set<String> removedNodes) throws IOException {
            DataOutputStream outputStream = new DataOutputStream((OutputStream)this.channelReceiver.channel.writeMessage());
            ClusterTopologyWriter clusterTopologyWriter = new ClusterTopologyWriter();
            try {
                logger.debug((Object)(removedNodes.size() + " nodes removed from cluster " + this.clusterName + ", writing a protocol message to channel " + this.channelReceiver.channel));
                clusterTopologyWriter.writeNodesRemoved(outputStream, this.clusterName, removedNodes);
            }
            finally {
                outputStream.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendClusterNodesAdded(Map<String, List<ClientMapping>> addedNodes) throws IOException {
            DataOutputStream outputStream = new DataOutputStream((OutputStream)this.channelReceiver.channel.writeMessage());
            ClusterTopologyWriter clusterTopologyWriter = new ClusterTopologyWriter();
            try {
                logger.debug((Object)(addedNodes.size() + " nodes added to cluster " + this.clusterName + ", writing a protocol message to channel " + this.channelReceiver.channel));
                clusterTopologyWriter.writeNewNodesAdded(outputStream, this.clusterName, addedNodes);
            }
            finally {
                outputStream.close();
            }
        }
    }

    private class ChannelCloseHandler
    implements CloseHandler<Channel> {
        private ChannelCloseHandler() {
        }

        public void handleClose(Channel closedChannel, IOException exception) {
            logger.debug((Object)("Channel " + closedChannel + " closed"));
            VersionOneProtocolChannelReceiver.this.deploymentRepository.removeListener(VersionOneProtocolChannelReceiver.this);
            VersionOneProtocolChannelReceiver.this.clientMappingRegistryCollector.removeListener((RegistryCollector.Listener)VersionOneProtocolChannelReceiver.this);
        }
    }
}

