/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import org.jboss.as.ejb3.remote.SecurityActions;
import org.jboss.as.ejb3.remote.TCCLEJBClientContextSelectorService;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.logging.Logger;

class TCCLEJBClientContextSelector
implements ContextSelector<EJBClientContext> {
    private static final Logger logger = Logger.getLogger(TCCLEJBClientContextSelector.class);
    static final TCCLEJBClientContextSelector INSTANCE = new TCCLEJBClientContextSelector();
    private volatile TCCLEJBClientContextSelectorService tcclEJBClientContextService;
    private volatile EJBClientContext defaultEJBClientContext;

    TCCLEJBClientContextSelector() {
    }

    void setup(TCCLEJBClientContextSelectorService clientContextService, EJBClientContext defaultEJBClientContext) {
        this.tcclEJBClientContextService = clientContextService;
        this.defaultEJBClientContext = defaultEJBClientContext;
    }

    void destroy() {
        this.tcclEJBClientContextService = null;
        this.defaultEJBClientContext = null;
    }

    public EJBClientContext getCurrent() {
        if (this.tcclEJBClientContextService == null) {
            return null;
        }
        EJBClientContext ejbClientContext = this.tcclEJBClientContextService.getCurrent();
        if (ejbClientContext != null) {
            return ejbClientContext;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning default EJB client context " + this.defaultEJBClientContext + " since no EJB client context could be found for TCCL " + SecurityActions.getContextClassLoader()));
        }
        return this.defaultEJBClientContext;
    }
}

